/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.storage;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.PreferenceDataStore;
import com.urbanairship.UALog;
import com.urbanairship.audience.AudienceSelector;
import com.urbanairship.automation.storage.AutomationDao;
import com.urbanairship.automation.storage.FullSchedule;
import com.urbanairship.automation.storage.LegacyDataManager;
import com.urbanairship.automation.storage.ScheduleEntity;
import com.urbanairship.automation.storage.TriggerEntity;
import com.urbanairship.config.AirshipRuntimeConfig;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonPredicate;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.UAStringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class LegacyDataMigrator {
    private static final String LEGACY_SCHEDULED_MESSAGES_KEY = "com.urbanairship.iam.data.SCHEDULED_MESSAGES";
    private final Context context;
    private final AirshipRuntimeConfig config;
    private final PreferenceDataStore dataStore;

    public LegacyDataMigrator(@NonNull Context context, @NonNull AirshipRuntimeConfig runtimeConfig, @NonNull PreferenceDataStore dataStore) {
        this.context = context.getApplicationContext();
        this.config = runtimeConfig;
        this.dataStore = dataStore;
    }

    public void migrateData(final @NonNull AutomationDao dao) {
        LegacyDataManager iamDataManager;
        LegacyDataManager actionDataManager = new LegacyDataManager(this.context, this.config.getConfigOptions().appKey, "ua_automation.db");
        if (actionDataManager.databaseExists(this.context)) {
            UALog.v((String)"Migrating actions automation database.", (Object[])new Object[0]);
            this.migrateDatabase(actionDataManager, new Migrator(){

                @Override
                public void onMigrate(@NonNull ScheduleEntity scheduleEntity, @NonNull List<TriggerEntity> triggerEntities) {
                    scheduleEntity.scheduleType = "actions";
                    UALog.v((String)"Saving migrated action schedule: %s triggers: %s", (Object[])new Object[]{scheduleEntity, triggerEntities});
                    dao.insert(new FullSchedule(scheduleEntity, triggerEntities));
                }
            });
        }
        if ((iamDataManager = new LegacyDataManager(this.context, this.config.getConfigOptions().appKey, "in-app")).databaseExists(this.context)) {
            UALog.v((String)"Migrating in-app message database.", (Object[])new Object[0]);
            Set knownRemoteScheduleIds = this.dataStore.getJsonValue(LEGACY_SCHEDULED_MESSAGES_KEY).optMap().keySet();
            this.migrateDatabase(iamDataManager, new MessageMigrator(dao, knownRemoteScheduleIds));
            this.dataStore.remove(LEGACY_SCHEDULED_MESSAGES_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateDatabase(@NonNull LegacyDataManager dataManager, @Nullable Migrator migrator) {
        Cursor cursor = null;
        try {
            cursor = dataManager.querySchedules();
            if (cursor != null) {
                this.migrateDataFromCursor(cursor, migrator);
            }
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Error when migrating database.", (Object[])new Object[0]);
        }
        finally {
            this.closeCursor(cursor);
            dataManager.deleteAllSchedules();
            dataManager.close();
            dataManager.deleteDatabase(this.context);
        }
    }

    private void migrateDataFromCursor(@NonNull Cursor cursor, @NonNull Migrator migrator) {
        ScheduleEntity scheduleEntity = null;
        ArrayList<TriggerEntity> triggerEntities = new ArrayList<TriggerEntity>();
        String currentScheduleId = null;
        cursor.moveToFirst();
        while (!cursor.isAfterLast()) {
            String scheduleId = cursor.getString(cursor.getColumnIndex("s_id"));
            if (!UAStringUtil.equals(currentScheduleId, (String)scheduleId)) {
                if (scheduleEntity != null) {
                    migrator.onMigrate(scheduleEntity, triggerEntities);
                }
                currentScheduleId = scheduleId;
                triggerEntities.clear();
                scheduleEntity = null;
            }
            if (scheduleEntity == null) {
                try {
                    JsonValue dataJson;
                    scheduleEntity = new ScheduleEntity();
                    scheduleEntity.scheduleId = cursor.getString(cursor.getColumnIndex("s_id"));
                    scheduleEntity.metadata = JsonValue.parseString((String)cursor.getString(cursor.getColumnIndex("s_metadata"))).optMap();
                    scheduleEntity.count = cursor.getInt(cursor.getColumnIndex("s_count"));
                    scheduleEntity.limit = cursor.getInt(cursor.getColumnIndex("s_limit"));
                    scheduleEntity.priority = cursor.getInt(cursor.getColumnIndex("s_priority"));
                    scheduleEntity.group = cursor.getString(cursor.getColumnIndex("s_group"));
                    scheduleEntity.editGracePeriod = cursor.getLong(cursor.getColumnIndex("s_edit_grace_period"));
                    scheduleEntity.scheduleEnd = cursor.getLong(cursor.getColumnIndex("s_end"));
                    scheduleEntity.scheduleStart = cursor.getLong(cursor.getColumnIndex("s_start"));
                    scheduleEntity.executionState = cursor.getInt(cursor.getColumnIndex("s_execution_state"));
                    scheduleEntity.executionStateChangeDate = cursor.getLong(cursor.getColumnIndex("s_execution_state_change_date"));
                    scheduleEntity.appState = cursor.getInt(cursor.getColumnIndex("d_app_state"));
                    scheduleEntity.regionId = cursor.getString(cursor.getColumnIndex("d_region_id"));
                    scheduleEntity.interval = cursor.getLong(cursor.getColumnIndex("s_interval"));
                    scheduleEntity.seconds = cursor.getLong(cursor.getColumnIndex("d_seconds"));
                    scheduleEntity.screens = this.parseScreens(JsonValue.parseString((String)cursor.getString(cursor.getColumnIndex("d_screen"))));
                    scheduleEntity.data = dataJson = JsonValue.parseString((String)cursor.getString(cursor.getColumnIndex("s_data")));
                }
                catch (JsonException e) {
                    UALog.e((Throwable)e, (String)"Failed to parse schedule entry.", (Object[])new Object[0]);
                    continue;
                }
            }
            if (cursor.getColumnIndex("t_type") != -1) {
                TriggerEntity triggerEntity = new TriggerEntity();
                triggerEntity.parentScheduleId = scheduleEntity.scheduleId;
                triggerEntity.triggerType = cursor.getInt(cursor.getColumnIndex("t_type"));
                triggerEntity.goal = cursor.getDouble(cursor.getColumnIndex("t_goal"));
                triggerEntity.progress = cursor.getDouble(cursor.getColumnIndex("t_progress"));
                triggerEntity.jsonPredicate = this.parseJsonPredicate(cursor.getString(cursor.getColumnIndex("t_predicate")));
                triggerEntity.isCancellation = cursor.getInt(cursor.getColumnIndex("t_cancellation")) == 1;
                triggerEntities.add(triggerEntity);
            }
            cursor.moveToNext();
        }
        if (scheduleEntity != null) {
            migrator.onMigrate(scheduleEntity, triggerEntities);
        }
    }

    private List<String> parseScreens(JsonValue json) {
        ArrayList<String> screens = new ArrayList<String>();
        if (json.isJsonList()) {
            for (JsonValue value : json.optList()) {
                if (value.getString() == null) continue;
                screens.add(value.getString());
            }
        } else {
            String oldScreenName = json.getString();
            if (oldScreenName != null) {
                screens.add(oldScreenName);
            }
        }
        return screens;
    }

    @Nullable
    private JsonPredicate parseJsonPredicate(String payload) {
        try {
            JsonValue jsonValue = JsonValue.parseString((String)payload);
            if (!jsonValue.isNull()) {
                return JsonPredicate.parse((JsonValue)jsonValue);
            }
        }
        catch (JsonException e) {
            UALog.e((Throwable)e, (String)"Failed to parse JSON predicate.", (Object[])new Object[0]);
            return null;
        }
        return null;
    }

    private void closeCursor(@Nullable Cursor cursor) {
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (SQLException e) {
            UALog.e((Throwable)e, (String)"Failed to close cursor.", (Object[])new Object[0]);
        }
    }

    private static class MessageMigrator
    implements Migrator {
        private final Set<String> knownRemoteScheduleIds;
        private final Set<String> messageIds;
        private final AutomationDao dao;

        private MessageMigrator(@NonNull AutomationDao dao, @NonNull Set<String> knownRemoteScheduleIds) {
            this.dao = dao;
            this.knownRemoteScheduleIds = knownRemoteScheduleIds;
            this.messageIds = new HashSet<String>();
        }

        private String getUniqueId(String messageId) {
            String uniqueId = messageId;
            int i = 0;
            while (this.messageIds.contains(uniqueId)) {
                uniqueId = messageId + "#" + ++i;
            }
            return uniqueId;
        }

        @Override
        public void onMigrate(@NonNull ScheduleEntity scheduleEntity, @NonNull List<TriggerEntity> triggerEntities) {
            scheduleEntity.scheduleType = "in_app_message";
            if (this.knownRemoteScheduleIds.contains(scheduleEntity.scheduleId)) {
                scheduleEntity.data = JsonMap.newBuilder().putAll(scheduleEntity.data.optMap()).put("source", "remote-data").build().toJsonValue();
            }
            String messageId = scheduleEntity.data.optMap().opt("message_id").getString(scheduleEntity.scheduleId);
            if ("app-defined".equals(scheduleEntity.data.optMap().opt("source").optString())) {
                scheduleEntity.metadata = JsonMap.newBuilder().putAll(scheduleEntity.metadata).put("com.urbanairship.original_schedule_id", scheduleEntity.scheduleId).put("com.urbanairship.original_message_id", messageId).build();
                messageId = this.getUniqueId(messageId);
            }
            scheduleEntity.scheduleId = messageId;
            for (TriggerEntity triggerEntity : triggerEntities) {
                triggerEntity.parentScheduleId = messageId;
            }
            this.messageIds.add(messageId);
            JsonValue audienceJson = scheduleEntity.data.optMap().get("audience");
            if (audienceJson != null) {
                try {
                    scheduleEntity.audience = AudienceSelector.Companion.fromJson(audienceJson);
                }
                catch (JsonException e) {
                    UALog.e((Throwable)e, (String)"Unable to schedule due to audience JSON", (Object[])new Object[0]);
                    return;
                }
            }
            UALog.v((String)"Saving migrated message schedule: %s triggers: %s", (Object[])new Object[]{scheduleEntity, triggerEntities});
            this.dao.insert(new FullSchedule(scheduleEntity, triggerEntities));
        }
    }

    static interface Migrator {
        public void onMigrate(@NonNull ScheduleEntity var1, @NonNull List<TriggerEntity> var2);
    }
}

