/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.automation.tags;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.Size;
import androidx.core.util.ObjectsCompat;
import com.urbanairship.audience.DeviceTagSelector;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TagSelector
implements JsonSerializable {
    private DeviceTagSelector tagSelector;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public TagSelector(DeviceTagSelector core) {
        this.tagSelector = core;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public DeviceTagSelector getTagSelector() {
        return this.tagSelector;
    }

    @NonNull
    public static TagSelector and(@NonNull @Size(min=1L) List<TagSelector> selectors) {
        return new TagSelector(DeviceTagSelector.Companion.and(TagSelector.convert(selectors)));
    }

    @NonNull
    public static TagSelector and(TagSelector ... selectors) {
        return new TagSelector(DeviceTagSelector.Companion.and(TagSelector.convert(Arrays.asList(selectors))));
    }

    @NonNull
    public static TagSelector or(@NonNull @Size(min=1L) List<TagSelector> selectors) {
        return new TagSelector(DeviceTagSelector.Companion.or(TagSelector.convert(selectors)));
    }

    @NonNull
    public static TagSelector or(TagSelector ... selectors) {
        return new TagSelector(DeviceTagSelector.Companion.or(TagSelector.convert(Arrays.asList(selectors))));
    }

    @NonNull
    public static TagSelector not(@NonNull TagSelector selector) {
        return new TagSelector(DeviceTagSelector.Companion.not(selector.tagSelector));
    }

    @NonNull
    public static TagSelector tag(@NonNull String tag) {
        return new TagSelector(DeviceTagSelector.Companion.tag(tag));
    }

    @NonNull
    public static TagSelector fromJson(@NonNull JsonValue value) throws JsonException {
        return new TagSelector(DeviceTagSelector.Companion.fromJson(value));
    }

    private static List<DeviceTagSelector> convert(List<TagSelector> input) {
        ArrayList<DeviceTagSelector> result = new ArrayList<DeviceTagSelector>();
        for (TagSelector selector : input) {
            result.add(selector.tagSelector);
        }
        return result;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return this.tagSelector.toJsonValue();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean apply(@NonNull Collection<String> tags) {
        return this.tagSelector.apply(tags);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagSelector that = (TagSelector)o;
        return that.tagSelector.equals((Object)this.tagSelector);
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.tagSelector});
    }

    @NonNull
    public String toString() {
        return this.toJsonValue().toString();
    }
}

