/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.urbanairship.UALog;
import com.urbanairship.experiment.ExperimentResult;
import com.urbanairship.iam.DisplayCoordinator;
import com.urbanairship.iam.DisplayHandler;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.InAppMessageAdapter;
import com.urbanairship.iam.assets.Assets;
import com.urbanairship.json.JsonValue;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
final class AdapterWrapper {
    public final String scheduleId;
    public final JsonValue campaigns;
    public final JsonValue reportingContext;
    public final InAppMessage message;
    public final InAppMessageAdapter adapter;
    public final DisplayCoordinator coordinator;
    @Nullable
    public final ExperimentResult experimentResult;
    public boolean displayed = false;

    AdapterWrapper(@NonNull String scheduleId, @Nullable JsonValue campaigns, @Nullable JsonValue reportingContext, @NonNull InAppMessage message, @NonNull InAppMessageAdapter adapter, @NonNull DisplayCoordinator coordinator, @Nullable ExperimentResult experimentResult) {
        this.scheduleId = scheduleId;
        this.campaigns = campaigns == null ? JsonValue.NULL : campaigns;
        this.reportingContext = reportingContext == null ? JsonValue.NULL : reportingContext;
        this.message = message;
        this.adapter = adapter;
        this.coordinator = coordinator;
        this.experimentResult = experimentResult;
    }

    int prepare(@NonNull Context context, @NonNull Assets assets) {
        try {
            UALog.d((String)"Preparing message for schedule %s", (Object[])new Object[]{this.scheduleId});
            return this.adapter.onPrepare(context, assets);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"AdapterWrapper - Exception during prepare(Context).", (Object[])new Object[0]);
            return 1;
        }
    }

    boolean isReady(@NonNull Context context) {
        try {
            return this.adapter.isReady(context) && this.coordinator.isReady();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"AdapterWrapper - Exception during isReady(Activity).", (Object[])new Object[0]);
            return false;
        }
    }

    void display(@NonNull Context context) throws DisplayException {
        UALog.d((String)"Displaying message for schedule %s", (Object[])new Object[]{this.scheduleId});
        this.displayed = true;
        try {
            DisplayHandler displayHandler = new DisplayHandler(this.scheduleId, this.message.isReportingEnabled(), this.campaigns, this.reportingContext, this.experimentResult);
            this.adapter.onDisplay(context, displayHandler);
            this.coordinator.onDisplayStarted(this.message);
        }
        catch (Exception e) {
            throw new DisplayException("Adapter onDisplay(Activity, boolean, DisplayHandler) unexpected exception", e);
        }
    }

    @MainThread
    void displayFinished() {
        UALog.d((String)"Display finished for schedule %s", (Object[])new Object[]{this.scheduleId});
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                this.coordinator.onDisplayFinished(this.message);
            }
            catch (Exception e) {
                UALog.e((Throwable)e, (String)"AdapterWrapper - Exception during onDisplayFinished().", (Object[])new Object[0]);
            }
        });
    }

    @WorkerThread
    void adapterFinished(@NonNull Context context) {
        UALog.d((String)"Adapter finished for schedule %s", (Object[])new Object[]{this.scheduleId});
        try {
            this.adapter.onFinish(context);
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"AdapterWrapper - Exception during finish().", (Object[])new Object[0]);
        }
    }

    static class DisplayException
    extends Exception {
        DisplayException(String message, Exception e) {
            super(message, e);
        }
    }
}

