/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.urbanairship.iam.TextInfo;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.Checks;
import com.urbanairship.util.ColorUtils;
import com.urbanairship.util.UAStringUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ButtonInfo
implements JsonSerializable {
    public static final int MAX_ID_LENGTH = 100;
    private static final String LABEL_KEY = "label";
    private static final String ID_KEY = "id";
    private static final String BEHAVIOR_KEY = "behavior";
    private static final String BORDER_RADIUS_KEY = "border_radius";
    private static final String BACKGROUND_COLOR_KEY = "background_color";
    private static final String BORDER_COLOR_KEY = "border_color";
    private static final String ACTIONS_KEY = "actions";
    @NonNull
    public static final String BEHAVIOR_CANCEL = "cancel";
    @NonNull
    public static final String BEHAVIOR_DISMISS = "dismiss";
    private final TextInfo label;
    private final String id;
    private final String behavior;
    private final Float borderRadius;
    private final Integer backgroundColor;
    private final Integer borderColor;
    private final Map<String, JsonValue> actions;

    private ButtonInfo(@NonNull Builder builder) {
        this.label = builder.label;
        this.id = builder.id;
        this.behavior = builder.behavior;
        this.borderRadius = Float.valueOf(builder.borderRadius);
        this.backgroundColor = builder.backgroundColor;
        this.borderColor = builder.borderColor;
        this.actions = builder.actions;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put(LABEL_KEY, (JsonSerializable)this.label).put(ID_KEY, this.id).put(BEHAVIOR_KEY, this.behavior).putOpt(BORDER_RADIUS_KEY, (Object)this.borderRadius).putOpt(BACKGROUND_COLOR_KEY, this.backgroundColor == null ? null : ColorUtils.convertToString((int)this.backgroundColor)).putOpt(BORDER_COLOR_KEY, this.borderColor == null ? null : ColorUtils.convertToString((int)this.borderColor)).put(ACTIONS_KEY, (JsonSerializable)JsonValue.wrapOpt(this.actions)).build().toJsonValue();
    }

    @NonNull
    public static ButtonInfo fromJson(@NonNull JsonValue value) throws JsonException {
        JsonMap content = value.optMap();
        Builder builder = ButtonInfo.newBuilder();
        if (content.containsKey(LABEL_KEY)) {
            builder.setLabel(TextInfo.fromJson(content.opt(LABEL_KEY)));
        }
        if (content.opt(ID_KEY).isString()) {
            builder.setId(content.opt(ID_KEY).optString());
        }
        if (content.containsKey(BEHAVIOR_KEY)) {
            switch (content.opt(BEHAVIOR_KEY).optString()) {
                case "cancel": {
                    builder.setBehavior(BEHAVIOR_CANCEL);
                    break;
                }
                case "dismiss": {
                    builder.setBehavior(BEHAVIOR_DISMISS);
                    break;
                }
                default: {
                    throw new JsonException("Unexpected behavior: " + content.opt(BEHAVIOR_KEY));
                }
            }
        }
        if (content.containsKey(BORDER_RADIUS_KEY)) {
            if (!content.opt(BORDER_RADIUS_KEY).isNumber()) {
                throw new JsonException("Border radius must be a number: " + content.opt(BORDER_RADIUS_KEY));
            }
            builder.setBorderRadius(content.opt(BORDER_RADIUS_KEY).getFloat(0.0f));
        }
        if (content.containsKey(BACKGROUND_COLOR_KEY)) {
            try {
                builder.setBackgroundColor(Color.parseColor((String)content.opt(BACKGROUND_COLOR_KEY).optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid background button color: " + content.opt(BACKGROUND_COLOR_KEY), (Throwable)e);
            }
        }
        if (content.containsKey(BORDER_COLOR_KEY)) {
            try {
                builder.setBorderColor(Color.parseColor((String)content.opt(BORDER_COLOR_KEY).optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid border color: " + content.opt(BORDER_COLOR_KEY), (Throwable)e);
            }
        }
        if (content.containsKey(ACTIONS_KEY)) {
            JsonMap jsonMap = content.opt(ACTIONS_KEY).getMap();
            if (jsonMap == null) {
                throw new JsonException("Actions must be a JSON object: " + content.opt(ACTIONS_KEY));
            }
            builder.setActions(jsonMap.getMap());
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid button JSON: " + content, (Throwable)e);
        }
    }

    @NonNull
    public static List<ButtonInfo> fromJson(@NonNull JsonList jsonList) throws JsonException {
        if (jsonList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ButtonInfo> buttons = new ArrayList<ButtonInfo>();
        for (JsonValue value : jsonList) {
            buttons.add(ButtonInfo.fromJson(value));
        }
        return buttons;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public TextInfo getLabel() {
        return this.label;
    }

    @NonNull
    public String getBehavior() {
        return this.behavior;
    }

    @ColorInt
    @Nullable
    public Integer getBackgroundColor() {
        return this.backgroundColor;
    }

    @ColorInt
    @Nullable
    public Integer getBorderColor() {
        return this.borderColor;
    }

    @Nullable
    public Float getBorderRadius() {
        return this.borderRadius;
    }

    @NonNull
    public Map<String, JsonValue> getActions() {
        return this.actions;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ButtonInfo that = (ButtonInfo)o;
        if (this.label != null ? !this.label.equals(that.label) : that.label != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.behavior != null ? !this.behavior.equals(that.behavior) : that.behavior != null) {
            return false;
        }
        if (!this.borderRadius.equals(that.borderRadius)) {
            return false;
        }
        if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) {
            return false;
        }
        if (this.borderColor != null ? !this.borderColor.equals(that.borderColor) : that.borderColor != null) {
            return false;
        }
        return this.actions != null ? this.actions.equals(that.actions) : that.actions == null;
    }

    public int hashCode() {
        int result = this.label != null ? this.label.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.behavior != null ? this.behavior.hashCode() : 0);
        result = 31 * result + this.borderRadius.hashCode();
        result = 31 * result + (this.backgroundColor != null ? this.backgroundColor.hashCode() : 0);
        result = 31 * result + (this.borderColor != null ? this.borderColor.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return this.toJsonValue().toString();
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public static Builder newBuilder(@NonNull ButtonInfo buttonInfo) {
        return new Builder(buttonInfo);
    }

    public static class Builder {
        private TextInfo label;
        private String id;
        private String behavior = "dismiss";
        private float borderRadius = 0.0f;
        private Integer backgroundColor;
        private Integer borderColor;
        private final Map<String, JsonValue> actions = new HashMap<String, JsonValue>();

        private Builder() {
        }

        private Builder(@NonNull ButtonInfo buttonInfo) {
            this.label = buttonInfo.label;
            this.id = buttonInfo.id;
            this.behavior = buttonInfo.behavior;
            this.borderRadius = buttonInfo.borderRadius.floatValue();
            this.backgroundColor = buttonInfo.backgroundColor;
            this.borderColor = buttonInfo.borderColor;
            this.actions.putAll(buttonInfo.actions);
        }

        @NonNull
        public Builder setLabel(@NonNull TextInfo label) {
            this.label = label;
            return this;
        }

        @NonNull
        public Builder setId(@NonNull @Size(min=1L, max=100L) String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder setBehavior(@NonNull String behavior) {
            this.behavior = behavior;
            return this;
        }

        @NonNull
        public Builder setBorderRadius(@FloatRange(from=0.0) float borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        @NonNull
        public Builder setBorderColor(@ColorInt int borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        @NonNull
        public Builder setBackgroundColor(@ColorInt int backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        @NonNull
        public Builder setActions(@Nullable Map<String, JsonValue> actions) {
            this.actions.clear();
            if (actions != null) {
                this.actions.putAll(actions);
            }
            return this;
        }

        @NonNull
        public Builder addAction(@NonNull String actionName, @NonNull JsonSerializable actionValue) {
            this.actions.put(actionName, actionValue.toJsonValue());
            return this;
        }

        @NonNull
        public ButtonInfo build() {
            return this.build(true);
        }

        @NonNull
        public ButtonInfo build(Boolean enforceMaxIdLength) {
            Checks.checkArgument((this.borderRadius >= 0.0f ? 1 : 0) != 0, (String)"Border radius must be >= 0");
            Checks.checkArgument((!UAStringUtil.isEmpty((String)this.id) ? 1 : 0) != 0, (String)"Missing ID.");
            if (enforceMaxIdLength.booleanValue()) {
                Checks.checkArgument((this.id.length() <= 100 ? 1 : 0) != 0, (String)"Id exceeds max ID length: 100");
            }
            Checks.checkArgument((this.label != null ? 1 : 0) != 0, (String)"Missing label.");
            return new ButtonInfo(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Behavior {
    }
}

