/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.urbanairship.iam.DisplayCoordinator;
import com.urbanairship.iam.InAppMessage;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class DefaultDisplayCoordinator
extends DisplayCoordinator {
    private InAppMessage currentMessage = null;
    private boolean isLocked = false;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private long displayInterval;
    private final Runnable postDisplayRunnable = new Runnable(){

        @Override
        public void run() {
            if (DefaultDisplayCoordinator.this.currentMessage == null) {
                DefaultDisplayCoordinator.this.isLocked = false;
                DefaultDisplayCoordinator.this.notifyDisplayReady();
            }
        }
    };

    DefaultDisplayCoordinator(long displayInterval) {
        this.displayInterval = displayInterval;
    }

    void setDisplayInterval(@IntRange(from=0L) long time, @NonNull TimeUnit timeUnit) {
        this.displayInterval = timeUnit.toMillis(time);
    }

    long getDisplayInterval() {
        return this.displayInterval;
    }

    @Override
    @MainThread
    public boolean isReady() {
        if (this.currentMessage != null) {
            return false;
        }
        return !this.isLocked;
    }

    @Override
    @MainThread
    public void onDisplayStarted(@NonNull InAppMessage message) {
        this.currentMessage = message;
        this.isLocked = true;
        this.mainHandler.removeCallbacks(this.postDisplayRunnable);
    }

    @Override
    @MainThread
    public void onDisplayFinished(@NonNull InAppMessage message) {
        this.currentMessage = null;
        this.mainHandler.postDelayed(this.postDisplayRunnable, this.displayInterval);
    }
}

