/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.iam.InAppMessage;

public abstract class DisplayCoordinator {
    private OnDisplayReadyCallback displayReadyCallback;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void setDisplayReadyCallback(@Nullable OnDisplayReadyCallback displayReadyCallback) {
        this.displayReadyCallback = displayReadyCallback;
    }

    @MainThread
    @CallSuper
    public final void notifyDisplayReady() {
        OnDisplayReadyCallback callback = this.displayReadyCallback;
        if (callback != null) {
            callback.onReady();
        }
    }

    @MainThread
    public abstract boolean isReady();

    @MainThread
    public abstract void onDisplayStarted(@NonNull InAppMessage var1);

    @MainThread
    public abstract void onDisplayFinished(@NonNull InAppMessage var1);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static interface OnDisplayReadyCallback {
        public void onReady();
    }
}

