/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.Autopilot;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.analytics.Analytics;
import com.urbanairship.automation.InAppAutomation;
import com.urbanairship.experiment.ExperimentResult;
import com.urbanairship.iam.ResolutionInfo;
import com.urbanairship.iam.events.InAppReportingEvent;
import com.urbanairship.json.JsonValue;

public class DisplayHandler
implements Parcelable {
    private final String scheduleId;
    private final boolean isReportingAllowed;
    private final JsonValue campaigns;
    private final JsonValue reportingContext;
    private final ExperimentResult experimentResult;
    @NonNull
    public static final Parcelable.Creator<DisplayHandler> CREATOR = new Parcelable.Creator<DisplayHandler>(){

        @NonNull
        public DisplayHandler createFromParcel(@NonNull Parcel in) {
            try {
                String scheduleId = in.readString();
                boolean isReportingAllowed = in.readInt() != 0;
                JsonValue campaigns = JsonValue.parseString((String)in.readString());
                JsonValue reportingContext = JsonValue.parseString((String)in.readString());
                JsonValue experimentResultJSON = JsonValue.parseString((String)in.readString());
                ExperimentResult experimentResult = null;
                if (!experimentResultJSON.isNull()) {
                    experimentResult = ExperimentResult.Companion.fromJson(experimentResultJSON.optMap());
                }
                return new DisplayHandler(scheduleId == null ? "" : scheduleId, isReportingAllowed, campaigns, reportingContext, experimentResult);
            }
            catch (Exception e) {
                UALog.e((Throwable)e, (String)"failed to create display handler", (Object[])new Object[0]);
                return new DisplayHandler("", false, JsonValue.NULL, JsonValue.NULL, null);
            }
        }

        @NonNull
        public DisplayHandler[] newArray(int size) {
            return new DisplayHandler[size];
        }
    };

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public DisplayHandler(@NonNull String scheduleId, boolean isReportingAllowed, @NonNull JsonValue campaigns, @NonNull JsonValue reportingContext, @Nullable ExperimentResult experimentResult) {
        this.scheduleId = scheduleId;
        this.isReportingAllowed = isReportingAllowed;
        this.campaigns = campaigns;
        this.reportingContext = reportingContext;
        this.experimentResult = experimentResult;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.scheduleId);
        dest.writeInt(this.isReportingAllowed ? 1 : 0);
        dest.writeString(this.campaigns.toString());
        dest.writeString(this.reportingContext.toString());
        dest.writeString(this.experimentResult == null ? JsonValue.NULL.getString() : this.experimentResult.toJsonValue().toString());
    }

    public int describeContents() {
        return 0;
    }

    public void finished(@NonNull ResolutionInfo resolutionInfo, long displayMilliseconds) {
        InAppAutomation inAppAutomation = this.getInAppAutomation();
        if (inAppAutomation == null) {
            UALog.e((String)"Takeoff not called. Unable to finish display for schedule: %s", (Object[])new Object[]{this.scheduleId});
            return;
        }
        inAppAutomation.getInAppMessageManager().onResolution(this.scheduleId, resolutionInfo, displayMilliseconds);
        this.notifyFinished(resolutionInfo);
        if (resolutionInfo.getButtonInfo() != null && "cancel".equals(resolutionInfo.getButtonInfo().getBehavior())) {
            inAppAutomation.cancelSchedule(this.scheduleId);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void notifyFinished(@NonNull ResolutionInfo resolutionInfo) {
        InAppAutomation inAppAutomation = this.getInAppAutomation();
        if (inAppAutomation == null) {
            UALog.e((String)"Takeoff not called. Unable to finish display for schedule: %s", (Object[])new Object[]{this.scheduleId});
            return;
        }
        inAppAutomation.getInAppMessageManager().onDisplayFinished(this.scheduleId, resolutionInfo);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void addEvent(InAppReportingEvent event) {
        if (this.isReportingAllowed) {
            Analytics analytics = this.getAnalytics();
            if (analytics == null) {
                UALog.e((String)"Takeoff not called. Unable to add event for schedule: %s", (Object[])new Object[]{this.scheduleId});
                return;
            }
            event.setCampaigns(this.campaigns).setReportingContext(this.reportingContext).setExperimentResult(this.experimentResult).record(analytics);
        }
    }

    public void cancelFutureDisplays() {
        InAppAutomation inAppAutomation = this.getInAppAutomation();
        if (inAppAutomation == null) {
            UALog.e((String)"Takeoff not called. Unable to cancel displays for schedule: %s", (Object[])new Object[]{this.scheduleId});
            return;
        }
        inAppAutomation.cancelSchedule(this.scheduleId);
    }

    public boolean isDisplayAllowed(@NonNull Context context) {
        Autopilot.automaticTakeOff((Context)context);
        InAppAutomation inAppAutomation = this.getInAppAutomation();
        if (inAppAutomation == null) {
            UALog.e((String)"Takeoff not called. Unable to request display lock.", (Object[])new Object[0]);
            return false;
        }
        return inAppAutomation.getInAppMessageManager().isDisplayAllowed(this.scheduleId);
    }

    @Nullable
    private InAppAutomation getInAppAutomation() {
        if (UAirship.isTakingOff() || UAirship.isFlying()) {
            return InAppAutomation.shared();
        }
        return null;
    }

    @Nullable
    private Analytics getAnalytics() {
        if (UAirship.isTakingOff() || UAirship.isFlying()) {
            return UAirship.shared().getAnalytics();
        }
        return null;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }
}

