/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import com.urbanairship.Predicate;
import com.urbanairship.UALog;
import com.urbanairship.app.ActivityListener;
import com.urbanairship.app.ActivityMonitor;
import com.urbanairship.app.ApplicationListener;
import com.urbanairship.app.FilteredActivityListener;
import com.urbanairship.app.ForwardingActivityListener;
import com.urbanairship.app.GlobalActivityMonitor;
import com.urbanairship.util.ManifestUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class InAppActivityMonitor
implements ActivityMonitor {
    @NonNull
    public static final String EXCLUDE_FROM_AUTO_SHOW = "com.urbanairship.push.iam.EXCLUDE_FROM_AUTO_SHOW";
    private static InAppActivityMonitor shared;
    private final ActivityMonitor globalActivityMonitor;
    private final Set<Class> allowedActivities = new HashSet<Class>();
    private final Set<Class> ignoredActivities = new HashSet<Class>();
    private final Predicate<Activity> activityPredicate = new Predicate<Activity>(){

        public boolean apply(Activity activity) {
            if (InAppActivityMonitor.this.allowedActivities.contains(activity.getClass())) {
                return true;
            }
            if (InAppActivityMonitor.this.ignoredActivities.contains(activity.getClass())) {
                return false;
            }
            if (InAppActivityMonitor.this.shouldIgnoreActivity(activity)) {
                InAppActivityMonitor.this.ignoredActivities.add(activity.getClass());
                return false;
            }
            InAppActivityMonitor.this.allowedActivities.add(activity.getClass());
            return true;
        }
    };
    private final ForwardingActivityListener forwardingActivityListener;
    private final FilteredActivityListener filteredActivityListener;

    private InAppActivityMonitor(@NonNull ActivityMonitor globalActivityMonitor) {
        this.globalActivityMonitor = globalActivityMonitor;
        this.forwardingActivityListener = new ForwardingActivityListener();
        this.filteredActivityListener = new FilteredActivityListener((ActivityListener)this.forwardingActivityListener, this.activityPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static InAppActivityMonitor shared(@NonNull Context context) {
        if (shared != null) return shared;
        Class<InAppActivityMonitor> clazz = InAppActivityMonitor.class;
        synchronized (InAppActivityMonitor.class) {
            if (shared != null) return shared;
            shared = new InAppActivityMonitor((ActivityMonitor)GlobalActivityMonitor.shared((Context)context));
            shared.init();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return shared;
        }
    }

    private void init() {
        this.globalActivityMonitor.addActivityListener((ActivityListener)this.filteredActivityListener);
    }

    public void addActivityListener(@NonNull ActivityListener listener) {
        this.forwardingActivityListener.addListener(listener);
    }

    public void removeActivityListener(@NonNull ActivityListener listener) {
        this.forwardingActivityListener.removeListener(listener);
    }

    public void addApplicationListener(@NonNull ApplicationListener listener) {
        this.globalActivityMonitor.addApplicationListener(listener);
    }

    public void removeApplicationListener(@NonNull ApplicationListener listener) {
        this.globalActivityMonitor.removeApplicationListener(listener);
    }

    public boolean isAppForegrounded() {
        return this.globalActivityMonitor.isAppForegrounded();
    }

    @NonNull
    @MainThread
    public List<Activity> getResumedActivities() {
        return this.globalActivityMonitor.getResumedActivities(this.activityPredicate);
    }

    @NonNull
    @MainThread
    public List<Activity> getResumedActivities(final @NonNull Predicate<Activity> filter) {
        return this.globalActivityMonitor.getResumedActivities((Predicate)new Predicate<Activity>(){

            public boolean apply(Activity object) {
                return InAppActivityMonitor.this.activityPredicate.apply((Object)object) && filter.apply((Object)object);
            }
        });
    }

    private boolean shouldIgnoreActivity(Activity activity) {
        ActivityInfo info = ManifestUtils.getActivityInfo(activity.getClass());
        if (info != null && info.metaData != null && info.metaData.getBoolean(EXCLUDE_FROM_AUTO_SHOW, false)) {
            UALog.v((String)"Activity contains metadata to exclude it from auto showing an in-app message", (Object[])new Object[0]);
            return true;
        }
        return false;
    }
}

