/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.Size;
import com.urbanairship.UALog;
import com.urbanairship.automation.ScheduleData;
import com.urbanairship.iam.DisplayContent;
import com.urbanairship.iam.banner.BannerDisplayContent;
import com.urbanairship.iam.custom.CustomDisplayContent;
import com.urbanairship.iam.fullscreen.FullScreenDisplayContent;
import com.urbanairship.iam.html.HtmlDisplayContent;
import com.urbanairship.iam.layout.AirshipLayoutDisplayContent;
import com.urbanairship.iam.modal.ModalDisplayContent;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.Checks;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;

public class InAppMessage
implements Parcelable,
ScheduleData {
    public static final int MAX_NAME_LENGTH = 1024;
    private static final String DISPLAY_TYPE_KEY = "display_type";
    private static final String DISPLAY_CONTENT_KEY = "display";
    private static final String NAME_KEY = "name";
    private static final String EXTRA_KEY = "extra";
    private static final String ACTIONS_KEY = "actions";
    private static final String SOURCE_KEY = "source";
    private static final String DISPLAY_BEHAVIOR_KEY = "display_behavior";
    private static final String REPORTING_ENABLED_KEY = "reporting_enabled";
    private static final String RENDERED_LOCALE_KEY = "rendered_locale";
    private static final String RENDERED_LOCALE_LANGUAGE_KEY = "language";
    private static final String RENDERED_LOCALE_COUNTRY_KEY = "country";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String SOURCE_LEGACY_PUSH = "legacy-push";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String SOURCE_REMOTE_DATA = "remote-data";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String SOURCE_APP_DEFINED = "app-defined";
    @NonNull
    public static final String TYPE_BANNER = "banner";
    @NonNull
    public static final String TYPE_CUSTOM = "custom";
    @NonNull
    public static final String TYPE_FULLSCREEN = "fullscreen";
    @NonNull
    public static final String TYPE_MODAL = "modal";
    @NonNull
    public static final String TYPE_HTML = "html";
    @NonNull
    public static final String TYPE_AIRSHIP_LAYOUT = "layout";
    @NonNull
    public static final String DISPLAY_BEHAVIOR_DEFAULT = "default";
    @NonNull
    public static final String DISPLAY_BEHAVIOR_IMMEDIATE = "immediate";
    private final String type;
    private final JsonMap extras;
    private final String name;
    private final JsonSerializable content;
    private final Map<String, JsonValue> actions;
    private final String displayBehavior;
    private final boolean isReportingEnabled;
    private final String source;
    private final Map<String, JsonValue> renderedLocale;
    @NonNull
    public static final Parcelable.Creator<InAppMessage> CREATOR = new Parcelable.Creator<InAppMessage>(){

        @Nullable
        public InAppMessage createFromParcel(@NonNull Parcel in) {
            String payload = in.readString();
            try {
                return InAppMessage.fromJson(JsonValue.parseString((String)payload));
            }
            catch (JsonException e) {
                UALog.e((String)"InAppMessage - Invalid parcel: %s", (Object[])new Object[]{e});
                return null;
            }
        }

        @NonNull
        public InAppMessage[] newArray(int size) {
            return new InAppMessage[size];
        }
    };

    private InAppMessage(@NonNull Builder builder) {
        this.type = builder.type;
        this.content = builder.content;
        this.name = builder.name;
        this.extras = builder.extras == null ? JsonMap.EMPTY_MAP : builder.extras;
        this.actions = builder.actions;
        this.source = builder.source;
        this.displayBehavior = builder.displayBehavior;
        this.isReportingEnabled = builder.isReportingEnabled;
        this.renderedLocale = builder.renderedLocale;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @Nullable
    public <T extends DisplayContent> T getDisplayContent() {
        if (this.content == null) {
            return null;
        }
        try {
            return (T)((DisplayContent)this.content);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NonNull
    public JsonMap getExtras() {
        return this.extras;
    }

    @NonNull
    public Map<String, JsonValue> getActions() {
        return this.actions;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public String getSource() {
        return this.source;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Map<String, JsonValue> getRenderedLocale() {
        return this.renderedLocale;
    }

    @NonNull
    public String getDisplayBehavior() {
        return this.displayBehavior;
    }

    public boolean isReportingEnabled() {
        return this.isReportingEnabled;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().putOpt(NAME_KEY, (Object)this.name).putOpt(EXTRA_KEY, (Object)this.extras).putOpt(DISPLAY_CONTENT_KEY, (Object)this.content).putOpt(DISPLAY_TYPE_KEY, (Object)this.type).putOpt(ACTIONS_KEY, this.actions).putOpt(SOURCE_KEY, (Object)this.source).putOpt(DISPLAY_BEHAVIOR_KEY, (Object)this.displayBehavior).putOpt(REPORTING_ENABLED_KEY, (Object)this.isReportingEnabled).putOpt(RENDERED_LOCALE_KEY, this.renderedLocale).build().toJsonValue();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static InAppMessage fromJson(@NonNull JsonValue jsonValue, @Nullable String defaultSource) throws JsonException {
        Object jsonMap;
        String type = jsonValue.optMap().opt(DISPLAY_TYPE_KEY).optString();
        JsonValue content = jsonValue.optMap().opt(DISPLAY_CONTENT_KEY);
        String name = jsonValue.optMap().opt(NAME_KEY).getString();
        if (name != null && name.length() > 1024) {
            throw new JsonException("Invalid message name. Must be less than or equal to 1024 characters.");
        }
        Builder builder = InAppMessage.newBuilder().setName(name).setExtras(jsonValue.optMap().opt(EXTRA_KEY).optMap()).setDisplayContent(type, content);
        String source = jsonValue.optMap().opt(SOURCE_KEY).getString();
        if (source != null) {
            builder.setSource(source);
        } else if (defaultSource != null) {
            builder.setSource(defaultSource);
        }
        if (jsonValue.optMap().containsKey(ACTIONS_KEY)) {
            jsonMap = jsonValue.optMap().opt(ACTIONS_KEY).getMap();
            if (jsonMap == null) {
                throw new JsonException("Actions must be a JSON object: " + jsonValue.optMap().opt(ACTIONS_KEY));
            }
            builder.setActions(jsonMap.getMap());
        }
        if (jsonValue.optMap().containsKey(DISPLAY_BEHAVIOR_KEY)) {
            switch (jsonValue.optMap().opt(DISPLAY_BEHAVIOR_KEY).optString()) {
                case "default": {
                    builder.setDisplayBehavior(DISPLAY_BEHAVIOR_DEFAULT);
                    break;
                }
                case "immediate": {
                    builder.setDisplayBehavior(DISPLAY_BEHAVIOR_IMMEDIATE);
                    break;
                }
                default: {
                    throw new JsonException("Unexpected display behavior: " + jsonValue.optMap().get(DISPLAY_BEHAVIOR_IMMEDIATE));
                }
            }
        }
        if (jsonValue.optMap().containsKey(REPORTING_ENABLED_KEY)) {
            builder.setReportingEnabled(jsonValue.optMap().opt(REPORTING_ENABLED_KEY).getBoolean(true));
        }
        if (jsonValue.optMap().containsKey(RENDERED_LOCALE_KEY)) {
            jsonMap = jsonValue.optMap().opt(RENDERED_LOCALE_KEY).getMap();
            if (jsonMap == null) {
                throw new JsonException("Rendered locale must be a JSON object: " + jsonValue.optMap().opt(RENDERED_LOCALE_KEY));
            }
            if (!jsonMap.containsKey(RENDERED_LOCALE_LANGUAGE_KEY) && !jsonMap.containsKey(RENDERED_LOCALE_COUNTRY_KEY)) {
                throw new JsonException("Rendered locale must contain one of \"language\" or \"country\" fields :" + jsonMap);
            }
            JsonValue languageValue = jsonMap.opt(RENDERED_LOCALE_LANGUAGE_KEY);
            if (!languageValue.isNull() && !languageValue.isString()) {
                throw new JsonException("Language must be a string: " + languageValue);
            }
            JsonValue countryValue = jsonMap.opt(RENDERED_LOCALE_COUNTRY_KEY);
            if (!countryValue.isNull() && !countryValue.isString()) {
                throw new JsonException("Country must be a string: " + countryValue);
            }
            builder.setRenderedLocale(jsonMap.getMap());
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid InAppMessage json.", (Throwable)e);
        }
    }

    @NonNull
    public static InAppMessage fromJson(@NonNull JsonValue jsonValue) throws JsonException {
        return InAppMessage.fromJson(jsonValue, null);
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public static Builder newBuilder(@NonNull InAppMessage message) {
        return new Builder(message);
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.toJsonValue().toString());
    }

    public int describeContents() {
        return 0;
    }

    @NonNull
    public String toString() {
        return this.toJsonValue().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InAppMessage message = (InAppMessage)o;
        if (!this.displayBehavior.equals(message.displayBehavior)) {
            return false;
        }
        if (this.isReportingEnabled != message.isReportingEnabled) {
            return false;
        }
        if (!this.type.equals(message.type)) {
            return false;
        }
        if (!this.extras.equals((Object)message.extras)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(message.name) : message.name != null) {
            return false;
        }
        if (!this.content.equals(message.content)) {
            return false;
        }
        if (!this.actions.equals(message.actions)) {
            return false;
        }
        if (this.renderedLocale != null ? !this.renderedLocale.equals(message.renderedLocale) : message.renderedLocale != null) {
            return false;
        }
        return this.source.equals(message.source);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.extras.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.content.hashCode();
        result = 31 * result + this.actions.hashCode();
        result = 31 * result + (this.renderedLocale != null ? this.renderedLocale.hashCode() : 0);
        result = 31 * result + this.displayBehavior.hashCode();
        result = 31 * result + (this.isReportingEnabled ? 1 : 0);
        result = 31 * result + this.source.hashCode();
        return result;
    }

    public static class Builder {
        private String type;
        private JsonMap extras;
        private String name;
        private JsonSerializable content;
        private Map<String, JsonValue> actions = new HashMap<String, JsonValue>();
        private String source = "app-defined";
        private String displayBehavior = "default";
        private boolean isReportingEnabled = true;
        private Map<String, JsonValue> renderedLocale;

        private Builder() {
        }

        public Builder(@NonNull InAppMessage message) {
            this.type = message.type;
            this.content = message.content;
            this.name = message.name;
            this.extras = message.extras;
            this.actions = message.actions;
            this.source = message.source;
            this.displayBehavior = message.displayBehavior;
            this.isReportingEnabled = message.isReportingEnabled;
            this.renderedLocale = message.renderedLocale;
        }

        @NonNull
        private Builder setDisplayContent(@NonNull String type, @NonNull JsonValue content) throws JsonException {
            switch (type) {
                case "banner": {
                    this.setDisplayContent(BannerDisplayContent.fromJson(content));
                    break;
                }
                case "custom": {
                    this.setDisplayContent(CustomDisplayContent.fromJson(content));
                    break;
                }
                case "fullscreen": {
                    this.setDisplayContent(FullScreenDisplayContent.fromJson(content));
                    break;
                }
                case "modal": {
                    this.setDisplayContent(ModalDisplayContent.fromJson(content));
                    break;
                }
                case "html": {
                    this.setDisplayContent(HtmlDisplayContent.fromJson(content));
                    break;
                }
                case "layout": {
                    this.setDisplayContent(AirshipLayoutDisplayContent.fromJson(content));
                }
            }
            return this;
        }

        @NonNull
        public Builder setDisplayContent(@NonNull ModalDisplayContent displayContent) {
            this.type = InAppMessage.TYPE_MODAL;
            this.content = displayContent;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setDisplayContent(@NonNull AirshipLayoutDisplayContent displayContent) {
            this.type = InAppMessage.TYPE_AIRSHIP_LAYOUT;
            this.content = displayContent;
            return this;
        }

        @NonNull
        public Builder setDisplayContent(@NonNull FullScreenDisplayContent displayContent) {
            this.type = InAppMessage.TYPE_FULLSCREEN;
            this.content = displayContent;
            return this;
        }

        @NonNull
        public Builder setDisplayContent(@NonNull BannerDisplayContent displayContent) {
            this.type = InAppMessage.TYPE_BANNER;
            this.content = displayContent;
            return this;
        }

        @NonNull
        public Builder setDisplayContent(@NonNull HtmlDisplayContent displayContent) {
            this.type = InAppMessage.TYPE_HTML;
            this.content = displayContent;
            return this;
        }

        @NonNull
        public Builder setDisplayBehavior(@NonNull String displayBehavior) {
            this.displayBehavior = displayBehavior;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setSource(@Nullable String source) {
            this.source = source;
            return this;
        }

        @NonNull
        public Builder setDisplayContent(@NonNull CustomDisplayContent displayContent) {
            this.type = InAppMessage.TYPE_CUSTOM;
            this.content = displayContent;
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable JsonMap extras) {
            this.extras = extras;
            return this;
        }

        @NonNull
        public Builder setName(@Nullable @Size(min=1L, max=1024L) String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder setActions(@Nullable Map<String, JsonValue> actions) {
            this.actions.clear();
            if (actions != null) {
                this.actions.putAll(actions);
            }
            return this;
        }

        @NonNull
        public Builder addAction(@NonNull String actionName, @NonNull JsonValue actionValue) {
            this.actions.put(actionName, actionValue);
            return this;
        }

        @NonNull
        public Builder setReportingEnabled(boolean isReportingEnabled) {
            this.isReportingEnabled = isReportingEnabled;
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setRenderedLocale(@Nullable Map<String, JsonValue> renderedLocale) {
            this.renderedLocale = renderedLocale;
            return this;
        }

        @NonNull
        public InAppMessage build() {
            Checks.checkArgument((this.name == null || this.name.length() <= 1024 ? 1 : 0) != 0, (String)"Name exceeds max name length: 1024");
            Checks.checkNotNull((Object)this.type, (String)"Missing type.");
            Checks.checkNotNull((Object)this.content, (String)"Missing content.");
            return new InAppMessage(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisplayBehavior {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisplayType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Source {
    }
}

