/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.Autopilot;
import com.urbanairship.UALog;
import com.urbanairship.activity.ThemedActivity;
import com.urbanairship.iam.DisplayHandler;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.ResolutionInfo;
import com.urbanairship.iam.assets.Assets;

public abstract class InAppMessageActivity
extends ThemedActivity {
    @NonNull
    public static final String DISPLAY_HANDLER_EXTRA_KEY = "display_handler";
    @NonNull
    public static final String IN_APP_MESSAGE_KEY = "in_app_message";
    @NonNull
    public static final String IN_APP_ASSETS = "assets";
    private static final String DISPLAY_TIME_KEY = "display_time";
    private DisplayHandler displayHandler;
    private InAppMessage inAppMessage;
    private Assets assets;
    private long resumeTime = 0L;
    private long displayTime = 0L;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Autopilot.automaticTakeOff((Context)this.getApplicationContext());
        super.onCreate(savedInstanceState);
        if (this.getIntent() == null || this.getIntent().getExtras() == null) {
            this.finish();
            return;
        }
        this.displayHandler = (DisplayHandler)this.getIntent().getParcelableExtra(DISPLAY_HANDLER_EXTRA_KEY);
        this.inAppMessage = (InAppMessage)this.getIntent().getParcelableExtra(IN_APP_MESSAGE_KEY);
        this.assets = (Assets)this.getIntent().getParcelableExtra(IN_APP_ASSETS);
        if (this.displayHandler == null || this.inAppMessage == null) {
            UALog.e((String)"%s unable to show message. Missing display handler or in-app message", (Object[])new Object[]{((Object)((Object)this)).getClass()});
            this.finish();
            return;
        }
        if (!this.displayHandler.isDisplayAllowed((Context)this)) {
            this.finish();
            return;
        }
        if (savedInstanceState != null) {
            this.displayTime = savedInstanceState.getLong(DISPLAY_TIME_KEY, 0L);
        }
        this.onCreateMessage(savedInstanceState);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        if (!this.displayHandler.isDisplayAllowed((Context)this)) {
            this.finish();
        }
    }

    protected abstract void onCreateMessage(@Nullable Bundle var1);

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putLong(DISPLAY_TIME_KEY, this.displayTime);
    }

    protected void onResume() {
        super.onResume();
        this.resumeTime = System.currentTimeMillis();
    }

    protected void onPause() {
        super.onPause();
        this.displayTime += System.currentTimeMillis() - this.resumeTime;
        this.resumeTime = 0L;
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.displayHandler.finished(ResolutionInfo.dismissed(), this.getDisplayTime());
        this.finish();
    }

    protected long getDisplayTime() {
        long time = this.displayTime;
        if (this.resumeTime > 0L) {
            time += System.currentTimeMillis() - this.resumeTime;
        }
        return time;
    }

    @Nullable
    protected InAppMessage getMessage() {
        return this.inAppMessage;
    }

    @Nullable
    protected DisplayHandler getDisplayHandler() {
        return this.displayHandler;
    }

    @Nullable
    protected Assets getMessageAssets() {
        return this.assets;
    }
}

