/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.PreferenceDataStore;
import com.urbanairship.UALog;
import com.urbanairship.actions.ActionRunRequestFactory;
import com.urbanairship.analytics.Analytics;
import com.urbanairship.automation.AutomationDriver;
import com.urbanairship.experiment.ExperimentResult;
import com.urbanairship.iam.AdapterWrapper;
import com.urbanairship.iam.DefaultDisplayCoordinator;
import com.urbanairship.iam.DisplayCoordinator;
import com.urbanairship.iam.ImmediateDisplayCoordinator;
import com.urbanairship.iam.InAppActionUtils;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.InAppMessageAdapter;
import com.urbanairship.iam.InAppMessageExtender;
import com.urbanairship.iam.InAppMessageListener;
import com.urbanairship.iam.OnRequestDisplayCoordinatorCallback;
import com.urbanairship.iam.ResolutionInfo;
import com.urbanairship.iam.assets.AssetManager;
import com.urbanairship.iam.banner.BannerAdapterFactory;
import com.urbanairship.iam.events.InAppReportingEvent;
import com.urbanairship.iam.fullscreen.FullScreenAdapterFactory;
import com.urbanairship.iam.html.HtmlAdapterFactory;
import com.urbanairship.iam.layout.AirshipLayoutAdapterFactory;
import com.urbanairship.iam.modal.ModalAdapterFactory;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.RetryingExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class InAppMessageManager {
    public static final long DEFAULT_DISPLAY_INTERVAL_MS = 0L;
    private static final String DISPLAY_INTERVAL_KEY = "com.urbanairship.iam.displayinterval";
    private final Map<String, AdapterWrapper> adapterWrappers = Collections.synchronizedMap(new HashMap());
    private final RetryingExecutor executor;
    private final ActionRunRequestFactory actionRunRequestFactory;
    private final Analytics analytics;
    private final Map<String, InAppMessageAdapter.Factory> adapterFactories = new HashMap<String, InAppMessageAdapter.Factory>();
    private final List<InAppMessageListener> listeners = new ArrayList<InAppMessageListener>();
    private final DefaultDisplayCoordinator defaultCoordinator;
    private final ImmediateDisplayCoordinator immediateDisplayCoordinator;
    private final AssetManager assetManager;
    private final Context context;
    private final PreferenceDataStore dataStore;
    private final Delegate delegate;
    @Nullable
    private DisplayDelegate appDisplayDelegate;
    @Nullable
    private InAppMessageExtender messageExtender;
    @Nullable
    private OnRequestDisplayCoordinatorCallback displayCoordinatorCallback;
    private final DisplayCoordinator.OnDisplayReadyCallback displayReadyCallback = new DisplayCoordinator.OnDisplayReadyCallback(){

        @Override
        public void onReady() {
            InAppMessageManager.this.delegate.onReadinessChanged();
        }
    };
    private final Map<String, AutomationDriver.ExecutionCallback> executionCallbacks = new HashMap<String, AutomationDriver.ExecutionCallback>();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public InAppMessageManager(@NonNull Context context, @NonNull PreferenceDataStore dataStore, @NonNull Analytics analytics, @NonNull Delegate delegate) {
        this(context, dataStore, analytics, RetryingExecutor.newSerialExecutor((Looper)Looper.getMainLooper()), new ActionRunRequestFactory(), new AssetManager(context), delegate);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    InAppMessageManager(@NonNull Context context, @NonNull PreferenceDataStore dataStore, @NonNull Analytics analytics, @NonNull RetryingExecutor executor, @NonNull ActionRunRequestFactory runRequestFactory, @NonNull AssetManager assetManager, @NonNull Delegate delegate) {
        this.context = context;
        this.dataStore = dataStore;
        this.analytics = analytics;
        this.executor = executor;
        this.assetManager = assetManager;
        this.delegate = delegate;
        this.actionRunRequestFactory = runRequestFactory;
        this.defaultCoordinator = new DefaultDisplayCoordinator(this.getDisplayInterval());
        this.immediateDisplayCoordinator = new ImmediateDisplayCoordinator();
        executor.setPaused(true);
        this.setAdapterFactory("banner", new BannerAdapterFactory());
        this.setAdapterFactory("fullscreen", new FullScreenAdapterFactory());
        this.setAdapterFactory("modal", new ModalAdapterFactory());
        this.setAdapterFactory("html", new HtmlAdapterFactory());
        this.setAdapterFactory("layout", new AirshipLayoutAdapterFactory());
    }

    public void setAdapterFactory(@NonNull String displayType, @Nullable InAppMessageAdapter.Factory factory) {
        if (factory == null) {
            this.adapterFactories.remove(displayType);
        } else {
            this.adapterFactories.put(displayType, factory);
        }
    }

    public void setDisplayInterval(@IntRange(from=0L) long time, @NonNull TimeUnit timeUnit) {
        this.dataStore.put(DISPLAY_INTERVAL_KEY, timeUnit.toMillis(time));
        this.defaultCoordinator.setDisplayInterval(time, timeUnit);
    }

    public long getDisplayInterval() {
        return this.dataStore.getLong(DISPLAY_INTERVAL_KEY, 0L);
    }

    @NonNull
    public AssetManager getAssetManager() {
        return this.assetManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NonNull InAppMessageListener listener) {
        List<InAppMessageListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NonNull InAppMessageListener listener) {
        List<InAppMessageListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void setMessageExtender(@Nullable InAppMessageExtender extender) {
        this.messageExtender = extender;
    }

    public void setOnRequestDisplayCoordinatorCallback(@Nullable OnRequestDisplayCoordinatorCallback callback) {
        this.displayCoordinatorCallback = callback;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onAirshipReady() {
        this.executor.setPaused(false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onPrepare(@NonNull String scheduleId, @Nullable JsonValue campaigns, @Nullable JsonValue reportingContext, @NonNull InAppMessage inAppMessage, @Nullable ExperimentResult experimentResult, @NonNull AutomationDriver.PrepareScheduleCallback callback) {
        if (experimentResult != null && experimentResult.isMatching()) {
            AdapterWrapper wrapper = this.createAdapterWrapper(scheduleId, campaigns, reportingContext, inAppMessage, experimentResult);
            this.adapterWrappers.put(scheduleId, wrapper);
            callback.onFinish(0);
            return;
        }
        AdapterWrapper adapter = this.createAdapterWrapper(scheduleId, campaigns, reportingContext, inAppMessage, experimentResult);
        if (adapter == null) {
            callback.onFinish(2);
            return;
        }
        RetryingExecutor.Operation prepareAssets = () -> {
            int result = this.assetManager.onPrepare(scheduleId, adapter.message);
            switch (result) {
                case 0: {
                    UALog.d((String)"Assets prepared for schedule %s.", (Object[])new Object[]{scheduleId});
                    return RetryingExecutor.finishedResult();
                }
                case 1: {
                    UALog.d((String)"Assets failed to prepare for schedule %s. Will retry.", (Object[])new Object[]{scheduleId});
                    return RetryingExecutor.retryResult();
                }
            }
            UALog.d((String)"Assets failed to prepare. Cancelling display for schedule %s.", (Object[])new Object[]{scheduleId});
            this.assetManager.onDisplayFinished(scheduleId, adapter.message);
            callback.onFinish(1);
            return RetryingExecutor.cancelResult();
        };
        RetryingExecutor.Operation prepareAdapter = () -> {
            int result = adapter.prepare(this.context, this.assetManager.getAssets(scheduleId));
            switch (result) {
                case 0: {
                    UALog.d((String)"Adapter prepared schedule %s.", (Object[])new Object[]{scheduleId});
                    this.adapterWrappers.put(scheduleId, adapter);
                    callback.onFinish(0);
                    return RetryingExecutor.finishedResult();
                }
                case 1: {
                    UALog.d((String)"Adapter failed to prepare schedule %s. Will retry.", (Object[])new Object[]{scheduleId});
                    return RetryingExecutor.retryResult();
                }
            }
            UALog.d((String)"Adapter failed to prepare. Cancelling display for schedule %s.", (Object[])new Object[]{scheduleId});
            callback.onFinish(1);
            return RetryingExecutor.cancelResult();
        };
        this.executor.execute(new RetryingExecutor.Operation[]{prepareAssets, prepareAdapter});
    }

    @MainThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int onCheckExecutionReadiness(@NonNull String scheduleId) {
        AdapterWrapper adapterWrapper = this.adapterWrappers.get(scheduleId);
        if (adapterWrapper == null) {
            UALog.e((String)"Missing adapter for schedule %.", (Object[])new Object[]{scheduleId});
            return -1;
        }
        DisplayDelegate displayDelegate = this.appDisplayDelegate;
        if (adapterWrapper.isReady(this.context) && (displayDelegate == null || displayDelegate.isReady(adapterWrapper.message))) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @MainThread
    public void onExecute(@NonNull String scheduleId, @NonNull AutomationDriver.ExecutionCallback callback) {
        final AdapterWrapper adapterWrapper = this.adapterWrappers.get(scheduleId);
        if (adapterWrapper == null) {
            UALog.e((String)"Missing adapter for schedule %.", (Object[])new Object[]{scheduleId});
            callback.onFinish();
            return;
        }
        Object object = this.executionCallbacks;
        synchronized (object) {
            this.executionCallbacks.put(scheduleId, callback);
        }
        try {
            if (this.reportIfInHoldoutGroup(adapterWrapper)) {
                object = this.executionCallbacks;
                synchronized (object) {
                    this.executionCallbacks.remove(scheduleId);
                }
                adapterWrapper.coordinator.onDisplayStarted(adapterWrapper.message);
                adapterWrapper.coordinator.onDisplayFinished(adapterWrapper.message);
                callback.onFinish();
                return;
            }
            this.storeExperimentResult(adapterWrapper.experimentResult, scheduleId);
            adapterWrapper.display(this.context);
        }
        catch (AdapterWrapper.DisplayException e) {
            UALog.e((Throwable)e, (String)"Failed to display in-app message for schedule %s.", (Object[])new Object[]{scheduleId});
            this.callExecutionFinishedCallback(scheduleId);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    adapterWrapper.adapterFinished(InAppMessageManager.this.context);
                }
            });
            return;
        }
        if (adapterWrapper.message.isReportingEnabled()) {
            InAppReportingEvent.display(scheduleId, adapterWrapper.message).setCampaigns(adapterWrapper.campaigns).setReportingContext(adapterWrapper.reportingContext).setExperimentResult(adapterWrapper.experimentResult).record(this.analytics);
        }
        object = this.listeners;
        synchronized (object) {
            for (InAppMessageListener listener : new ArrayList<InAppMessageListener>(this.listeners)) {
                listener.onMessageDisplayed(scheduleId, adapterWrapper.message);
            }
        }
        UALog.v((String)"Message displayed for schedule %s.", (Object[])new Object[]{scheduleId});
    }

    private boolean reportIfInHoldoutGroup(AdapterWrapper wrapper) {
        ExperimentResult result = wrapper.experimentResult;
        if (result == null || !result.isMatching()) {
            return false;
        }
        InAppReportingEvent.holdoutGroupControl(wrapper.scheduleId, wrapper.message, result).setCampaigns(wrapper.campaigns).setReportingContext(wrapper.reportingContext).setExperimentResult(wrapper.experimentResult).record(this.analytics);
        return true;
    }

    private String generateStoreKey(String scheduleId) {
        return "UAInAppMessageManager:experimentResult:" + scheduleId;
    }

    private void storeExperimentResult(@Nullable ExperimentResult result, String scheduleId) {
        this.dataStore.put(this.generateStoreKey(scheduleId), (JsonSerializable)result);
    }

    @Nullable
    private ExperimentResult getStoredExperimentResult(String scheduleId) {
        JsonMap stored = this.dataStore.getJsonValue(this.generateStoreKey(scheduleId)).optMap();
        if (stored.isEmpty()) {
            return null;
        }
        return ExperimentResult.Companion.fromJson(stored);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onExecutionInvalidated(@NonNull String scheduleId) {
        AdapterWrapper adapterWrapper = this.adapterWrappers.remove(scheduleId);
        if (adapterWrapper == null) {
            return;
        }
        this.executor.execute(() -> this.assetManager.onDisplayFinished(scheduleId, adapterWrapper.message));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onExecutionInterrupted(@NonNull String scheduleId, @Nullable JsonValue campaigns, @Nullable JsonValue reportingContext, @Nullable InAppMessage message) {
        this.executor.execute(() -> {
            if (message == null || message.isReportingEnabled()) {
                String source = message != null ? message.getSource() : "remote-data";
                InAppReportingEvent.interrupted(scheduleId, source).setReportingContext(reportingContext).setCampaigns(campaigns).setExperimentResult(this.getStoredExperimentResult(scheduleId)).record(this.analytics);
                this.storeExperimentResult(null, scheduleId);
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @MainThread
    void onResolution(@NonNull String scheduleId, @NonNull ResolutionInfo resolutionInfo, long displayTime) {
        UALog.v((String)"Message finished for schedule %s.", (Object[])new Object[]{scheduleId});
        AdapterWrapper adapterWrapper = this.adapterWrappers.get(scheduleId);
        if (adapterWrapper == null) {
            return;
        }
        if (adapterWrapper.message.isReportingEnabled()) {
            InAppReportingEvent.resolution(scheduleId, adapterWrapper.message, displayTime, resolutionInfo).setCampaigns(adapterWrapper.campaigns).setReportingContext(adapterWrapper.reportingContext).setExperimentResult(adapterWrapper.experimentResult).record(this.analytics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @MainThread
    void onDisplayFinished(@NonNull String scheduleId, @NonNull ResolutionInfo resolutionInfo) {
        UALog.v((String)"Message finished for schedule %s.", (Object[])new Object[]{scheduleId});
        AdapterWrapper adapterWrapper = this.adapterWrappers.remove(scheduleId);
        if (adapterWrapper == null) {
            return;
        }
        InAppActionUtils.runActions(adapterWrapper.message.getActions(), this.actionRunRequestFactory);
        List<InAppMessageListener> list = this.listeners;
        synchronized (list) {
            for (InAppMessageListener listener : new ArrayList<InAppMessageListener>(this.listeners)) {
                listener.onMessageFinished(scheduleId, adapterWrapper.message, resolutionInfo);
            }
        }
        this.storeExperimentResult(null, scheduleId);
        this.callExecutionFinishedCallback(scheduleId);
        adapterWrapper.displayFinished();
        this.executor.execute(() -> {
            adapterWrapper.adapterFinished(this.context);
            this.assetManager.onDisplayFinished(adapterWrapper.scheduleId, adapterWrapper.message);
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @MainThread
    boolean isDisplayAllowed(@NonNull String scheduleId) {
        AdapterWrapper adapterWrapper = this.adapterWrappers.get(scheduleId);
        return adapterWrapper != null && adapterWrapper.displayed;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onMessageScheduleFinished(final @NonNull String scheduleId) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                InAppMessageManager.this.assetManager.onFinish(scheduleId);
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void onNewMessageSchedule(@NonNull String scheduleId, @NonNull InAppMessage message) {
        this.executor.execute(() -> this.assetManager.onSchedule(scheduleId, () -> this.extendMessage(message)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AdapterWrapper createAdapterWrapper(@NonNull String scheduleId, @Nullable JsonValue campaigns, @Nullable JsonValue reportingContext, @NonNull InAppMessage message, @Nullable ExperimentResult experimentResult) {
        InAppMessageAdapter adapter = null;
        DisplayCoordinator coordinator = null;
        try {
            InAppMessageAdapter.Factory factory;
            message = this.extendMessage(message);
            Map<String, InAppMessageAdapter.Factory> map = this.adapterFactories;
            synchronized (map) {
                factory = this.adapterFactories.get(message.getType());
            }
            if (factory == null) {
                UALog.d((String)"InAppMessageManager - No display adapter for message type: %s. Unable to process schedule: %s.", (Object[])new Object[]{message.getType(), scheduleId});
            } else {
                adapter = factory.createAdapter(message);
            }
            OnRequestDisplayCoordinatorCallback displayCoordinatorCallback = this.displayCoordinatorCallback;
            if (displayCoordinatorCallback != null) {
                coordinator = displayCoordinatorCallback.onRequestDisplayCoordinator(message);
            }
            if (coordinator == null) {
                switch (message.getDisplayBehavior()) {
                    case "immediate": {
                        coordinator = this.immediateDisplayCoordinator;
                        break;
                    }
                    default: {
                        coordinator = this.defaultCoordinator;
                    }
                }
            }
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"InAppMessageManager - Failed to create in-app message adapter.", (Object[])new Object[0]);
            return null;
        }
        if (adapter == null) {
            UALog.e((String)"InAppMessageManager - Failed to create in-app message adapter.", (Object[])new Object[0]);
            return null;
        }
        coordinator.setDisplayReadyCallback(this.displayReadyCallback);
        return new AdapterWrapper(scheduleId, campaigns, reportingContext, message, adapter, coordinator, experimentResult);
    }

    @NonNull
    private InAppMessage extendMessage(@NonNull InAppMessage originalMessage) {
        InAppMessageExtender extender = this.messageExtender;
        if (extender != null) {
            return extender.extend(originalMessage);
        }
        return originalMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callExecutionFinishedCallback(String scheduleId) {
        Map<String, AutomationDriver.ExecutionCallback> map = this.executionCallbacks;
        synchronized (map) {
            AutomationDriver.ExecutionCallback callback = this.executionCallbacks.remove(scheduleId);
            if (callback != null) {
                callback.onFinish();
            }
        }
    }

    public void setDisplayDelegate(@Nullable DisplayDelegate displayDelegate) {
        this.appDisplayDelegate = displayDelegate;
    }

    public void notifyDisplayConditionsChanged() {
        this.delegate.onReadinessChanged();
    }

    public static interface DisplayDelegate {
        @MainThread
        public boolean isReady(@NonNull InAppMessage var1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface Delegate {
        public void onReadinessChanged();
    }
}

