/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.graphics.Color;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import com.urbanairship.push.PushMessage;
import com.urbanairship.util.Checks;
import com.urbanairship.util.DateUtils;
import com.urbanairship.util.UAStringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class LegacyInAppMessage {
    private static final String BANNER_TYPE = "banner";
    private static final String DISPLAY_KEY = "display";
    private static final String ACTIONS_KEY = "actions";
    private static final String TYPE_KEY = "type";
    private static final String EXTRA_KEY = "extra";
    private static final String ALERT_KEY = "alert";
    private static final String PRIMARY_COLOR_KEY = "primary_color";
    private static final String SECONDARY_COLOR_KEY = "secondary_color";
    private static final String DURATION_KEY = "duration";
    private static final String EXPIRY_KEY = "expiry";
    private static final String POSITION_KEY = "position";
    private static final String ON_CLICK_KEY = "on_click";
    private static final String BUTTON_GROUP_KEY = "button_group";
    private static final String BUTTON_ACTIONS_KEY = "button_actions";
    private static final String MESSAGE_TYPE_KEY = "message_type";
    private static final String CAMPAIGNS_KEY = "campaigns";
    private static final long DEFAULT_EXPIRY_MS = 2592000000L;
    private static final String MESSAGE_CENTER_ACTION = "^mc";
    private final long expiryMS;
    private final String alert;
    private final Long durationMilliseconds;
    private final Integer primaryColor;
    private final Integer secondaryColor;
    private final String buttonGroupId;
    private final String id;
    private final String messageType;
    private final JsonValue campigns;
    private final String placement;
    private final Map<String, JsonValue> clickActionValues;
    private final JsonMap extras;
    private final Map<String, Map<String, JsonValue>> buttonActionValues;

    private LegacyInAppMessage(@NonNull Builder builder) {
        this.expiryMS = builder.expiryMS == null ? System.currentTimeMillis() + 2592000000L : builder.expiryMS;
        this.extras = builder.extras == null ? JsonMap.EMPTY_MAP : builder.extras;
        this.alert = builder.alert;
        this.durationMilliseconds = builder.durationMilliseconds;
        this.buttonGroupId = builder.buttonGroupId;
        this.buttonActionValues = builder.buttonActionValues;
        this.clickActionValues = builder.clickActionValues;
        this.placement = builder.placement;
        this.primaryColor = builder.primaryColor;
        this.secondaryColor = builder.secondaryColor;
        this.id = builder.id == null ? UUID.randomUUID().toString() : builder.id;
        this.campigns = builder.campaigns;
        this.messageType = builder.messageType;
    }

    public long getExpiry() {
        return this.expiryMS;
    }

    @NonNull
    public JsonMap getExtras() {
        return this.extras;
    }

    @Nullable
    public String getAlert() {
        return this.alert;
    }

    @Nullable
    String getMessageType() {
        return this.messageType;
    }

    @Nullable
    JsonValue getCampaigns() {
        return this.campigns;
    }

    @NonNull
    public Map<String, JsonValue> getClickActionValues() {
        return Collections.unmodifiableMap(this.clickActionValues);
    }

    @Nullable
    public Map<String, JsonValue> getButtonActionValues(@NonNull String buttonId) {
        Map<String, JsonValue> buttonActions = this.buttonActionValues.get(buttonId);
        if (buttonActions != null) {
            return Collections.unmodifiableMap(buttonActions);
        }
        return null;
    }

    @Nullable
    public String getButtonGroupId() {
        return this.buttonGroupId;
    }

    @Nullable
    public Long getDuration() {
        return this.durationMilliseconds;
    }

    @NonNull
    public String getPlacement() {
        return this.placement;
    }

    @Nullable
    public Integer getPrimaryColor() {
        return this.primaryColor;
    }

    @Nullable
    public Integer getSecondaryColor() {
        return this.secondaryColor;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public static LegacyInAppMessage fromPush(@NonNull PushMessage pushMessage) throws JsonException {
        if (!pushMessage.containsKey("com.urbanairship.in_app")) {
            return null;
        }
        JsonValue jsonValue = JsonValue.parseString((String)pushMessage.getExtra("com.urbanairship.in_app", ""));
        JsonMap displayJson = jsonValue.optMap().opt(DISPLAY_KEY).optMap();
        JsonMap actionsJson = jsonValue.optMap().opt(ACTIONS_KEY).optMap();
        if (!BANNER_TYPE.equals(displayJson.opt(TYPE_KEY).getString())) {
            throw new JsonException("Only banner types are supported.");
        }
        Builder builder = LegacyInAppMessage.newBuilder();
        builder.setExtras(jsonValue.optMap().opt(EXTRA_KEY).optMap()).setAlert(displayJson.opt(ALERT_KEY).getString()).setCampaigns(jsonValue.optMap().get(CAMPAIGNS_KEY)).setMessageType(jsonValue.optMap().opt(MESSAGE_TYPE_KEY).getString());
        if (displayJson.containsKey(PRIMARY_COLOR_KEY)) {
            try {
                builder.setPrimaryColor(Color.parseColor((String)displayJson.opt(PRIMARY_COLOR_KEY).optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid primary color: " + displayJson.opt(PRIMARY_COLOR_KEY), (Throwable)e);
            }
        }
        if (displayJson.containsKey(SECONDARY_COLOR_KEY)) {
            try {
                builder.setSecondaryColor(Color.parseColor((String)displayJson.opt(SECONDARY_COLOR_KEY).optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid secondary color: " + displayJson.opt(SECONDARY_COLOR_KEY), (Throwable)e);
            }
        }
        if (displayJson.containsKey(DURATION_KEY)) {
            long duration = displayJson.opt(DURATION_KEY).getLong(0L);
            builder.setDuration(TimeUnit.SECONDS.toMillis(duration));
        }
        long defaultExpiry = System.currentTimeMillis() + 2592000000L;
        if (jsonValue.optMap().containsKey(EXPIRY_KEY)) {
            builder.setExpiry(DateUtils.parseIso8601((String)jsonValue.optMap().opt(EXPIRY_KEY).optString(), (long)defaultExpiry));
        } else {
            builder.setExpiry(defaultExpiry);
        }
        if ("top".equalsIgnoreCase(displayJson.opt(POSITION_KEY).getString())) {
            builder.setPlacement("top");
        } else {
            builder.setPlacement("bottom");
        }
        Map clickActions = actionsJson.opt(ON_CLICK_KEY).optMap().getMap();
        if (!UAStringUtil.isEmpty((String)pushMessage.getRichPushMessageId())) {
            clickActions.put(MESSAGE_CENTER_ACTION, JsonValue.wrap((String)pushMessage.getRichPushMessageId()));
        }
        builder.setClickActionValues(clickActions);
        builder.setButtonGroupId(actionsJson.opt(BUTTON_GROUP_KEY).getString());
        JsonMap buttonActionsJson = actionsJson.opt(BUTTON_ACTIONS_KEY).optMap();
        for (Map.Entry entry : buttonActionsJson.entrySet()) {
            String buttonId = (String)entry.getKey();
            JsonMap actionJson = buttonActionsJson.opt(buttonId).optMap();
            builder.setButtonActionValues(buttonId, actionJson.getMap());
        }
        builder.setId(pushMessage.getSendId());
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid legacy in-app message" + jsonValue, (Throwable)e);
        }
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        @NonNull
        private final Map<String, JsonValue> clickActionValues = new HashMap<String, JsonValue>();
        private String id;
        @Nullable
        private JsonMap extras;
        @NonNull
        private final Map<String, Map<String, JsonValue>> buttonActionValues = new HashMap<String, Map<String, JsonValue>>();
        private String buttonGroupId;
        private String alert;
        private Long expiryMS;
        private Long durationMilliseconds;
        private Integer primaryColor;
        private Integer secondaryColor;
        @NonNull
        private String placement = "bottom";
        private String messageType;
        private JsonValue campaigns;

        private Builder() {
        }

        @NonNull
        public Builder setExpiry(@Nullable Long milliseconds) {
            this.expiryMS = milliseconds;
            return this;
        }

        @NonNull
        public Builder setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable JsonMap extras) {
            this.extras = extras;
            return this;
        }

        @NonNull
        public Builder setClickActionValues(@Nullable Map<String, JsonValue> actionValues) {
            this.clickActionValues.clear();
            if (actionValues != null) {
                this.clickActionValues.putAll(actionValues);
            }
            return this;
        }

        @NonNull
        public Builder setButtonActionValues(@NonNull String buttonId, @Nullable Map<String, JsonValue> actionValues) {
            if (actionValues == null) {
                this.buttonActionValues.remove(buttonId);
            } else {
                this.buttonActionValues.put(buttonId, new HashMap<String, JsonValue>(actionValues));
            }
            return this;
        }

        @NonNull
        public Builder setButtonGroupId(@Nullable String buttonGroupId) {
            this.buttonGroupId = buttonGroupId;
            return this;
        }

        @NonNull
        public Builder setAlert(@Nullable String alert) {
            this.alert = alert;
            return this;
        }

        @NonNull
        public Builder setDuration(@Nullable Long milliseconds) {
            this.durationMilliseconds = milliseconds;
            return this;
        }

        @NonNull
        public Builder setPlacement(@NonNull String placement) {
            this.placement = placement;
            return this;
        }

        @NonNull
        public Builder setPrimaryColor(@Nullable Integer color) {
            this.primaryColor = color;
            return this;
        }

        @NonNull
        public Builder setSecondaryColor(@Nullable Integer color) {
            this.secondaryColor = color;
            return this;
        }

        @NonNull
        Builder setMessageType(@Nullable String messageType) {
            this.messageType = messageType;
            return this;
        }

        @NonNull
        Builder setCampaigns(@Nullable JsonValue campaigns) {
            this.campaigns = campaigns;
            return this;
        }

        @NonNull
        public LegacyInAppMessage build() {
            Checks.checkArgument((this.durationMilliseconds == null || this.durationMilliseconds > 0L ? 1 : 0) != 0, (String)"Duration must be greater than 0");
            return new LegacyInAppMessage(this);
        }
    }
}

