/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.content.Context;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import com.urbanairship.AirshipComponent;
import com.urbanairship.PreferenceDataStore;
import com.urbanairship.ResultCallback;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.analytics.Analytics;
import com.urbanairship.automation.InAppAutomation;
import com.urbanairship.automation.Schedule;
import com.urbanairship.automation.Trigger;
import com.urbanairship.automation.Triggers;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.LegacyInAppMessage;
import com.urbanairship.iam.TextInfo;
import com.urbanairship.iam.banner.BannerDisplayContent;
import com.urbanairship.iam.events.InAppReportingEvent;
import com.urbanairship.json.JsonException;
import com.urbanairship.push.InternalNotificationListener;
import com.urbanairship.push.NotificationActionButtonInfo;
import com.urbanairship.push.NotificationInfo;
import com.urbanairship.push.PushListener;
import com.urbanairship.push.PushManager;
import com.urbanairship.push.PushMessage;
import com.urbanairship.push.notifications.NotificationActionButton;
import com.urbanairship.push.notifications.NotificationActionButtonGroup;
import java.util.concurrent.TimeUnit;

public class LegacyInAppMessageManager
extends AirshipComponent {
    private static final String PENDING_MESSAGE_ID = "com.urbanairship.push.iam.PENDING_MESSAGE_ID";
    public static final int DEFAULT_PRIMARY_COLOR = -1;
    public static final int DEFAULT_SECONDARY_COLOR = -16777216;
    public static final float DEFAULT_BORDER_RADIUS_DP = 2.0f;
    private final InAppAutomation inAppAutomation;
    private final PreferenceDataStore preferenceDataStore;
    private final Analytics analytics;
    private final PushManager pushManager;
    private MessageBuilderExtender messageBuilderExtender;
    private ScheduleBuilderExtender scheduleBuilderExtender;
    private boolean displayAsapEnabled = true;

    @NonNull
    public static LegacyInAppMessageManager shared() {
        return (LegacyInAppMessageManager)UAirship.shared().requireComponent(LegacyInAppMessageManager.class);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LegacyInAppMessageManager(@NonNull Context context, @NonNull PreferenceDataStore preferenceDataStore, @NonNull InAppAutomation inAppAutomation, @NonNull Analytics analytics, @NonNull PushManager push) {
        super(context, preferenceDataStore);
        this.preferenceDataStore = preferenceDataStore;
        this.inAppAutomation = inAppAutomation;
        this.analytics = analytics;
        this.pushManager = push;
    }

    protected void init() {
        super.init();
        this.pushManager.addInternalPushListener(new PushListener(){

            @WorkerThread
            public void onPushReceived(@NonNull PushMessage message, boolean notificationPosted) {
                LegacyInAppMessage legacyInAppMessage = null;
                try {
                    legacyInAppMessage = LegacyInAppMessage.fromPush(message);
                }
                catch (JsonException | IllegalArgumentException e) {
                    UALog.e((Throwable)e, (String)"LegacyInAppMessageManager - Unable to create in-app message from push payload", (Object[])new Object[0]);
                }
                if (legacyInAppMessage == null) {
                    return;
                }
                Schedule schedule = LegacyInAppMessageManager.this.createSchedule(UAirship.getApplicationContext(), legacyInAppMessage);
                if (schedule == null) {
                    return;
                }
                final String messageId = schedule.getId();
                UALog.d((String)"Received a Push with an in-app message.", (Object[])new Object[0]);
                final String pendingMessageId = LegacyInAppMessageManager.this.preferenceDataStore.getString(LegacyInAppMessageManager.PENDING_MESSAGE_ID, null);
                if (pendingMessageId != null) {
                    LegacyInAppMessageManager.this.inAppAutomation.cancelSchedule(pendingMessageId).addResultCallback((ResultCallback)new ResultCallback<Boolean>(){

                        public void onResult(@Nullable Boolean result) {
                            if (result != null && result.booleanValue()) {
                                UALog.d((String)"Pending in-app message replaced.", (Object[])new Object[0]);
                                InAppReportingEvent.legacyReplaced(pendingMessageId, messageId).record(LegacyInAppMessageManager.this.analytics);
                            }
                        }
                    });
                }
                LegacyInAppMessageManager.this.inAppAutomation.schedule(schedule);
                LegacyInAppMessageManager.this.preferenceDataStore.put(LegacyInAppMessageManager.PENDING_MESSAGE_ID, messageId);
            }
        });
        this.pushManager.addInternalNotificationListener(new InternalNotificationListener(){

            @MainThread
            public void onNotificationResponse(@NonNull NotificationInfo notificationInfo, @Nullable NotificationActionButtonInfo actionButtonInfo) {
                final PushMessage push = notificationInfo.getMessage();
                if (push.getSendId() == null || !push.containsKey("com.urbanairship.in_app")) {
                    return;
                }
                LegacyInAppMessageManager.this.inAppAutomation.cancelSchedule(push.getSendId()).addResultCallback((ResultCallback)new ResultCallback<Boolean>(){

                    public void onResult(@Nullable Boolean result) {
                        if (result != null && result.booleanValue()) {
                            UALog.d((String)"Clearing pending in-app message due to directly interacting with the message's push notification.", (Object[])new Object[0]);
                            InAppReportingEvent.legacyPushOpened(push.getSendId()).record(LegacyInAppMessageManager.this.analytics);
                        }
                    }
                });
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getComponentGroup() {
        return 3;
    }

    public void setMessageBuilderExtender(@Nullable MessageBuilderExtender messageBuilderExtender) {
        this.messageBuilderExtender = messageBuilderExtender;
    }

    public void setScheduleBuilderExtender(@Nullable ScheduleBuilderExtender scheduleBuilderExtender) {
        this.scheduleBuilderExtender = scheduleBuilderExtender;
    }

    public void setDisplayAsapEnabled(boolean enabled) {
        this.displayAsapEnabled = enabled;
    }

    public boolean getDisplayAsapEnabled() {
        return this.displayAsapEnabled;
    }

    @Nullable
    private Schedule<InAppMessage> createSchedule(@NonNull Context context, @NonNull LegacyInAppMessage legacyInAppMessage) {
        try {
            Trigger trigger = this.displayAsapEnabled ? Triggers.newActiveSessionTriggerBuilder().build() : Triggers.newForegroundTriggerBuilder().build();
            Schedule.Builder<InAppMessage> builder = Schedule.newBuilder(this.createMessage(context, legacyInAppMessage)).addTrigger(trigger).setEnd(legacyInAppMessage.getExpiry()).setId(legacyInAppMessage.getId()).setCampaigns(legacyInAppMessage.getCampaigns()).setMessageType(legacyInAppMessage.getMessageType());
            ScheduleBuilderExtender builderExtender = this.scheduleBuilderExtender;
            if (builderExtender != null) {
                builderExtender.extend(context, builder, legacyInAppMessage);
            }
            return builder.build();
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Error during factory method to convert legacy in-app message.", (Object[])new Object[0]);
            return null;
        }
    }

    @NonNull
    private InAppMessage createMessage(@NonNull Context context, @NonNull LegacyInAppMessage legacyMessage) {
        NotificationActionButtonGroup group;
        int primaryColor = legacyMessage.getPrimaryColor() == null ? -1 : legacyMessage.getPrimaryColor();
        int secondaryColor = legacyMessage.getSecondaryColor() == null ? -16777216 : legacyMessage.getSecondaryColor();
        BannerDisplayContent.Builder displayContentBuilder = BannerDisplayContent.newBuilder().setBackgroundColor(primaryColor).setDismissButtonColor(secondaryColor).setBorderRadius(2.0f).setButtonLayout("separate").setPlacement(legacyMessage.getPlacement()).setActions(legacyMessage.getClickActionValues()).setBody(TextInfo.newBuilder().setText(legacyMessage.getAlert()).setColor(secondaryColor).build());
        if (legacyMessage.getDuration() != null) {
            displayContentBuilder.setDuration(legacyMessage.getDuration(), TimeUnit.MILLISECONDS);
        }
        if (legacyMessage.getButtonGroupId() != null && (group = this.pushManager.getNotificationActionGroup(legacyMessage.getButtonGroupId())) != null) {
            for (int i = 0; i < group.getNotificationActionButtons().size() && i < 2; ++i) {
                NotificationActionButton button = (NotificationActionButton)group.getNotificationActionButtons().get(i);
                TextInfo.Builder labelBuilder = TextInfo.newBuilder().setDrawable(context, button.getIcon()).setColor(primaryColor).setAlignment("center").setText(button.getLabel(context));
                ButtonInfo.Builder buttonInfoBuilder = ButtonInfo.newBuilder().setActions(legacyMessage.getButtonActionValues(button.getId())).setId(button.getId()).setBackgroundColor(secondaryColor).setBorderRadius(2.0f).setLabel(labelBuilder.build());
                displayContentBuilder.addButton(buttonInfoBuilder.build());
            }
        }
        InAppMessage.Builder builder = InAppMessage.newBuilder().setDisplayContent(displayContentBuilder.build()).setExtras(legacyMessage.getExtras()).setSource("legacy-push");
        MessageBuilderExtender builderExtender = this.messageBuilderExtender;
        if (builderExtender != null) {
            builderExtender.extend(context, builder, legacyMessage);
        }
        return builder.build();
    }

    public static interface ScheduleBuilderExtender {
        @NonNull
        public Schedule.Builder<InAppMessage> extend(@NonNull Context var1, @NonNull Schedule.Builder<InAppMessage> var2, @NonNull LegacyInAppMessage var3);
    }

    public static interface MessageBuilderExtender {
        @NonNull
        public InAppMessage.Builder extend(@NonNull Context var1, @NonNull InAppMessage.Builder var2, @NonNull LegacyInAppMessage var3);
    }
}

