/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.content.Context;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.iam.ForegroundDisplayAdapter;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.MediaInfo;
import com.urbanairship.iam.assets.Assets;
import com.urbanairship.util.Network;

public abstract class MediaDisplayAdapter
extends ForegroundDisplayAdapter {
    private final InAppMessage message;
    private final MediaInfo mediaInfo;
    private Assets assets;

    protected MediaDisplayAdapter(@NonNull InAppMessage message, @Nullable MediaInfo mediaInfo) {
        this.message = message;
        this.mediaInfo = mediaInfo;
    }

    @Override
    public int onPrepare(@NonNull Context context, @NonNull Assets assets) {
        this.assets = assets;
        return 0;
    }

    @Override
    @CallSuper
    public void onFinish(@NonNull Context context) {
    }

    @NonNull
    protected InAppMessage getMessage() {
        return this.message;
    }

    @Override
    @CallSuper
    public boolean isReady(@NonNull Context context) {
        if (!super.isReady(context)) {
            return false;
        }
        if (this.mediaInfo == null) {
            return true;
        }
        if (this.assets == null || !this.assets.file(this.mediaInfo.getUrl()).exists()) {
            return Network.shared().isConnected(context);
        }
        return true;
    }

    @Nullable
    public Assets getAssets() {
        return this.assets;
    }
}

