/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.Checks;
import com.urbanairship.util.UAStringUtil;

public class MediaInfo
implements JsonSerializable {
    @NonNull
    public static final String TYPE_IMAGE = "image";
    @NonNull
    public static final String TYPE_VIDEO = "video";
    @NonNull
    public static final String TYPE_YOUTUBE = "youtube";
    private static final String URL_KEY = "url";
    private static final String DESCRIPTION_KEY = "description";
    private static final String TYPE_KEY = "type";
    private final String url;
    private final String description;
    private final String type;

    private MediaInfo(@NonNull Builder builder) {
        this.url = builder.url;
        this.description = builder.description;
        this.type = builder.type;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put(URL_KEY, this.url).put(DESCRIPTION_KEY, this.description).put(TYPE_KEY, this.type).build().toJsonValue();
    }

    @NonNull
    public static MediaInfo fromJson(@NonNull JsonValue value) throws JsonException {
        try {
            return MediaInfo.newBuilder().setUrl(value.optMap().opt(URL_KEY).optString()).setType(value.optMap().opt(TYPE_KEY).optString()).setDescription(value.optMap().opt(DESCRIPTION_KEY).optString()).build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid media object json: " + value, (Throwable)e);
        }
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)o;
        if (this.url != null ? !this.url.equals(mediaInfo.url) : mediaInfo.url != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(mediaInfo.description) : mediaInfo.description != null) {
            return false;
        }
        return this.type != null ? this.type.equals(mediaInfo.type) : mediaInfo.type == null;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return this.toJsonValue().toString();
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public static Builder newBuilder(@NonNull MediaInfo mediaInfo) {
        return new Builder(mediaInfo);
    }

    public static class Builder {
        private String url;
        private String type;
        private String description;

        private Builder() {
        }

        private Builder(MediaInfo mediaInfo) {
            this.url = mediaInfo.url;
            this.description = mediaInfo.description;
            this.type = mediaInfo.type;
        }

        @NonNull
        public Builder setUrl(@NonNull String url) {
            this.url = url;
            return this;
        }

        @NonNull
        public Builder setType(@NonNull String type) {
            this.type = type;
            return this;
        }

        @NonNull
        public Builder setDescription(@NonNull String description) {
            this.description = description;
            return this;
        }

        @NonNull
        public MediaInfo build() {
            Checks.checkArgument((!UAStringUtil.isEmpty((String)this.url) ? 1 : 0) != 0, (String)"Missing URL");
            Checks.checkArgument((!UAStringUtil.isEmpty((String)this.type) ? 1 : 0) != 0, (String)"Missing type");
            Checks.checkArgument((!UAStringUtil.isEmpty((String)this.description) ? 1 : 0) != 0, (String)"Missing description");
            return new MediaInfo(this);
        }
    }
}

