/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.TextInfo;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class ResolutionInfo
implements JsonSerializable {
    @NonNull
    public static final String RESOLUTION_BUTTON_CLICK = "button_click";
    @NonNull
    public static final String RESOLUTION_MESSAGE_CLICK = "message_click";
    @NonNull
    public static final String RESOLUTION_USER_DISMISSED = "user_dismissed";
    @NonNull
    public static final String RESOLUTION_TIMED_OUT = "timed_out";
    @NonNull
    public static final String TYPE_KEY = "type";
    @NonNull
    public static final String BUTTON_INFO_KEY = "button_info";
    @NonNull
    private final String type;
    @Nullable
    private final ButtonInfo buttonInfo;

    private ResolutionInfo(@NonNull String type) {
        this.type = type;
        this.buttonInfo = null;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put(TYPE_KEY, this.getType()).putOpt(BUTTON_INFO_KEY, (Object)this.getButtonInfo()).build().toJsonValue();
    }

    @NonNull
    public static ResolutionInfo fromJson(@NonNull JsonValue value) throws JsonException {
        JsonMap content = value.optMap();
        String type = content.opt(TYPE_KEY).getString();
        if (type == null) {
            throw new JsonException("ResolutionInfo must contain a type");
        }
        ButtonInfo buttonInfo = null;
        if (content.opt(BUTTON_INFO_KEY).isJsonMap()) {
            buttonInfo = ButtonInfo.fromJson(content.opt(BUTTON_INFO_KEY));
        }
        return new ResolutionInfo(type, buttonInfo);
    }

    private ResolutionInfo(@NonNull String type, @Nullable ButtonInfo buttonInfo) {
        this.type = type;
        this.buttonInfo = buttonInfo;
    }

    @NonNull
    public static ResolutionInfo buttonPressed(@NonNull ButtonInfo buttonInfo) {
        return new ResolutionInfo(RESOLUTION_BUTTON_CLICK, buttonInfo);
    }

    @NonNull
    public static ResolutionInfo buttonPressed(@NonNull String buttonId, @Nullable String buttonDescription, boolean cancel) {
        ButtonInfo buttonInfo = ButtonInfo.newBuilder().setBehavior(cancel ? "cancel" : "dismiss").setId(buttonId).setLabel(TextInfo.newBuilder().setText(buttonDescription == null ? buttonId : buttonDescription).build()).build(false);
        return new ResolutionInfo(RESOLUTION_BUTTON_CLICK, buttonInfo);
    }

    @NonNull
    public static ResolutionInfo messageClicked() {
        return new ResolutionInfo(RESOLUTION_MESSAGE_CLICK);
    }

    @NonNull
    public static ResolutionInfo dismissed() {
        return new ResolutionInfo(RESOLUTION_USER_DISMISSED);
    }

    @NonNull
    public static ResolutionInfo timedOut() {
        return new ResolutionInfo(RESOLUTION_TIMED_OUT);
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @Nullable
    public ButtonInfo getButtonInfo() {
        return this.buttonInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolutionInfo that = (ResolutionInfo)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.buttonInfo != null ? this.buttonInfo.equals(that.buttonInfo) : that.buttonInfo == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.buttonInfo != null ? this.buttonInfo.hashCode() : 0);
        return result;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

