/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.urbanairship.UALog;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.Checks;
import com.urbanairship.util.ColorUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TextInfo
implements JsonSerializable {
    private static final String TEXT_KEY = "text";
    private static final String SIZE_KEY = "size";
    private static final String COLOR_KEY = "color";
    private static final String ALIGNMENT_KEY = "alignment";
    private static final String STYLE_KEY = "style";
    private static final String FONT_FAMILY_KEY = "font_family";
    private static final String ANDROID_DRAWABLE_RES_NAME_KEY = "android_drawable_res_name";
    @NonNull
    public static final String ALIGNMENT_RIGHT = "right";
    @NonNull
    public static final String ALIGNMENT_LEFT = "left";
    @NonNull
    public static final String ALIGNMENT_CENTER = "center";
    @NonNull
    public static final String STYLE_BOLD = "bold";
    @NonNull
    public static final String STYLE_UNDERLINE = "underline";
    @NonNull
    public static final String STYLE_ITALIC = "italic";
    private final String text;
    @ColorInt
    private final Integer color;
    private final Float size;
    private final String alignment;
    private final List<String> styles;
    private final List<String> fontFamilies;
    private final String drawableName;

    private TextInfo(@NonNull Builder builder) {
        this.text = builder.text;
        this.color = builder.color;
        this.size = builder.size;
        this.alignment = builder.alignment;
        this.styles = new ArrayList<String>(builder.styles);
        this.drawableName = builder.drawableName;
        this.fontFamilies = new ArrayList<String>(builder.fontFamilies);
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put(TEXT_KEY, this.text).putOpt(COLOR_KEY, this.color == null ? null : ColorUtils.convertToString((int)this.color)).putOpt(SIZE_KEY, (Object)this.size).put(ALIGNMENT_KEY, this.alignment).put(STYLE_KEY, (JsonSerializable)JsonValue.wrapOpt(this.styles)).put(FONT_FAMILY_KEY, (JsonSerializable)JsonValue.wrapOpt(this.fontFamilies)).putOpt(ANDROID_DRAWABLE_RES_NAME_KEY, (Object)this.drawableName).build().toJsonValue();
    }

    @NonNull
    public static TextInfo fromJson(@NonNull JsonValue value) throws JsonException {
        JsonMap content = value.optMap();
        Builder builder = TextInfo.newBuilder();
        if (content.containsKey(TEXT_KEY)) {
            builder.setText(content.opt(TEXT_KEY).optString());
        }
        if (content.containsKey(COLOR_KEY)) {
            try {
                builder.setColor(Color.parseColor((String)content.opt(COLOR_KEY).optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid color: " + content.opt(COLOR_KEY), (Throwable)e);
            }
        }
        if (content.containsKey(SIZE_KEY)) {
            if (!content.opt(SIZE_KEY).isNumber()) {
                throw new JsonException("Size must be a number: " + content.opt(SIZE_KEY));
            }
            builder.setFontSize(content.opt(SIZE_KEY).getFloat(0.0f));
        }
        if (content.containsKey(ALIGNMENT_KEY)) {
            switch (content.opt(ALIGNMENT_KEY).optString()) {
                case "center": {
                    builder.setAlignment(ALIGNMENT_CENTER);
                    break;
                }
                case "left": {
                    builder.setAlignment(ALIGNMENT_LEFT);
                    break;
                }
                case "right": {
                    builder.setAlignment(ALIGNMENT_RIGHT);
                    break;
                }
                default: {
                    throw new JsonException("Unexpected alignment: " + content.opt(ALIGNMENT_KEY));
                }
            }
        }
        if (content.containsKey(STYLE_KEY)) {
            if (!content.opt(STYLE_KEY).isJsonList()) {
                throw new JsonException("Style must be an array: " + content.opt(STYLE_KEY));
            }
            block24: for (JsonValue val : content.opt(STYLE_KEY).optList()) {
                switch (val.optString().toLowerCase(Locale.ROOT)) {
                    case "bold": {
                        builder.addStyle(STYLE_BOLD);
                        continue block24;
                    }
                    case "italic": {
                        builder.addStyle(STYLE_ITALIC);
                        continue block24;
                    }
                    case "underline": {
                        builder.addStyle(STYLE_UNDERLINE);
                        continue block24;
                    }
                }
                throw new JsonException("Invalid style: " + val);
            }
        }
        if (content.containsKey(FONT_FAMILY_KEY)) {
            if (!content.opt(FONT_FAMILY_KEY).isJsonList()) {
                throw new JsonException("Fonts must be an array: " + content.opt(STYLE_KEY));
            }
            for (JsonValue val : content.opt(FONT_FAMILY_KEY).optList()) {
                if (!val.isString()) {
                    throw new JsonException("Invalid font: " + val);
                }
                builder.addFontFamily(val.optString());
            }
        }
        builder.setDrawableName(content.opt(ANDROID_DRAWABLE_RES_NAME_KEY).getString());
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid text object JSON: " + content, (Throwable)e);
        }
    }

    @Nullable
    public String getText() {
        return this.text;
    }

    @Nullable
    public Float getFontSize() {
        return this.size;
    }

    @Nullable
    public Integer getColor() {
        return this.color;
    }

    @Nullable
    public String getAlignment() {
        return this.alignment;
    }

    @NonNull
    public List<String> getStyles() {
        return this.styles;
    }

    @NonNull
    public List<String> getFontFamilies() {
        return this.fontFamilies;
    }

    @DrawableRes
    public int getDrawable(@NonNull Context context) {
        if (this.drawableName != null) {
            try {
                return context.getResources().getIdentifier(this.drawableName, "drawable", context.getPackageName());
            }
            catch (Resources.NotFoundException e) {
                UALog.d((String)("Drawable " + this.drawableName + " no longer exists."), (Object[])new Object[0]);
                return 0;
            }
        }
        return 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextInfo textInfo = (TextInfo)o;
        if (this.drawableName != null ? !this.drawableName.equals(textInfo.drawableName) : textInfo.drawableName != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(textInfo.text) : textInfo.text != null) {
            return false;
        }
        if (this.color != null ? !this.color.equals(textInfo.color) : textInfo.color != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(textInfo.size) : textInfo.size != null) {
            return false;
        }
        if (this.alignment != null ? !this.alignment.equals(textInfo.alignment) : textInfo.alignment != null) {
            return false;
        }
        if (!this.styles.equals(textInfo.styles)) {
            return false;
        }
        return this.fontFamilies.equals(textInfo.fontFamilies);
    }

    public int hashCode() {
        int result = this.text != null ? this.text.hashCode() : 0;
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        result = 31 * result + (this.alignment != null ? this.alignment.hashCode() : 0);
        result = 31 * result + this.styles.hashCode();
        result = 31 * result + this.fontFamilies.hashCode();
        result = 31 * result + (this.drawableName != null ? this.drawableName.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return this.toJsonValue().toString();
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public static Builder newBuilder(@NonNull TextInfo textInfo) {
        return new Builder(textInfo);
    }

    public static class Builder {
        private String text;
        @ColorInt
        private Integer color;
        private Float size;
        private String drawableName;
        private String alignment;
        private List<String> styles = new ArrayList<String>();
        private List<String> fontFamilies = new ArrayList<String>();

        private Builder() {
        }

        private Builder(@NonNull TextInfo textInfo) {
            this.text = textInfo.text;
            this.color = textInfo.color;
            this.size = textInfo.size;
            this.alignment = textInfo.alignment;
            this.styles = textInfo.styles;
            this.drawableName = textInfo.drawableName;
            this.fontFamilies = textInfo.fontFamilies;
        }

        @NonNull
        public Builder setText(@Nullable @Size(min=1L) String text) {
            this.text = text;
            return this;
        }

        @NonNull
        public Builder setDrawable(@NonNull Context context, @DrawableRes int drawable) {
            try {
                this.drawableName = context.getResources().getResourceName(drawable);
            }
            catch (Resources.NotFoundException e) {
                UALog.d((String)("Drawable " + drawable + " no longer exists or has a new identifier."), (Object[])new Object[0]);
            }
            return this;
        }

        @NonNull
        Builder setDrawableName(@Nullable String drawableName) {
            this.drawableName = drawableName;
            return this;
        }

        @NonNull
        public Builder setColor(@ColorInt int color) {
            this.color = color;
            return this;
        }

        @NonNull
        public Builder setFontSize(float size) {
            this.size = Float.valueOf(size);
            return this;
        }

        @NonNull
        public Builder setAlignment(@NonNull String alignment) {
            this.alignment = alignment;
            return this;
        }

        @NonNull
        public Builder addStyle(@NonNull String style) {
            if (!this.styles.contains(style)) {
                this.styles.add(style);
            }
            return this;
        }

        @NonNull
        public Builder addFontFamily(@NonNull String font) {
            this.fontFamilies.add(font);
            return this;
        }

        @NonNull
        public TextInfo build() {
            Checks.checkArgument((this.drawableName != null || this.text != null ? 1 : 0) != 0, (String)"Missing text.");
            return new TextInfo(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Style {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Alignment {
    }
}

