/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.actions;

import android.net.Uri;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Supplier;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.UrlAllowList;
import com.urbanairship.actions.Action;
import com.urbanairship.actions.ActionArguments;
import com.urbanairship.actions.ActionResult;
import com.urbanairship.automation.InAppAutomation;
import com.urbanairship.automation.Schedule;
import com.urbanairship.automation.Triggers;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.html.HtmlDisplayContent;
import com.urbanairship.json.JsonMap;
import com.urbanairship.push.PushMessage;
import com.urbanairship.util.Checks;
import com.urbanairship.util.UAStringUtil;
import com.urbanairship.util.UriUtils;
import java.util.UUID;

public class LandingPageAction
extends Action {
    @NonNull
    public static final String DEFAULT_REGISTRY_NAME = "landing_page_action";
    @NonNull
    public static final String DEFAULT_REGISTRY_SHORT_NAME = "^p";
    @NonNull
    public static final String URL_KEY = "url";
    @NonNull
    private static final String LEGACY_ASPECT_LOCK_KEY = "aspectLock";
    public static final float DEFAULT_BORDER_RADIUS = 2.0f;
    private final Supplier<InAppAutomation> inAppAutomationSupplier;
    private final Supplier<UrlAllowList> allowListSupplier;
    private float borderRadius = 2.0f;

    public LandingPageAction() {
        this((Supplier<InAppAutomation>)((Supplier)InAppAutomation::shared), (Supplier<UrlAllowList>)((Supplier)() -> UAirship.shared().getUrlAllowList()));
    }

    @VisibleForTesting
    LandingPageAction(@NonNull Supplier<InAppAutomation> inAppAutomationSupplier, @NonNull Supplier<UrlAllowList> allowListSupplier) {
        this.inAppAutomationSupplier = inAppAutomationSupplier;
        this.allowListSupplier = allowListSupplier;
    }

    @NonNull
    public ActionResult perform(@NonNull ActionArguments arguments) {
        InAppAutomation inAppAutomation = (InAppAutomation)this.inAppAutomationSupplier.get();
        Uri uri = this.parseUri(arguments);
        Checks.checkNotNull((Object)uri, (String)"URI should not be null");
        inAppAutomation.schedule(this.createSchedule(uri, arguments));
        return ActionResult.newEmptyResult();
    }

    public void setBorderRadius(@FloatRange(from=0.0) float borderRadius) {
        this.borderRadius = borderRadius;
    }

    public float getBorderRadius() {
        return this.borderRadius;
    }

    @NonNull
    protected Schedule<InAppMessage> createSchedule(@NonNull Uri uri, @NonNull ActionArguments arguments) {
        String messageId;
        JsonMap options = arguments.getValue().toJsonValue().optMap();
        int width = options.opt("width").getInt(0);
        int height = options.opt("height").getInt(0);
        boolean aspectLock = options.containsKey("aspect_lock") ? options.opt("aspect_lock").getBoolean(false) : options.opt(LEGACY_ASPECT_LOCK_KEY).getBoolean(false);
        boolean reportEvents = false;
        PushMessage pushMessage = (PushMessage)arguments.getMetadata().getParcelable("com.urbanairship.PUSH_MESSAGE");
        if (pushMessage != null && pushMessage.getSendId() != null) {
            messageId = pushMessage.getSendId();
            reportEvents = true;
        } else {
            messageId = UUID.randomUUID().toString();
        }
        InAppMessage.Builder messageBuilder = InAppMessage.newBuilder().setDisplayContent(HtmlDisplayContent.newBuilder().setUrl(uri.toString()).setAllowFullscreenDisplay(false).setBorderRadius(this.borderRadius).setSize(width, height, aspectLock).setRequireConnectivity(false).build()).setReportingEnabled(reportEvents).setDisplayBehavior("immediate");
        InAppMessage message = this.extendMessage(messageBuilder).build();
        Schedule.Builder<InAppMessage> scheduleInfoBuilder = Schedule.newBuilder(message).setId(messageId).addTrigger(Triggers.newActiveSessionTriggerBuilder().setGoal(1.0).build()).setLimit(1).setBypassHoldoutGroups(true).setProductId("landing_page").setPriority(Integer.MIN_VALUE);
        return this.extendSchedule(scheduleInfoBuilder).build();
    }

    @NonNull
    protected InAppMessage.Builder extendMessage(@NonNull InAppMessage.Builder builder) {
        return builder;
    }

    @NonNull
    protected Schedule.Builder<InAppMessage> extendSchedule(@NonNull Schedule.Builder<InAppMessage> builder) {
        return builder;
    }

    public boolean acceptsArguments(@NonNull ActionArguments arguments) {
        switch (arguments.getSituation()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                Uri uri = this.parseUri(arguments);
                return uri != null;
            }
        }
        return false;
    }

    @Nullable
    protected Uri parseUri(@NonNull ActionArguments arguments) {
        String uriValue = arguments.getValue().getMap() != null ? arguments.getValue().getMap().opt(URL_KEY).getString() : arguments.getValue().getString();
        if (uriValue == null) {
            return null;
        }
        Uri uri = UriUtils.parse((Object)uriValue);
        if (uri == null || UAStringUtil.isEmpty((String)uri.toString())) {
            return null;
        }
        if (UAStringUtil.isEmpty((String)uri.getScheme())) {
            uri = Uri.parse((String)("https://" + uri));
        }
        if (!((UrlAllowList)this.allowListSupplier.get()).isAllowed(uri.toString(), 2)) {
            UALog.e((String)"Landing page URL is not allowed: %s", (Object[])new Object[]{uri});
            return null;
        }
        return uri;
    }
}

