/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.assets;

import android.graphics.BitmapFactory;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.UALog;
import com.urbanairship.android.layout.info.ViewInfo;
import com.urbanairship.android.layout.util.UrlInfo;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.MediaInfo;
import com.urbanairship.iam.assets.Assets;
import com.urbanairship.iam.assets.PrepareAssetsDelegate;
import com.urbanairship.iam.banner.BannerDisplayContent;
import com.urbanairship.iam.fullscreen.FullScreenDisplayContent;
import com.urbanairship.iam.layout.AirshipLayoutDisplayContent;
import com.urbanairship.iam.modal.ModalDisplayContent;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.util.FileUtils;
import com.urbanairship.util.UAHttpStatusUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AirshipPrepareAssetsDelegate
implements PrepareAssetsDelegate {
    @NonNull
    public static final String IMAGE_WIDTH_CACHE_KEY = "width";
    @NonNull
    public static final String IMAGE_HEIGHT_CACHE_KEY = "height";

    @Override
    public void onSchedule(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull Assets assets) {
        this.onPrepare(scheduleId, message, assets);
    }

    @Override
    public int onPrepare(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull Assets assets) {
        List<String> cacheableUrls = this.getCacheableUrls(message);
        for (String url : cacheableUrls) {
            if (assets.file(url).exists()) continue;
            try {
                FileUtils.DownloadResult result = this.cacheImage(assets, url);
                if (result.isSuccess) continue;
                if (UAHttpStatusUtil.inClientErrorRange((int)result.statusCode)) {
                    return 2;
                }
                return 1;
            }
            catch (Exception e) {
                UALog.e((Throwable)e, (String)"Unable to download file: %s ", (Object[])new Object[]{url});
                return 1;
            }
        }
        return 0;
    }

    @NonNull
    protected FileUtils.DownloadResult cacheImage(@NonNull Assets assets, @NonNull String url) throws IOException {
        File file = assets.file(url);
        FileUtils.DownloadResult result = FileUtils.downloadFile((URL)new URL(url), (File)file);
        if (result.isSuccess) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)options);
            assets.setMetadata(url, (JsonSerializable)JsonMap.newBuilder().putOpt(IMAGE_WIDTH_CACHE_KEY, (Object)options.outWidth).putOpt(IMAGE_HEIGHT_CACHE_KEY, (Object)options.outHeight).build());
        }
        return result;
    }

    @NonNull
    private List<String> getCacheableUrls(@NonNull InAppMessage message) {
        switch (message.getType()) {
            case "banner": {
                String url;
                BannerDisplayContent bannerDisplayContent = (BannerDisplayContent)message.getDisplayContent();
                if (bannerDisplayContent == null || (url = AirshipPrepareAssetsDelegate.getCacheableUrl(bannerDisplayContent.getMedia())) == null) break;
                return Collections.singletonList(url);
            }
            case "fullscreen": {
                String url;
                FullScreenDisplayContent fullScreenDisplayContent = (FullScreenDisplayContent)message.getDisplayContent();
                if (fullScreenDisplayContent == null || (url = AirshipPrepareAssetsDelegate.getCacheableUrl(fullScreenDisplayContent.getMedia())) == null) break;
                return Collections.singletonList(url);
            }
            case "modal": {
                String url;
                ModalDisplayContent modalDisplayContent = (ModalDisplayContent)message.getDisplayContent();
                if (modalDisplayContent == null || (url = AirshipPrepareAssetsDelegate.getCacheableUrl(modalDisplayContent.getMedia())) == null) break;
                return Collections.singletonList(url);
            }
            case "layout": {
                AirshipLayoutDisplayContent layoutContent = (AirshipLayoutDisplayContent)message.getDisplayContent();
                if (layoutContent == null) break;
                ArrayList<String> cacheableUrls = new ArrayList<String>();
                for (UrlInfo urlInfo : UrlInfo.from((ViewInfo)layoutContent.getPayload().getView())) {
                    if (urlInfo.getType() != UrlInfo.UrlType.IMAGE) continue;
                    cacheableUrls.add(urlInfo.getUrl());
                }
                return cacheableUrls;
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    public static String getCacheableUrl(@Nullable MediaInfo mediaInfo) {
        if (mediaInfo != null && mediaInfo.getType().equals("image")) {
            return mediaInfo.getUrl();
        }
        return null;
    }
}

