/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.assets;

import android.content.Context;
import android.os.Build;
import android.os.storage.StorageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.urbanairship.UALog;
import com.urbanairship.iam.assets.Assets;
import com.urbanairship.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class AssetCache {
    private static final String CACHE_DIRECTORY = "com.urbanairship.iam.assets";
    private final File storageDirectory;
    private final StorageManager storageManager;
    @NonNull
    private final Map<String, Assets> activeAssets = new HashMap<String, Assets>();

    AssetCache(@NonNull Context context) {
        this.storageDirectory = new File(context.getCacheDir(), CACHE_DIRECTORY);
        this.storageManager = AssetCache.findStorageManager(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @NonNull
    Assets getAssets(@NonNull String scheduleId) {
        Map<String, Assets> map = this.activeAssets;
        synchronized (map) {
            Assets assets = this.activeAssets.get(scheduleId);
            if (assets == null) {
                assets = Assets.load(this.getAssetsDirectory(scheduleId));
                this.activeAssets.put(scheduleId, assets);
            }
            return assets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void releaseAssets(@NonNull String scheduleId, boolean wipeFromDisk) {
        Map<String, Assets> map = this.activeAssets;
        synchronized (map) {
            if (wipeFromDisk) {
                FileUtils.deleteRecursively((File)this.getAssetsDirectory(scheduleId));
            }
            this.activeAssets.remove(scheduleId);
        }
    }

    @NonNull
    private File getAssetsDirectory(@NonNull String scheduleId) {
        File assetDirectory;
        if (!this.storageDirectory.exists() && !this.storageDirectory.mkdirs()) {
            UALog.e((String)"Failed to create asset storage directory.", (Object[])new Object[0]);
        }
        if (!(assetDirectory = new File(this.storageDirectory, scheduleId)).exists() && !assetDirectory.mkdirs()) {
            UALog.e((String)"Failed to create assets directory.", (Object[])new Object[0]);
        }
        if (this.storageManager != null && Build.VERSION.SDK_INT >= 26 && assetDirectory.exists()) {
            try {
                this.storageManager.setCacheBehaviorGroup(assetDirectory, true);
            }
            catch (IOException e) {
                UALog.e((Throwable)e, (String)"Failed to set cache behavior on directory: %s", (Object[])new Object[]{assetDirectory.getAbsoluteFile()});
            }
        }
        return assetDirectory;
    }

    @Nullable
    private static StorageManager findStorageManager(@NonNull Context context) {
        try {
            return (StorageManager)context.getSystemService("storage");
        }
        catch (Exception e) {
            return null;
        }
    }
}

