/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.assets;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.urbanairship.UALog;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.assets.AirshipPrepareAssetsDelegate;
import com.urbanairship.iam.assets.AssetCache;
import com.urbanairship.iam.assets.Assets;
import com.urbanairship.iam.assets.CachePolicyDelegate;
import com.urbanairship.iam.assets.PrepareAssetsDelegate;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Callable;

public class AssetManager {
    public static final int PREPARE_RESULT_OK = 0;
    public static final int PREPARE_RESULT_RETRY = 1;
    public static final int PREPARE_RESULT_CANCEL = 2;
    @Nullable
    private PrepareAssetsDelegate assetsDelegate;
    @Nullable
    private CachePolicyDelegate cachePolicyDelegate;
    @NonNull
    private final AssetCache assetCache;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public AssetManager(@NonNull Context context) {
        this.assetCache = new AssetCache(context);
        this.assetsDelegate = new AirshipPrepareAssetsDelegate();
    }

    @VisibleForTesting
    AssetManager(@NonNull AssetCache assetCache) {
        this.assetCache = assetCache;
    }

    public void setPrepareAssetDelegate(@Nullable PrepareAssetsDelegate assetsDelegate) {
        this.assetsDelegate = assetsDelegate;
    }

    public void setCachePolicyDelegate(@Nullable CachePolicyDelegate cachePolicyDelegate) {
        this.cachePolicyDelegate = cachePolicyDelegate;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @WorkerThread
    public void onSchedule(@NonNull String scheduleId, @NonNull Callable<InAppMessage> extendedMessageCallable) {
        CachePolicyDelegate cachePolicyDelegate = this.cachePolicyDelegate;
        PrepareAssetsDelegate assetsDelegate = this.assetsDelegate;
        if (cachePolicyDelegate != null && assetsDelegate != null) {
            try {
                InAppMessage message = extendedMessageCallable.call();
                if (cachePolicyDelegate.shouldCacheOnSchedule(scheduleId, message)) {
                    Assets assets = this.assetCache.getAssets(scheduleId);
                    assetsDelegate.onSchedule(scheduleId, message, assets);
                    this.assetCache.releaseAssets(scheduleId, false);
                }
            }
            catch (Exception e) {
                UALog.e((Throwable)e, (String)"Unable to prepare assets for schedule: %s", (Object[])new Object[]{scheduleId});
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @WorkerThread
    public int onPrepare(@NonNull String scheduleId, @NonNull InAppMessage message) {
        PrepareAssetsDelegate assetsDelegate = this.assetsDelegate;
        if (assetsDelegate != null) {
            Assets assets = this.assetCache.getAssets(scheduleId);
            return assetsDelegate.onPrepare(scheduleId, message, assets);
        }
        return 0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @WorkerThread
    public void onDisplayFinished(@NonNull String scheduleId, @NonNull InAppMessage inAppMessage) {
        CachePolicyDelegate cachePolicyDelegate = this.cachePolicyDelegate;
        boolean delete = false;
        if (cachePolicyDelegate == null || !cachePolicyDelegate.shouldPersistCacheAfterDisplay(scheduleId, inAppMessage)) {
            delete = true;
        }
        this.assetCache.releaseAssets(scheduleId, delete);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @WorkerThread
    public void onFinish(@NonNull String scheduleId) {
        this.assetCache.releaseAssets(scheduleId, true);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public Assets getAssets(@NonNull String scheduleId) {
        return this.assetCache.getAssets(scheduleId);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrepareResult {
    }
}

