/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.assets;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.storage.StorageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.urbanairship.AirshipExecutors;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.UAStringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class Assets
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<Assets> CREATOR = new Parcelable.Creator<Assets>(){

        @NonNull
        public Assets createFromParcel(@NonNull Parcel in) {
            JsonMap parsedMap;
            try {
                parsedMap = JsonValue.parseString((String)in.readString()).optMap();
            }
            catch (JsonException e) {
                UALog.e((Throwable)e, (String)"Failed to parse metadata", (Object[])new Object[0]);
                parsedMap = JsonMap.EMPTY_MAP;
            }
            return new Assets(new File(in.readString()), parsedMap);
        }

        @NonNull
        public Assets[] newArray(int size) {
            return new Assets[size];
        }
    };
    private static final String METADATA_FILE = "metadata";
    private static final String FILES_DIRECTORY = "files";
    private final Executor executor;
    private final File rootDirectory;
    private final File filesDirectory;
    private final File metadataFile;
    private final Map<String, JsonValue> metadata;
    private final Object metadataLock = new Object();

    @WorkerThread
    @NonNull
    static Assets load(@NonNull File root) {
        File metadata = new File(root, METADATA_FILE);
        return new Assets(root, Assets.readJson(metadata).optMap());
    }

    private Assets(@NonNull File root, @NonNull JsonMap metadata) {
        this.rootDirectory = root;
        this.filesDirectory = new File(root, FILES_DIRECTORY);
        this.metadataFile = new File(root, METADATA_FILE);
        this.metadata = new HashMap<String, JsonValue>(metadata.getMap());
        this.executor = AirshipExecutors.newSerialExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        Object object = this.metadataLock;
        synchronized (object) {
            dest.writeString(JsonValue.wrapOpt(this.metadata).toString());
        }
        dest.writeString(this.rootDirectory.getAbsolutePath());
    }

    public int describeContents() {
        return 0;
    }

    @NonNull
    public File file(@NonNull String key) {
        this.prepareDirectory();
        return new File(this.filesDirectory, UAStringUtil.sha256((String)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public JsonValue getMetadata(@NonNull String key) {
        Object object = this.metadataLock;
        synchronized (object) {
            JsonValue value = this.metadata.get(key);
            return value == null ? JsonValue.NULL : value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetadata(@NonNull String key, @NonNull JsonSerializable value) {
        Object object = this.metadataLock;
        synchronized (object) {
            this.metadata.put(key, value.toJsonValue());
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Assets.this.writeJson(Assets.this.metadataFile, JsonValue.wrapOpt((Object)Assets.this.metadata));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void writeJson(@NonNull File file, @NonNull JsonValue jsonValue) {
        this.prepareDirectory();
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            outputStream.write(jsonValue.toString().getBytes());
            outputStream.close();
        }
        catch (Exception e) {
            try {
                UALog.e((Throwable)e, (String)"Failed to write metadata.", (Object[])new Object[0]);
            }
            catch (Throwable throwable) {
                Assets.closeQuietly(outputStream);
                throw throwable;
            }
            Assets.closeQuietly(outputStream);
        }
        Assets.closeQuietly(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private static JsonValue readJson(File file) {
        JsonValue jsonValue;
        if (!file.exists()) {
            return JsonValue.NULL;
        }
        BufferedReader reader = null;
        try {
            int count;
            reader = new BufferedReader(new FileReader(file));
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            while ((count = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, count);
            }
            jsonValue = JsonValue.parseString((String)writer.toString());
        }
        catch (IOException e) {
            UALog.e((Throwable)e, (String)"Error reading file", (Object[])new Object[0]);
            Assets.closeQuietly(reader);
        }
        catch (JsonException e2) {
            UALog.e((Throwable)e2, (String)"Error parsing file as JSON.", (Object[])new Object[0]);
            {
                catch (Throwable throwable) {
                    Assets.closeQuietly(reader);
                    throw throwable;
                }
            }
            Assets.closeQuietly(reader);
        }
        Assets.closeQuietly(reader);
        return jsonValue;
        return JsonValue.NULL;
    }

    private static void closeQuietly(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                UALog.e((Throwable)e);
            }
        }
    }

    private void prepareDirectory() {
        if (!this.rootDirectory.exists()) {
            if (this.rootDirectory.mkdirs()) {
                if (Build.VERSION.SDK_INT >= 26) {
                    try {
                        StorageManager storageManager = (StorageManager)UAirship.getApplicationContext().getSystemService("storage");
                        storageManager.setCacheBehaviorGroup(this.rootDirectory, true);
                    }
                    catch (IOException e) {
                        UALog.e((Throwable)e, (String)"Failed to set cache behavior on directory: %s", (Object[])new Object[]{this.rootDirectory.getAbsoluteFile()});
                    }
                }
            } else {
                UALog.e((String)"Failed to create assets directory.", (Object[])new Object[0]);
            }
        }
        if (!this.filesDirectory.exists() && !this.filesDirectory.mkdirs()) {
            UALog.e((String)"Failed to create directory: %s", (Object[])new Object[]{this.filesDirectory.getAbsoluteFile()});
        }
    }
}

