/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.banner;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.urbanairship.Predicate;
import com.urbanairship.UALog;
import com.urbanairship.app.ActivityListener;
import com.urbanairship.app.SimpleActivityListener;
import com.urbanairship.automation.R;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.DisplayHandler;
import com.urbanairship.iam.InAppActionUtils;
import com.urbanairship.iam.InAppActivityMonitor;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.MediaDisplayAdapter;
import com.urbanairship.iam.ResolutionInfo;
import com.urbanairship.iam.banner.BannerDisplayContent;
import com.urbanairship.iam.banner.BannerView;
import com.urbanairship.iam.view.InAppViewUtils;
import com.urbanairship.util.ManifestUtils;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BannerAdapter
extends MediaDisplayAdapter {
    @NonNull
    public static final String BANNER_CONTAINER_ID = "com.urbanairship.iam.banner.BANNER_CONTAINER_ID";
    private final BannerDisplayContent displayContent;
    private static final Map<Class, Integer> cachedContainerIds = new HashMap<Class, Integer>();
    private final Predicate<Activity> activityPredicate = new Predicate<Activity>(){

        public boolean apply(Activity activity) {
            try {
                if (BannerAdapter.this.getContainerView(activity) == null) {
                    UALog.e((String)"BannerAdapter - Unable to display in-app message. No view group found.", (Object[])new Object[0]);
                    return false;
                }
            }
            catch (Exception e) {
                UALog.e((String)"Failed to find container view.", (Object[])new Object[]{e});
                return false;
            }
            return true;
        }
    };
    private final ActivityListener listener = new SimpleActivityListener(){

        public void onActivityStopped(@NonNull Activity activity) {
            if (BannerAdapter.this.activityPredicate.apply((Object)activity)) {
                BannerAdapter.this.onActivityStopped(activity);
            }
        }

        public void onActivityResumed(@NonNull Activity activity) {
            if (BannerAdapter.this.activityPredicate.apply((Object)activity)) {
                BannerAdapter.this.onActivityResumed(activity);
            }
        }

        public void onActivityPaused(@NonNull Activity activity) {
            if (BannerAdapter.this.activityPredicate.apply((Object)activity)) {
                BannerAdapter.this.onActivityPaused(activity);
            }
        }
    };
    private WeakReference<Activity> lastActivity;
    private WeakReference<BannerView> currentView;
    private DisplayHandler displayHandler;

    protected BannerAdapter(@NonNull InAppMessage message, @NonNull BannerDisplayContent displayContent) {
        super(message, displayContent.getMedia());
        this.displayContent = displayContent;
    }

    @NonNull
    public static BannerAdapter newAdapter(@NonNull InAppMessage message) {
        BannerDisplayContent displayContent = (BannerDisplayContent)message.getDisplayContent();
        if (displayContent == null) {
            throw new IllegalArgumentException("Invalid message for adapter: " + message);
        }
        return new BannerAdapter(message, displayContent);
    }

    @Override
    @MainThread
    @CallSuper
    public boolean isReady(@NonNull Context context) {
        if (!super.isReady(context)) {
            return false;
        }
        return !InAppActivityMonitor.shared(context).getResumedActivities(this.activityPredicate).isEmpty();
    }

    @Override
    @MainThread
    public void onDisplay(@NonNull Context context, @NonNull DisplayHandler displayHandler) {
        UALog.i((String)"BannerAdapter - Displaying in-app message.", (Object[])new Object[0]);
        this.displayHandler = displayHandler;
        InAppActivityMonitor.shared(context).addActivityListener(this.listener);
        this.display(context);
    }

    @CallSuper
    @MainThread
    protected void onDisplayFinished(@NonNull Context context) {
        InAppActivityMonitor.shared(context).removeActivityListener(this.listener);
    }

    @NonNull
    protected BannerView onCreateView(@NonNull Activity activity, @NonNull ViewGroup viewGroup) {
        return new BannerView((Context)activity, this.displayContent, this.getAssets());
    }

    protected void onViewCreated(@NonNull BannerView view, @NonNull Activity activity, @NonNull ViewGroup viewGroup) {
        if (this.getLastActivity() != activity) {
            if ("bottom".equals(this.displayContent.getPlacement())) {
                view.setAnimations(R.animator.ua_iam_slide_in_bottom, R.animator.ua_iam_slide_out_bottom);
            } else {
                view.setAnimations(R.animator.ua_iam_slide_in_top, R.animator.ua_iam_slide_out_top);
            }
        }
        view.setListener(new BannerView.Listener(){

            @Override
            public void onButtonClicked(@NonNull BannerView view, @NonNull ButtonInfo buttonInfo) {
                InAppActionUtils.runActions(buttonInfo);
                BannerAdapter.this.displayHandler.finished(ResolutionInfo.buttonPressed(buttonInfo), view.getTimer().getRunTime());
                BannerAdapter.this.onDisplayFinished(view.getContext());
            }

            @Override
            public void onBannerClicked(@NonNull BannerView view) {
                if (!BannerAdapter.this.displayContent.getActions().isEmpty()) {
                    InAppActionUtils.runActions(BannerAdapter.this.displayContent.getActions());
                    BannerAdapter.this.displayHandler.finished(ResolutionInfo.messageClicked(), view.getTimer().getRunTime());
                }
                BannerAdapter.this.onDisplayFinished(view.getContext());
            }

            @Override
            public void onTimedOut(@NonNull BannerView view) {
                BannerAdapter.this.displayHandler.finished(ResolutionInfo.timedOut(), view.getTimer().getRunTime());
                BannerAdapter.this.onDisplayFinished(view.getContext());
            }

            @Override
            public void onUserDismissed(@NonNull BannerView view) {
                BannerAdapter.this.displayHandler.finished(ResolutionInfo.dismissed(), view.getTimer().getRunTime());
                BannerAdapter.this.onDisplayFinished(view.getContext());
            }
        });
    }

    @Nullable
    protected ViewGroup getContainerView(@NonNull Activity activity) {
        int containerId = this.getContainerId(activity);
        View view = null;
        if (containerId != 0) {
            view = activity.findViewById(containerId);
        }
        if (view == null) {
            view = activity.findViewById(0x1020002);
        }
        if (view instanceof ViewGroup) {
            return (ViewGroup)view;
        }
        return null;
    }

    private void display(@NonNull Context context) {
        List<Activity> activityList = InAppActivityMonitor.shared(context).getResumedActivities(this.activityPredicate);
        if (activityList.isEmpty()) {
            return;
        }
        Activity activity = activityList.get(0);
        ViewGroup container = this.getContainerView(activity);
        if (container == null) {
            return;
        }
        BannerView view = this.onCreateView(activity, container);
        this.onViewCreated(view, activity, container);
        if (view.getParent() == null) {
            if (container.getId() == 0x1020002) {
                view.setZ(InAppViewUtils.getLargestChildZValue(container) + 1.0f);
                container.addView((View)view, 0);
            } else {
                container.addView((View)view);
            }
        }
        this.lastActivity = new WeakReference<Activity>(activity);
        this.currentView = new WeakReference<BannerView>(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getContainerId(@NonNull Activity activity) {
        Map<Class, Integer> map = cachedContainerIds;
        synchronized (map) {
            Integer cachedId = cachedContainerIds.get(activity.getClass());
            if (cachedId != null) {
                return cachedId;
            }
            int containerId = 0;
            ActivityInfo info = ManifestUtils.getActivityInfo(activity.getClass());
            if (info != null && info.metaData != null) {
                containerId = info.metaData.getInt(BANNER_CONTAINER_ID, containerId);
            }
            cachedContainerIds.put(activity.getClass(), containerId);
            return containerId;
        }
    }

    @MainThread
    private void onActivityResumed(@NonNull Activity activity) {
        BannerView currentView = this.getCurrentView();
        if (currentView == null || !ViewCompat.isAttachedToWindow((View)currentView)) {
            this.display((Context)activity);
        } else if (activity == this.getLastActivity()) {
            currentView.onResume();
        }
    }

    @MainThread
    private void onActivityStopped(@NonNull Activity activity) {
        if (activity != this.getLastActivity()) {
            return;
        }
        BannerView view = this.getCurrentView();
        if (view != null) {
            this.currentView = null;
            this.lastActivity = null;
            view.dismiss(false);
            this.display(activity.getApplicationContext());
        }
    }

    @MainThread
    private void onActivityPaused(@NonNull Activity activity) {
        if (activity != this.getLastActivity()) {
            return;
        }
        BannerView currentView = this.getCurrentView();
        if (currentView != null) {
            currentView.onPause();
        }
    }

    @MainThread
    @Nullable
    private BannerView getCurrentView() {
        if (this.currentView == null) {
            return null;
        }
        return (BannerView)this.currentView.get();
    }

    @MainThread
    @Nullable
    private Activity getLastActivity() {
        if (this.lastActivity == null) {
            return null;
        }
        return (Activity)this.lastActivity.get();
    }
}

