/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.banner;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.view.ViewCompat;
import androidx.customview.widget.ViewDragHelper;

public class BannerDismissLayout
extends FrameLayout {
    private static final float IDLE_MIN_DRAG_PERCENT = 0.4f;
    private static final float FLING_MIN_DRAG_PERCENT = 0.1f;
    private static final int DEFAULT_OVER_DRAG_DP = 24;
    private float overDragAmount;
    private String placement = "bottom";
    private ViewDragHelper dragHelper;
    private float minFlingVelocity;
    private Listener listener;

    public BannerDismissLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BannerDismissLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    @RequiresApi(value=21)
    public BannerDismissLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle, int defResStyle) {
        super(context, attrs, defStyle, defResStyle);
        this.init(context);
    }

    private void init(@NonNull Context context) {
        if (this.isInEditMode()) {
            return;
        }
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)new ViewDragCallback());
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        this.minFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.overDragAmount = TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void setMinFlingVelocity(float minFlingVelocity) {
        this.minFlingVelocity = minFlingVelocity;
    }

    public float getMinFlingVelocity() {
        return this.minFlingVelocity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(@Nullable Listener listener) {
        BannerDismissLayout bannerDismissLayout = this;
        synchronized (bannerDismissLayout) {
            this.listener = listener;
        }
    }

    @Keep
    public float getYFraction() {
        int height = this.getHeight();
        if (height == 0) {
            return 0.0f;
        }
        return this.getTranslationY() / (float)height;
    }

    @Keep
    public void setYFraction(final float yFraction) {
        if (this.getVisibility() == 0 && this.getHeight() == 0) {
            ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    BannerDismissLayout.this.setYFraction(yFraction);
                    BannerDismissLayout.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener(preDrawListener);
        } else {
            this.setTranslationY(yFraction * (float)this.getHeight());
        }
    }

    @Keep
    public float getXFraction() {
        int width = this.getWidth();
        if (width == 0) {
            return 0.0f;
        }
        return this.getTranslationX() / (float)width;
    }

    @Keep
    public void setXFraction(final float xFraction) {
        if (this.getVisibility() == 0 && this.getHeight() == 0) {
            ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    BannerDismissLayout.this.setXFraction(xFraction);
                    BannerDismissLayout.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    return true;
                }
            };
            this.getViewTreeObserver().addOnPreDrawListener(preDrawListener);
        } else {
            this.setTranslationX(xFraction * (float)this.getWidth());
        }
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.dragHelper != null && this.dragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public boolean onInterceptTouchEvent(@NonNull MotionEvent event) {
        View child;
        if (this.dragHelper.shouldInterceptTouchEvent(event) || super.onInterceptTouchEvent(event)) {
            return true;
        }
        if (this.dragHelper.getViewDragState() == 0 && event.getActionMasked() == 2 && this.dragHelper.checkTouchSlop(2) && (child = this.dragHelper.findTopChildUnder((int)event.getX(), (int)event.getY())) != null && !child.canScrollVertically(this.dragHelper.getTouchSlop())) {
            this.dragHelper.captureChildView(child, event.getPointerId(0));
            return this.dragHelper.getViewDragState() == 1;
        }
        return false;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NonNull MotionEvent event) {
        View child;
        this.dragHelper.processTouchEvent(event);
        if (this.dragHelper.getCapturedView() == null && event.getActionMasked() == 2 && this.dragHelper.checkTouchSlop(2) && (child = this.dragHelper.findTopChildUnder((int)event.getX(), (int)event.getY())) != null && !child.canScrollVertically(this.dragHelper.getTouchSlop())) {
            this.dragHelper.captureChildView(child, event.getPointerId(0));
        }
        return this.dragHelper.getCapturedView() != null;
    }

    public void setPlacement(@NonNull String placement) {
        this.placement = placement;
    }

    private class ViewDragCallback
    extends ViewDragHelper.Callback {
        private int startTop;
        private int startLeft;
        private float dragPercent = 0.0f;
        private View capturedView;
        private boolean isDismissed = false;

        private ViewDragCallback() {
        }

        public boolean tryCaptureView(@NonNull View view, int i) {
            return this.capturedView == null;
        }

        public int clampViewPositionHorizontal(@NonNull View child, int left, int dx) {
            return child.getLeft();
        }

        public int clampViewPositionVertical(@NonNull View child, int top, int dy) {
            switch (BannerDismissLayout.this.placement) {
                case "top": {
                    return Math.round(Math.min((float)top, (float)this.startTop + BannerDismissLayout.this.overDragAmount));
                }
            }
            return Math.round(Math.max((float)top, (float)this.startTop - BannerDismissLayout.this.overDragAmount));
        }

        public void onViewCaptured(@NonNull View view, int activePointerId) {
            this.capturedView = view;
            this.startTop = view.getTop();
            this.startLeft = view.getLeft();
            this.dragPercent = 0.0f;
            this.isDismissed = false;
        }

        @SuppressLint(value={"NewApi"})
        public void onViewPositionChanged(@NonNull View view, int left, int top, int dx, int dy) {
            int range = BannerDismissLayout.this.getHeight();
            int moved = Math.abs(top - this.startTop);
            if (range > 0) {
                this.dragPercent = (float)moved / (float)range;
            }
            BannerDismissLayout.this.invalidate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onViewDragStateChanged(int state) {
            if (this.capturedView == null) {
                return;
            }
            ViewDragCallback viewDragCallback = this;
            synchronized (viewDragCallback) {
                if (BannerDismissLayout.this.listener != null) {
                    BannerDismissLayout.this.listener.onDragStateChanged(this.capturedView, state);
                }
                if (state == 0) {
                    if (this.isDismissed) {
                        if (BannerDismissLayout.this.listener != null) {
                            BannerDismissLayout.this.listener.onDismissed(this.capturedView);
                        }
                        BannerDismissLayout.this.removeView(this.capturedView);
                    }
                    this.capturedView = null;
                }
            }
        }

        public void onViewReleased(@NonNull View view, float xv, float yv) {
            float absYv = Math.abs(yv);
            if ("top".equals(BannerDismissLayout.this.placement) ? this.startTop >= view.getTop() : this.startTop <= view.getTop()) {
                boolean bl = this.isDismissed = this.dragPercent >= 0.4f || absYv > BannerDismissLayout.this.minFlingVelocity || this.dragPercent > 0.1f;
            }
            if (this.isDismissed) {
                int top = "top".equals(BannerDismissLayout.this.placement) ? -view.getHeight() : BannerDismissLayout.this.getHeight() + view.getHeight();
                BannerDismissLayout.this.dragHelper.settleCapturedViewAt(this.startLeft, top);
            } else {
                BannerDismissLayout.this.dragHelper.settleCapturedViewAt(this.startLeft, this.startTop);
            }
            BannerDismissLayout.this.invalidate();
        }
    }

    public static interface Listener {
        public void onDismissed(@NonNull View var1);

        public void onDragStateChanged(@NonNull View var1, int var2);
    }
}

