/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.banner;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.DisplayContent;
import com.urbanairship.iam.MediaInfo;
import com.urbanairship.iam.TextInfo;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.Checks;
import com.urbanairship.util.ColorUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BannerDisplayContent
implements DisplayContent {
    @NonNull
    public static final String PLACEMENT_TOP = "top";
    @NonNull
    public static final String PLACEMENT_BOTTOM = "bottom";
    @NonNull
    public static final String TEMPLATE_LEFT_MEDIA = "media_left";
    @NonNull
    public static final String TEMPLATE_RIGHT_MEDIA = "media_right";
    public static final long DEFAULT_DURATION_MS = 15000L;
    public static final int MAX_BUTTONS = 2;
    private static final String ACTIONS_KEY = "actions";
    private final TextInfo heading;
    private final TextInfo body;
    private final MediaInfo media;
    private final List<ButtonInfo> buttons;
    private final String buttonLayout;
    private final String placement;
    private final String template;
    private final long duration;
    private final int backgroundColor;
    private final int dismissButtonColor;
    private final float borderRadius;
    private final Map<String, JsonValue> actions;

    private BannerDisplayContent(@NonNull Builder builder) {
        this.heading = builder.heading;
        this.body = builder.body;
        this.media = builder.media;
        this.buttonLayout = builder.buttonLayout;
        this.buttons = builder.buttons;
        this.placement = builder.placement;
        this.template = builder.template;
        this.duration = builder.duration;
        this.backgroundColor = builder.backgroundColor;
        this.dismissButtonColor = builder.dismissButtonColor;
        this.borderRadius = builder.borderRadius;
        this.actions = builder.actions;
    }

    @NonNull
    public static BannerDisplayContent fromJson(@NonNull JsonValue value) throws JsonException {
        JsonMap content = value.optMap();
        Builder builder = BannerDisplayContent.newBuilder();
        if (content.containsKey("heading")) {
            builder.setHeading(TextInfo.fromJson(content.opt("heading")));
        }
        if (content.containsKey("body")) {
            builder.setBody(TextInfo.fromJson(content.opt("body")));
        }
        if (content.containsKey("media")) {
            builder.setMedia(MediaInfo.fromJson(content.opt("media")));
        }
        if (content.containsKey("buttons")) {
            Object buttonJsonList = content.opt("buttons").getList();
            if (buttonJsonList == null) {
                throw new JsonException("Buttons must be an array of button objects.");
            }
            builder.setButtons(ButtonInfo.fromJson((JsonList)buttonJsonList));
        }
        if (content.containsKey("button_layout")) {
            switch (content.opt("button_layout").optString()) {
                case "stacked": {
                    builder.setButtonLayout("stacked");
                    break;
                }
                case "joined": {
                    builder.setButtonLayout("joined");
                    break;
                }
                case "separate": {
                    builder.setButtonLayout("separate");
                    break;
                }
                default: {
                    throw new JsonException("Unexpected button layout: " + content.opt("button_layout"));
                }
            }
        }
        if (content.containsKey("placement")) {
            switch (content.opt("placement").optString()) {
                case "bottom": {
                    builder.setPlacement(PLACEMENT_BOTTOM);
                    break;
                }
                case "top": {
                    builder.setPlacement(PLACEMENT_TOP);
                    break;
                }
                default: {
                    throw new JsonException("Unexpected placement: " + content.opt("placement"));
                }
            }
        }
        if (content.containsKey("template")) {
            switch (content.opt("template").optString()) {
                case "media_left": {
                    builder.setTemplate(TEMPLATE_LEFT_MEDIA);
                    break;
                }
                case "media_right": {
                    builder.setTemplate(TEMPLATE_RIGHT_MEDIA);
                    break;
                }
                default: {
                    throw new JsonException("Unexpected template: " + content.opt("template"));
                }
            }
        }
        if (content.containsKey("duration")) {
            long duration = content.opt("duration").getLong(0L);
            if (duration == 0L) {
                throw new JsonException("Invalid duration: " + content.opt("duration"));
            }
            builder.setDuration(duration, TimeUnit.SECONDS);
        }
        if (content.containsKey("background_color")) {
            try {
                builder.setBackgroundColor(Color.parseColor((String)content.opt("background_color").optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid background color: " + content.opt("background_color"), (Throwable)e);
            }
        }
        if (content.containsKey("dismiss_button_color")) {
            try {
                builder.setDismissButtonColor(Color.parseColor((String)content.opt("dismiss_button_color").optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid dismiss button color: " + content.opt("dismiss_button_color"), (Throwable)e);
            }
        }
        if (content.containsKey("border_radius")) {
            if (!content.opt("border_radius").isNumber()) {
                throw new JsonException("Border radius must be a number " + content.opt("border_radius"));
            }
            builder.setBorderRadius(content.opt("border_radius").getFloat(0.0f));
        }
        if (content.containsKey(ACTIONS_KEY)) {
            JsonMap jsonMap = content.opt(ACTIONS_KEY).getMap();
            if (jsonMap == null) {
                throw new JsonException("Actions must be a JSON object: " + content.opt(ACTIONS_KEY));
            }
            builder.setActions(jsonMap.getMap());
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid banner JSON: " + content, (Throwable)e);
        }
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put("heading", (JsonSerializable)this.heading).put("body", (JsonSerializable)this.body).put("media", (JsonSerializable)this.media).put("buttons", (JsonSerializable)JsonValue.wrapOpt(this.buttons)).put("button_layout", this.buttonLayout).put("placement", this.placement).put("template", this.template).put("duration", TimeUnit.MILLISECONDS.toSeconds(this.duration)).put("background_color", ColorUtils.convertToString((int)this.backgroundColor)).put("dismiss_button_color", ColorUtils.convertToString((int)this.dismissButtonColor)).put("border_radius", (double)this.borderRadius).put(ACTIONS_KEY, (JsonSerializable)JsonValue.wrapOpt(this.actions)).build().toJsonValue();
    }

    @Nullable
    public TextInfo getHeading() {
        return this.heading;
    }

    @Nullable
    public TextInfo getBody() {
        return this.body;
    }

    @Nullable
    public MediaInfo getMedia() {
        return this.media;
    }

    @NonNull
    public List<ButtonInfo> getButtons() {
        return this.buttons;
    }

    @NonNull
    public String getButtonLayout() {
        return this.buttonLayout;
    }

    @NonNull
    public String getPlacement() {
        return this.placement;
    }

    @NonNull
    public String getTemplate() {
        return this.template;
    }

    public long getDuration() {
        return this.duration;
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @ColorInt
    public int getDismissButtonColor() {
        return this.dismissButtonColor;
    }

    public float getBorderRadius() {
        return this.borderRadius;
    }

    @NonNull
    public Map<String, JsonValue> getActions() {
        return this.actions;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BannerDisplayContent that = (BannerDisplayContent)o;
        if (this.duration != that.duration) {
            return false;
        }
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        if (this.dismissButtonColor != that.dismissButtonColor) {
            return false;
        }
        if (Float.compare(that.borderRadius, this.borderRadius) != 0) {
            return false;
        }
        if (this.heading != null ? !this.heading.equals(that.heading) : that.heading != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.media != null ? !this.media.equals(that.media) : that.media != null) {
            return false;
        }
        if (this.buttons != null ? !this.buttons.equals(that.buttons) : that.buttons != null) {
            return false;
        }
        if (this.buttonLayout != null ? !this.buttonLayout.equals(that.buttonLayout) : that.buttonLayout != null) {
            return false;
        }
        if (this.placement != null ? !this.placement.equals(that.placement) : that.placement != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        return this.actions != null ? this.actions.equals(that.actions) : that.actions == null;
    }

    public int hashCode() {
        int result = this.heading != null ? this.heading.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.media != null ? this.media.hashCode() : 0);
        result = 31 * result + (this.buttons != null ? this.buttons.hashCode() : 0);
        result = 31 * result + (this.buttonLayout != null ? this.buttonLayout.hashCode() : 0);
        result = 31 * result + (this.placement != null ? this.placement.hashCode() : 0);
        result = 31 * result + (this.template != null ? this.template.hashCode() : 0);
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + this.backgroundColor;
        result = 31 * result + this.dismissButtonColor;
        result = 31 * result + (this.borderRadius != 0.0f ? Float.floatToIntBits(this.borderRadius) : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return this.toJsonValue().toString();
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public static Builder newBuilder(@NonNull BannerDisplayContent displayContent) {
        return new Builder(displayContent);
    }

    public static class Builder {
        private TextInfo heading;
        private TextInfo body;
        private MediaInfo media;
        private List<ButtonInfo> buttons = new ArrayList<ButtonInfo>();
        private String buttonLayout = "separate";
        private String placement = "bottom";
        private String template = "media_left";
        private long duration = 15000L;
        private int backgroundColor = -1;
        private int dismissButtonColor = -16777216;
        private float borderRadius = 0.0f;
        private final Map<String, JsonValue> actions = new HashMap<String, JsonValue>();

        private Builder() {
        }

        private Builder(@NonNull BannerDisplayContent displayContent) {
            this.heading = displayContent.heading;
            this.body = displayContent.body;
            this.media = displayContent.media;
            this.buttonLayout = displayContent.buttonLayout;
            this.buttons = displayContent.buttons;
            this.placement = displayContent.placement;
            this.template = displayContent.template;
            this.duration = displayContent.duration;
            this.backgroundColor = displayContent.backgroundColor;
            this.dismissButtonColor = displayContent.dismissButtonColor;
            this.borderRadius = displayContent.borderRadius;
            this.actions.putAll(displayContent.actions);
        }

        @NonNull
        public Builder setHeading(@Nullable TextInfo heading) {
            this.heading = heading;
            return this;
        }

        @NonNull
        public Builder setBody(@Nullable TextInfo body) {
            this.body = body;
            return this;
        }

        @NonNull
        public Builder addButton(@NonNull ButtonInfo buttonInfo) {
            this.buttons.add(buttonInfo);
            return this;
        }

        @NonNull
        public Builder setButtons(@Nullable @Size(max=2L) List<ButtonInfo> buttons) {
            this.buttons.clear();
            if (buttons != null) {
                this.buttons.addAll(buttons);
            }
            return this;
        }

        @NonNull
        public Builder setMedia(@Nullable MediaInfo media) {
            this.media = media;
            return this;
        }

        @NonNull
        public Builder setButtonLayout(@NonNull String buttonLayout) {
            this.buttonLayout = buttonLayout;
            return this;
        }

        @NonNull
        public Builder setPlacement(@NonNull String placement) {
            this.placement = placement;
            return this;
        }

        @NonNull
        public Builder setTemplate(@NonNull String template) {
            this.template = template;
            return this;
        }

        @NonNull
        public Builder setBackgroundColor(@ColorInt int color) {
            this.backgroundColor = color;
            return this;
        }

        @NonNull
        public Builder setDismissButtonColor(@ColorInt int color) {
            this.dismissButtonColor = color;
            return this;
        }

        @NonNull
        public Builder setBorderRadius(@FloatRange(from=0.0) float borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        @NonNull
        public Builder setDuration(@IntRange(from=0L) long duration, @NonNull TimeUnit timeUnit) {
            this.duration = timeUnit.toMillis(duration);
            return this;
        }

        @NonNull
        public Builder setActions(@Nullable Map<String, JsonValue> actions) {
            this.actions.clear();
            if (actions != null) {
                this.actions.putAll(actions);
            }
            return this;
        }

        @NonNull
        public Builder addAction(@NonNull String actionName, @NonNull JsonValue actionValue) {
            this.actions.put(actionName, actionValue);
            return this;
        }

        @NonNull
        public BannerDisplayContent build() {
            Checks.checkArgument((this.borderRadius >= 0.0f ? 1 : 0) != 0, (String)"Border radius must be >= 0");
            Checks.checkArgument((this.heading != null || this.body != null ? 1 : 0) != 0, (String)"Either the body or heading must be defined.");
            Checks.checkArgument((this.buttons.size() <= 2 ? 1 : 0) != 0, (String)"Banner allows a max of 2 buttons");
            Checks.checkArgument((this.media == null || this.media.getType().equals("image") ? 1 : 0) != 0, (String)"Banner only supports image media");
            return new BannerDisplayContent(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Template {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Placement {
    }
}

