/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.banner;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.AnimatorRes;
import androidx.annotation.CallSuper;
import androidx.annotation.LayoutRes;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.ColorUtils;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.android.layout.util.Timer;
import com.urbanairship.automation.R;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.assets.Assets;
import com.urbanairship.iam.banner.BannerDismissLayout;
import com.urbanairship.iam.banner.BannerDisplayContent;
import com.urbanairship.iam.view.BackgroundDrawableBuilder;
import com.urbanairship.iam.view.BorderRadius;
import com.urbanairship.iam.view.InAppButtonLayout;
import com.urbanairship.iam.view.InAppViewUtils;
import com.urbanairship.iam.view.MediaView;

public class BannerView
extends FrameLayout
implements InAppButtonLayout.ButtonClickListener,
View.OnClickListener,
BannerDismissLayout.Listener {
    private static final float PRESSED_ALPHA_PERCENT = 0.2f;
    @Nullable
    private final Assets assets;
    @NonNull
    private final BannerDisplayContent displayContent;
    @NonNull
    private final Timer timer;
    @AnimatorRes
    private int animationIn;
    @AnimatorRes
    private int animationOut;
    private boolean isDismissed = false;
    private boolean isResumed = false;
    private boolean applyLegacyWindowInsetFix = false;
    @Nullable
    private View subView;
    @Nullable
    private Listener listener;

    public BannerView(@NonNull Context context, @NonNull BannerDisplayContent displayContent, @Nullable Assets assets) {
        super(context);
        this.displayContent = displayContent;
        this.assets = assets;
        long duration = displayContent.getDuration();
        this.timer = new Timer(duration){

            protected void onFinish() {
                BannerView.this.dismiss(true);
                Listener listener = BannerView.this.listener;
                if (listener != null) {
                    listener.onTimedOut(BannerView.this);
                }
            }
        };
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                for (int i = 0; i < BannerView.this.getChildCount(); ++i) {
                    ViewCompat.dispatchApplyWindowInsets((View)BannerView.this.getChildAt(i), (WindowInsetsCompat)new WindowInsetsCompat(insets));
                }
                return insets;
            }
        });
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewCompat.requestApplyInsets((View)this);
    }

    @NonNull
    @MainThread
    protected View onCreateView(@NonNull LayoutInflater inflater, @NonNull ViewGroup container) {
        BannerDismissLayout view = (BannerDismissLayout)inflater.inflate(this.getLayout(), container, false);
        view.setPlacement(this.displayContent.getPlacement());
        view.setListener(this);
        ViewStub bannerContent = (ViewStub)view.findViewById(R.id.banner_content);
        bannerContent.setLayoutResource(this.getContentLayout());
        bannerContent.inflate();
        LinearLayout bannerView = (LinearLayout)view.findViewById(R.id.banner);
        ViewCompat.setBackground((View)bannerView, (Drawable)this.createBannerBackground());
        if (this.displayContent.getBorderRadius() > 0.0f) {
            int borderRadiusFlag = "top".equals(this.displayContent.getPlacement()) ? 12 : 3;
            BorderRadius.applyBorderRadiusPadding((View)bannerView, this.displayContent.getBorderRadius(), borderRadiusFlag);
        }
        if (!this.displayContent.getActions().isEmpty()) {
            bannerView.setClickable(true);
            bannerView.setOnClickListener((View.OnClickListener)this);
        }
        TextView heading = (TextView)view.findViewById(R.id.heading);
        if (this.displayContent.getHeading() != null) {
            InAppViewUtils.applyTextInfo(heading, this.displayContent.getHeading());
        } else {
            heading.setVisibility(8);
        }
        TextView body = (TextView)view.findViewById(R.id.body);
        if (this.displayContent.getBody() != null) {
            InAppViewUtils.applyTextInfo(body, this.displayContent.getBody());
        } else {
            body.setVisibility(8);
        }
        MediaView mediaView = (MediaView)view.findViewById(R.id.media);
        if (this.displayContent.getMedia() != null) {
            InAppViewUtils.loadMediaInfo(mediaView, this.displayContent.getMedia(), this.assets);
        } else {
            mediaView.setVisibility(8);
        }
        InAppButtonLayout buttonLayout = (InAppButtonLayout)view.findViewById(R.id.buttons);
        if (this.displayContent.getButtons().isEmpty()) {
            buttonLayout.setVisibility(8);
        } else {
            buttonLayout.setButtons(this.displayContent.getButtonLayout(), this.displayContent.getButtons());
            buttonLayout.setButtonClickListener(this);
        }
        View bannerPull = view.findViewById(R.id.banner_pull);
        Drawable drawable = DrawableCompat.wrap((Drawable)bannerPull.getBackground()).mutate();
        DrawableCompat.setTint((Drawable)drawable, (int)this.displayContent.getDismissButtonColor());
        ViewCompat.setBackground((View)bannerPull, (Drawable)drawable);
        return view;
    }

    @MainThread
    @CallSuper
    protected void onResume() {
        this.isResumed = true;
        if (!this.isDismissed) {
            this.getTimer().start();
        }
    }

    @MainThread
    @CallSuper
    protected void onPause() {
        this.isResumed = false;
        this.getTimer().stop();
    }

    @MainThread
    protected void dismiss(boolean animate) {
        this.isDismissed = true;
        this.getTimer().stop();
        if (animate && this.subView != null && this.animationOut != 0) {
            this.clearAnimation();
            Animator animator2 = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)this.animationOut);
            animator2.setTarget((Object)this.subView);
            animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    BannerView.this.removeSelf();
                }
            });
            animator2.start();
        } else {
            this.removeSelf();
        }
    }

    @MainThread
    private void removeSelf() {
        if (this.getParent() instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)this.getParent();
            parent.removeView((View)this);
            this.subView = null;
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (visibility == 0 && !this.isDismissed && this.subView == null) {
            this.subView = this.onCreateView(LayoutInflater.from((Context)this.getContext()), (ViewGroup)this);
            if (this.applyLegacyWindowInsetFix) {
                this.applyLegacyWindowInsetFix(this.subView);
            }
            this.addView(this.subView);
            if (this.animationIn != 0) {
                Animator animator2 = AnimatorInflater.loadAnimator((Context)this.getContext(), (int)this.animationIn);
                animator2.setTarget((Object)this.subView);
                animator2.start();
            }
            this.onResume();
        }
    }

    public void setAnimations(@AnimatorRes int in, @AnimatorRes int out) {
        this.animationIn = in;
        this.animationOut = out;
    }

    @Override
    public void onButtonClicked(@NonNull View view, @NonNull ButtonInfo buttonInfo) {
        Listener listener = this.listener;
        if (listener != null) {
            listener.onButtonClicked(this, buttonInfo);
        }
        this.dismiss(true);
    }

    @Override
    public void onDismissed(@NonNull View view) {
        Listener listener = this.listener;
        if (listener != null) {
            listener.onUserDismissed(this);
        }
        this.dismiss(false);
    }

    @Override
    public void onDragStateChanged(@NonNull View view, int state) {
        switch (state) {
            case 1: {
                this.getTimer().stop();
                break;
            }
            case 0: {
                if (!this.isResumed) break;
                this.getTimer().start();
            }
        }
    }

    public void onClick(@NonNull View view) {
        Listener listener = this.listener;
        if (listener != null) {
            listener.onBannerClicked(this);
        }
        this.dismiss(true);
    }

    @NonNull
    protected Timer getTimer() {
        return this.timer;
    }

    @NonNull
    protected BannerDisplayContent getDisplayContent() {
        return this.displayContent;
    }

    @LayoutRes
    private int getLayout() {
        switch (this.displayContent.getPlacement()) {
            case "top": {
                return R.layout.ua_iam_banner_top;
            }
        }
        return R.layout.ua_iam_banner_bottom;
    }

    @NonNull
    private Drawable createBannerBackground() {
        int pressedColor = ColorUtils.setAlphaComponent((int)this.displayContent.getDismissButtonColor(), (int)Math.round((float)Color.alpha((int)this.displayContent.getDismissButtonColor()) * 0.2f));
        int borderRadiusFlag = "top".equals(this.displayContent.getPlacement()) ? 12 : 3;
        return BackgroundDrawableBuilder.newBuilder(this.getContext()).setBackgroundColor(this.displayContent.getBackgroundColor()).setPressedColor(pressedColor).setBorderRadius(this.displayContent.getBorderRadius(), borderRadiusFlag).build();
    }

    @LayoutRes
    private int getContentLayout() {
        switch (this.displayContent.getTemplate()) {
            case "media_right": {
                return R.layout.ua_iam_banner_content_right_media;
            }
        }
        return R.layout.ua_iam_banner_content_left_media;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(api=19)
    public void applyLegacyWindowInsetFix() {
        this.applyLegacyWindowInsetFix = true;
        if (this.subView != null) {
            this.applyLegacyWindowInsetFix(this.subView);
        }
    }

    private void applyLegacyWindowInsetFix(@NonNull View View2) {
        int resourceId;
        int resourceId2;
        this.subView.setFitsSystemWindows(false);
        TypedArray a = this.getContext().obtainStyledAttributes(new int[]{16843760, 16843759});
        boolean isNavigationTranslucent = a.getBoolean(0, false);
        boolean isStatusTranslucent = a.getBoolean(1, false);
        a.recycle();
        int top = 0;
        if (isStatusTranslucent && (resourceId2 = this.getResources().getIdentifier("status_bar_height", "dimen", "android")) > 0) {
            top = this.getResources().getDimensionPixelSize(resourceId2);
        }
        int bottom = 0;
        if (isNavigationTranslucent && (resourceId = this.getResources().getIdentifier("navigation_bar_height", "dimen", "android")) > 0) {
            bottom = this.getResources().getDimensionPixelSize(resourceId);
        }
        ViewCompat.setPaddingRelative((View)this.subView, (int)0, (int)top, (int)0, (int)bottom);
    }

    public static interface Listener {
        @MainThread
        public void onButtonClicked(@NonNull BannerView var1, @NonNull ButtonInfo var2);

        @MainThread
        public void onBannerClicked(@NonNull BannerView var1);

        @MainThread
        public void onTimedOut(@NonNull BannerView var1);

        @MainThread
        public void onUserDismissed(@NonNull BannerView var1);
    }
}

