/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.custom;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.iam.DisplayContent;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;

public class CustomDisplayContent
implements DisplayContent {
    private static final String CUSTOM_KEY = "custom";
    private final JsonValue value;

    public CustomDisplayContent(@NonNull JsonValue value) {
        this.value = value;
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put(CUSTOM_KEY, (JsonSerializable)this.value).build().toJsonValue();
    }

    @NonNull
    public static CustomDisplayContent fromJson(@NonNull JsonValue value) throws JsonException {
        if (!value.isJsonMap()) {
            throw new JsonException("Invalid custom display content: " + value);
        }
        return new CustomDisplayContent(value.optMap().opt(CUSTOM_KEY));
    }

    @NonNull
    public JsonValue getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomDisplayContent that = (CustomDisplayContent)o;
        return this.value.equals((Object)that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

