/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.events;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.ObjectsCompat;
import com.urbanairship.analytics.Analytics;
import com.urbanairship.analytics.Event;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.android.layout.reporting.FormInfo;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.android.layout.reporting.PagerData;
import com.urbanairship.experiment.ExperimentResult;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.ResolutionInfo;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.permission.Permission;
import com.urbanairship.permission.PermissionStatus;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InAppReportingEvent {
    @NonNull
    public static final String TYPE_RESOLUTION = "in_app_resolution";
    @NonNull
    public static final String TYPE_DISPLAY = "in_app_display";
    @NonNull
    public static final String TYPE_PAGE_VIEW = "in_app_page_view";
    @NonNull
    public static final String TYPE_PAGE_SWIPE = "in_app_page_swipe";
    @NonNull
    public static final String TYPE_FORM_DISPLAY = "in_app_form_display";
    @NonNull
    public static final String TYPE_FORM_RESULT = "in_app_form_result";
    @NonNull
    public static final String TYPES_PAGER_SUMMARY = "in_app_pager_summary";
    @NonNull
    public static final String TYPES_PAGER_COMPLETED = "in_app_pager_completed";
    @NonNull
    public static final String TYPE_BUTTON_TAP = "in_app_button_tap";
    @NonNull
    public static final String TYPE_PERMISSION_RESULT_EVENT = "in_app_permission_result";
    @NonNull
    public static final String TYPE_PAGER_GESTURE = "in_app_gesture";
    @NonNull
    public static final String TYPE_PAGER_ACTION = "in_app_page_action";
    private static final String PERMISSION_KEY = "permission";
    private static final String STARTING_PERMISSION_STATUS_KEY = "starting_permission_status";
    private static final String ENDING_PERMISSION_STATUS_KEY = "ending_permission_status";
    private static final String FORM_ID = "form_identifier";
    private static final String FORM_TYPE_KEY = "form_type";
    private static final String FORM_RESPONSE_TYPE_KEY = "form_response_type";
    private static final String FORMS = "forms";
    private static final String PAGER_ID = "pager_identifier";
    private static final String PAGE_INDEX = "page_index";
    private static final String PAGE_ID = "page_identifier";
    private static final String PAGER_COUNT = "page_count";
    private static final String PAGER_VIEWED_COUNT = "viewed_count";
    private static final String PAGER_VIEWED_PAGES = "viewed_pages";
    private static final String PAGER_COMPLETED = "completed";
    private static final String PAGER_TO_INDEX = "to_page_index";
    private static final String PAGER_TO_ID = "to_page_identifier";
    private static final String PAGER_FROM_INDEX = "from_page_index";
    private static final String PAGER_FROM_ID = "from_page_identifier";
    private static final String PAGE_VIEW_DISPLAY_TIME = "display_time";
    private static final String PAGER_GESTURE_ID = "gesture_identifier";
    private static final String PAGER_ACTION_ID = "action_identifier";
    private static final String BUTTON_IDENTIFIER = "button_identifier";
    private static final String RESOLUTION = "resolution";
    private static final String RESOLUTION_TYPE = "type";
    private static final String LEGACY_MESSAGE_REPLACED = "replaced";
    private static final String LEGACY_MESSAGE_DIRECT_OPEN = "direct_open";
    private static final String DISPLAY_TIME = "display_time";
    private static final String BUTTON_ID = "button_id";
    private static final String BUTTON_DESCRIPTION = "button_description";
    private static final String REPLACEMENT_ID = "replacement_id";
    private static final String RESOLUTION_CONTROL = "control";
    private static final String ID = "id";
    private static final String CONVERSION_SEND_ID = "conversion_send_id";
    private static final String CONVERSION_METADATA = "conversion_metadata";
    private static final String SOURCE = "source";
    private static final String CONTEXT = "context";
    private static final String LOCALE = "locale";
    private static final String REPORTING_METADATA = "reporting_metadata";
    private static final String REPORTING_CONTEXT = "reporting_context";
    private static final String REPORTING_CONTEXT_FORM = "form";
    private static final String REPORTING_CONTEXT_FORM_ID = "identifier";
    private static final String REPORTING_CONTEXT_FORM_SUBMITTED = "submitted";
    private static final String REPORTING_CONTEXT_FORM_TYPE = "type";
    private static final String REPORTING_CONTEXT_FORM_RESPONSE_TYPE = "response_type";
    private static final String REPORTING_CONTEXT_PAGER = "pager";
    private static final String REPORTING_CONTEXT_PAGER_ID = "identifier";
    private static final String REPORTING_CONTEXT_PAGER_COUNT = "count";
    private static final String REPORTING_CONTEXT_BUTTON = "button";
    private static final String REPORTING_CONTEXT_BUTTON_ID = "identifier";
    private static final String MESSAGE_ID = "message_id";
    private static final String CAMPAIGNS = "campaigns";
    private static final String EXPERIMENTS = "experiments";
    private static final String HOLDOUT_DEVICE = "device";
    private static final String HOLDOUT_DEVICE_CHANNEL_ID = "channel_identifier";
    private static final String HOLDOUT_DEVICE_CONTACT_ID = "contact_identifier";
    private static final String SOURCE_URBAN_AIRSHIP = "urban-airship";
    private static final String SOURCE_APP_DEFINED = "app-defined";
    private final String type;
    private final String scheduleId;
    private final String source;
    private final Map<String, JsonValue> renderedLocale;
    private JsonValue campaigns;
    private JsonValue reportingContext;
    @Nullable
    private ExperimentResult experimentResult;
    private LayoutData layoutState;
    private JsonMap overrides;

    private InAppReportingEvent(@NonNull String type, @NonNull String scheduleId, @NonNull InAppMessage message) {
        this.type = type;
        this.scheduleId = scheduleId;
        this.source = message.getSource();
        this.renderedLocale = message.getRenderedLocale();
    }

    private InAppReportingEvent(@NonNull String type, @NonNull String scheduleId, @NonNull String source) {
        this.type = type;
        this.scheduleId = scheduleId;
        this.source = source;
        this.renderedLocale = null;
    }

    public static InAppReportingEvent display(@NonNull String scheduleId, @NonNull InAppMessage message) {
        return new InAppReportingEvent(TYPE_DISPLAY, scheduleId, message);
    }

    public static InAppReportingEvent interrupted(@NonNull String scheduleId, @NonNull String source) {
        JsonMap resolutionData = InAppReportingEvent.resolutionData(ResolutionInfo.dismissed(), 0L);
        return new InAppReportingEvent(TYPE_RESOLUTION, scheduleId, source).setOverrides(JsonMap.newBuilder().put(RESOLUTION, (JsonSerializable)resolutionData).build());
    }

    public static InAppReportingEvent resolution(@NonNull String scheduleId, @NonNull InAppMessage message, long displayMilliseconds, @NonNull ResolutionInfo resolutionInfo) {
        return new InAppReportingEvent(TYPE_RESOLUTION, scheduleId, message).setOverrides(JsonMap.newBuilder().put(RESOLUTION, (JsonSerializable)InAppReportingEvent.resolutionData(resolutionInfo, displayMilliseconds)).build());
    }

    public static InAppReportingEvent legacyReplaced(@NonNull String scheduleId, @NonNull String newId) {
        JsonMap resolutionInfo = JsonMap.newBuilder().put("type", LEGACY_MESSAGE_REPLACED).put(REPLACEMENT_ID, newId).build();
        return new InAppReportingEvent(TYPE_RESOLUTION, scheduleId, "legacy-push").setOverrides(JsonMap.newBuilder().put(RESOLUTION, (JsonSerializable)resolutionInfo).build());
    }

    public static InAppReportingEvent legacyPushOpened(@NonNull String scheduleId) {
        JsonMap resolutionInfo = JsonMap.newBuilder().put("type", LEGACY_MESSAGE_DIRECT_OPEN).build();
        return new InAppReportingEvent(TYPE_RESOLUTION, scheduleId, "legacy-push").setOverrides(JsonMap.newBuilder().put(RESOLUTION, (JsonSerializable)resolutionInfo).build());
    }

    public static InAppReportingEvent permissionResultEvent(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull Permission permission, @NonNull PermissionStatus before, @NonNull PermissionStatus after) {
        return new InAppReportingEvent(TYPE_PERMISSION_RESULT_EVENT, scheduleId, message).setOverrides(JsonMap.newBuilder().put(PERMISSION_KEY, (JsonSerializable)permission).put(STARTING_PERMISSION_STATUS_KEY, (JsonSerializable)before).put(ENDING_PERMISSION_STATUS_KEY, (JsonSerializable)after).build());
    }

    public static InAppReportingEvent formDisplay(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull FormInfo formInfo) {
        return new InAppReportingEvent(TYPE_FORM_DISPLAY, scheduleId, message).setOverrides(JsonMap.newBuilder().put(FORM_ID, formInfo.getIdentifier()).put(FORM_RESPONSE_TYPE_KEY, formInfo.getFormResponseType()).put(FORM_TYPE_KEY, formInfo.getFormType()).build());
    }

    public static InAppReportingEvent formResult(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull FormData.BaseForm formData) {
        return new InAppReportingEvent(TYPE_FORM_RESULT, scheduleId, message).setOverrides(JsonMap.newBuilder().put(FORMS, (JsonSerializable)formData).build());
    }

    public static InAppReportingEvent buttonTap(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull String buttonId, @Nullable JsonValue reportingMetadata) {
        return new InAppReportingEvent(TYPE_BUTTON_TAP, scheduleId, message).setOverrides(JsonMap.newBuilder().put(BUTTON_IDENTIFIER, buttonId).putOpt(REPORTING_METADATA, (Object)reportingMetadata).build());
    }

    public static InAppReportingEvent pageView(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull PagerData pagerData, int viewCount) {
        return new InAppReportingEvent(TYPE_PAGE_VIEW, scheduleId, message).setOverrides(JsonMap.newBuilder().put(PAGER_COMPLETED, pagerData.isCompleted()).put(PAGER_ID, pagerData.getIdentifier()).put(PAGER_COUNT, pagerData.getCount()).put(PAGE_INDEX, pagerData.getIndex()).put(PAGE_ID, pagerData.getPageId()).put(PAGER_VIEWED_COUNT, viewCount).build());
    }

    public static InAppReportingEvent pageSwipe(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull PagerData pagerData, int toPageIndex, @NonNull String toPageId, int fromPageIndex, @NonNull String fromPageId) {
        return new InAppReportingEvent(TYPE_PAGE_SWIPE, scheduleId, message).setOverrides(JsonMap.newBuilder().put(PAGER_ID, pagerData.getIdentifier()).put(PAGER_TO_INDEX, toPageIndex).put(PAGER_TO_ID, toPageId).put(PAGER_FROM_INDEX, fromPageIndex).put(PAGER_FROM_ID, fromPageId).build());
    }

    public static InAppReportingEvent pagerCompleted(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull PagerData pagerData) {
        return new InAppReportingEvent(TYPES_PAGER_COMPLETED, scheduleId, message).setOverrides(JsonMap.newBuilder().put(PAGER_ID, pagerData.getIdentifier()).put(PAGE_INDEX, pagerData.getIndex()).put(PAGE_ID, pagerData.getPageId()).put(PAGER_COUNT, pagerData.getCount()).build());
    }

    public static InAppReportingEvent pagerSummary(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull PagerData pagerData, @NonNull List<PageViewSummary> pageViews) {
        return new InAppReportingEvent(TYPES_PAGER_SUMMARY, scheduleId, message).setOverrides(JsonMap.newBuilder().put(PAGER_ID, pagerData.getIdentifier()).put(PAGER_COUNT, pagerData.getCount()).put(PAGER_COMPLETED, pagerData.isCompleted()).putOpt(PAGER_VIEWED_PAGES, pageViews).build());
    }

    public static InAppReportingEvent pagerGesture(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull String gestureId, @Nullable JsonValue reportingMetadata) {
        return new InAppReportingEvent(TYPE_PAGER_GESTURE, scheduleId, message).setOverrides(JsonMap.newBuilder().put(PAGER_GESTURE_ID, gestureId).put(REPORTING_METADATA, (JsonSerializable)reportingMetadata).build());
    }

    public static InAppReportingEvent pagerAction(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull String actionId, @Nullable JsonValue reportingMetadata) {
        return new InAppReportingEvent(TYPE_PAGER_ACTION, scheduleId, message).setOverrides(JsonMap.newBuilder().put(PAGER_ACTION_ID, actionId).put(REPORTING_METADATA, (JsonSerializable)reportingMetadata).build());
    }

    public static InAppReportingEvent holdoutGroupControl(@NonNull String scheduleId, @NonNull InAppMessage message, @NonNull ExperimentResult holdoutGroup) {
        JsonMap deviceInfo = JsonMap.newBuilder().put(HOLDOUT_DEVICE_CHANNEL_ID, holdoutGroup.getChannelId()).put(HOLDOUT_DEVICE_CONTACT_ID, holdoutGroup.getContactId()).build();
        JsonMap baseData = JsonMap.newBuilder().put(RESOLUTION, (JsonSerializable)JsonMap.newBuilder().put("type", RESOLUTION_CONTROL).build()).put(HOLDOUT_DEVICE, (JsonSerializable)deviceInfo).build();
        return new InAppReportingEvent(TYPE_RESOLUTION, scheduleId, message).setOverrides(baseData);
    }

    public InAppReportingEvent setCampaigns(@Nullable JsonValue campaigns) {
        this.campaigns = campaigns;
        return this;
    }

    public InAppReportingEvent setLayoutData(@Nullable LayoutData layoutState) {
        this.layoutState = layoutState;
        return this;
    }

    public InAppReportingEvent setReportingContext(@Nullable JsonValue reportingContext) {
        this.reportingContext = reportingContext;
        return this;
    }

    public InAppReportingEvent setExperimentResult(@Nullable ExperimentResult experimentResult) {
        this.experimentResult = experimentResult;
        return this;
    }

    private InAppReportingEvent setOverrides(JsonMap overrides) {
        this.overrides = overrides;
        return this;
    }

    public void record(Analytics analytics) {
        boolean isAppDefined = SOURCE_APP_DEFINED.equals(this.source);
        JsonMap.Builder builder = JsonMap.newBuilder().put(ID, (JsonSerializable)InAppReportingEvent.createEventId(this.scheduleId, this.source, this.campaigns)).put(SOURCE, isAppDefined ? SOURCE_APP_DEFINED : SOURCE_URBAN_AIRSHIP).putOpt(CONVERSION_SEND_ID, (Object)analytics.getConversionSendId()).putOpt(CONVERSION_METADATA, (Object)analytics.getConversionMetadata()).put(CONTEXT, (JsonSerializable)InAppReportingEvent.contextData(this.layoutState, this.reportingContext, this.experimentResult));
        if (this.renderedLocale != null) {
            builder.putOpt(LOCALE, this.renderedLocale);
        }
        if (this.overrides != null) {
            builder.putAll(this.overrides);
        }
        analytics.addEvent((Event)new AnalyticsEvent(this.type, builder.build()));
    }

    private static JsonMap resolutionData(ResolutionInfo resolutionInfo, long displayMilliseconds) {
        displayMilliseconds = displayMilliseconds > 0L ? displayMilliseconds : 0L;
        JsonMap.Builder resolutionDataBuilder = JsonMap.newBuilder().put("type", resolutionInfo.getType()).put("display_time", Event.millisecondsToSecondsString((long)displayMilliseconds));
        if ("button_click".equals(resolutionInfo.getType()) && resolutionInfo.getButtonInfo() != null) {
            String description = resolutionInfo.getButtonInfo().getLabel().getText();
            resolutionDataBuilder.put(BUTTON_ID, resolutionInfo.getButtonInfo().getId()).put(BUTTON_DESCRIPTION, description);
        }
        return resolutionDataBuilder.build();
    }

    private static JsonMap contextData(@Nullable LayoutData layoutState, @Nullable JsonValue reportingContext, @Nullable ExperimentResult experimentResult) {
        JsonMap contextData;
        JsonMap.Builder contextBuilder = JsonMap.newBuilder().put(REPORTING_CONTEXT, (JsonSerializable)reportingContext);
        if (layoutState != null) {
            String buttonId;
            PagerData pagerData;
            FormInfo formInfo = layoutState.getFormInfo();
            if (formInfo != null) {
                boolean isSubmitted = formInfo.getFormSubmitted() != null ? formInfo.getFormSubmitted() : false;
                JsonMap formContext = JsonMap.newBuilder().put("identifier", formInfo.getIdentifier()).put(REPORTING_CONTEXT_FORM_SUBMITTED, isSubmitted).put(REPORTING_CONTEXT_FORM_RESPONSE_TYPE, formInfo.getFormResponseType()).put("type", formInfo.getFormType()).build();
                contextBuilder.put(REPORTING_CONTEXT_FORM, (JsonSerializable)formContext);
            }
            if ((pagerData = layoutState.getPagerData()) != null) {
                JsonMap pagerContext = JsonMap.newBuilder().put("identifier", pagerData.getIdentifier()).put(REPORTING_CONTEXT_PAGER_COUNT, pagerData.getCount()).put(PAGE_INDEX, pagerData.getIndex()).put(PAGE_ID, pagerData.getPageId()).put(PAGER_COMPLETED, pagerData.isCompleted()).build();
                contextBuilder.put(REPORTING_CONTEXT_PAGER, (JsonSerializable)pagerContext);
            }
            if ((buttonId = layoutState.getButtonIdentifier()) != null) {
                JsonMap buttonContext = JsonMap.newBuilder().put("identifier", buttonId).build();
                contextBuilder.put(REPORTING_CONTEXT_BUTTON, (JsonSerializable)buttonContext);
            }
        }
        if (experimentResult != null) {
            JsonValue reportingMetadata = experimentResult.evaluatedExperimentsDataAsJsonValue();
            contextBuilder.put(EXPERIMENTS, (JsonSerializable)reportingMetadata);
        }
        return (contextData = contextBuilder.build()).isEmpty() ? null : contextData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InAppReportingEvent event = (InAppReportingEvent)o;
        return ObjectsCompat.equals((Object)this.type, (Object)event.type) && ObjectsCompat.equals((Object)this.scheduleId, (Object)event.scheduleId) && ObjectsCompat.equals((Object)this.source, (Object)event.source) && ObjectsCompat.equals(this.renderedLocale, event.renderedLocale) && ObjectsCompat.equals((Object)this.campaigns, (Object)event.campaigns) && ObjectsCompat.equals((Object)this.reportingContext, (Object)event.reportingContext) && ObjectsCompat.equals((Object)this.layoutState, (Object)event.layoutState) && ObjectsCompat.equals((Object)this.overrides, (Object)event.overrides);
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.type, this.scheduleId, this.source, this.renderedLocale, this.campaigns, this.reportingContext, this.layoutState, this.overrides});
    }

    @NonNull
    private static JsonValue createEventId(@NonNull String scheduleId, @NonNull String source, @Nullable JsonValue campaigns) {
        switch (source) {
            case "legacy-push": {
                return JsonValue.wrap((String)scheduleId);
            }
            case "remote-data": {
                return JsonMap.newBuilder().put(MESSAGE_ID, scheduleId).put(CAMPAIGNS, (JsonSerializable)campaigns).build().toJsonValue();
            }
            case "app-defined": {
                return JsonMap.newBuilder().put(MESSAGE_ID, scheduleId).build().toJsonValue();
            }
        }
        return JsonValue.NULL;
    }

    private static class AnalyticsEvent
    extends Event {
        private final String type;
        private final JsonMap data;

        private AnalyticsEvent(@NonNull String type, @NonNull JsonMap data) {
            this.type = type;
            this.data = data;
        }

        @NonNull
        public String getType() {
            return this.type;
        }

        @NonNull
        public JsonMap getEventData() {
            return this.data;
        }

        @NonNull
        public String toString() {
            return "AnalyticsEvent{type='" + this.type + '\'' + ", data=" + this.data + '}';
        }
    }

    public static class PageViewSummary
    implements JsonSerializable {
        private final String identifier;
        private final int index;
        private final long durationMs;

        public PageViewSummary(int index, @NonNull String identifier, long durationMs) {
            this.index = index;
            this.identifier = identifier;
            this.durationMs = durationMs;
        }

        @NonNull
        public JsonValue toJsonValue() {
            return JsonMap.newBuilder().put(InAppReportingEvent.PAGE_ID, this.identifier).put(InAppReportingEvent.PAGE_INDEX, this.index).put("display_time", Event.millisecondsToSecondsString((long)this.durationMs)).build().toJsonValue();
        }
    }
}

