/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.fullscreen;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebChromeClient;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.automation.R;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.InAppActionUtils;
import com.urbanairship.iam.InAppMessageActivity;
import com.urbanairship.iam.ResolutionInfo;
import com.urbanairship.iam.fullscreen.FullScreenDisplayContent;
import com.urbanairship.iam.view.InAppButtonLayout;
import com.urbanairship.iam.view.InAppViewUtils;
import com.urbanairship.iam.view.MediaView;
import com.urbanairship.webkit.AirshipWebChromeClient;

public class FullScreenActivity
extends InAppMessageActivity
implements InAppButtonLayout.ButtonClickListener {
    @Nullable
    protected FullScreenDisplayContent displayContent;
    private MediaView mediaView;

    @Override
    protected void onCreateMessage(@Nullable Bundle savedInstanceState) {
        if (this.getMessage() == null) {
            this.finish();
            return;
        }
        this.displayContent = (FullScreenDisplayContent)this.getMessage().getDisplayContent();
        if (this.displayContent == null) {
            this.finish();
            return;
        }
        String template = this.normalizeTemplate(this.displayContent);
        this.setContentView(this.getTemplate(template));
        this.hideActionBar();
        TextView heading = (TextView)this.findViewById(R.id.heading);
        TextView body = (TextView)this.findViewById(R.id.body);
        InAppButtonLayout buttonLayout = (InAppButtonLayout)this.findViewById(R.id.buttons);
        this.mediaView = (MediaView)this.findViewById(R.id.media);
        Button footer = (Button)this.findViewById(R.id.footer);
        ImageButton dismiss = (ImageButton)this.findViewById(R.id.dismiss);
        View contentHolder = this.findViewById(R.id.content_holder);
        if (this.displayContent.getHeading() != null) {
            InAppViewUtils.applyTextInfo(heading, this.displayContent.getHeading());
            if ("center".equals(this.displayContent.getHeading().getAlignment())) {
                this.normalizeHorizontalPadding(heading);
            }
        } else {
            heading.setVisibility(8);
        }
        if (this.displayContent.getBody() != null) {
            InAppViewUtils.applyTextInfo(body, this.displayContent.getBody());
        } else {
            body.setVisibility(8);
        }
        if (this.displayContent.getMedia() != null) {
            this.mediaView.setChromeClient((WebChromeClient)new AirshipWebChromeClient((Activity)this));
            InAppViewUtils.loadMediaInfo(this.mediaView, this.displayContent.getMedia(), this.getMessageAssets());
        } else {
            this.mediaView.setVisibility(8);
        }
        if (!this.displayContent.getButtons().isEmpty()) {
            buttonLayout.setButtons(this.displayContent.getButtonLayout(), this.displayContent.getButtons());
            buttonLayout.setButtonClickListener(this);
        } else {
            buttonLayout.setVisibility(8);
        }
        if (this.displayContent.getFooter() != null) {
            InAppViewUtils.applyButtonInfo(footer, this.displayContent.getFooter(), 0);
            footer.setOnClickListener(new View.OnClickListener(){

                public void onClick(@NonNull View view) {
                    FullScreenActivity.this.onButtonClicked(view, FullScreenActivity.this.displayContent.getFooter());
                }
            });
        } else {
            footer.setVisibility(8);
        }
        Drawable dismissDrawable = DrawableCompat.wrap((Drawable)dismiss.getDrawable()).mutate();
        DrawableCompat.setTint((Drawable)dismissDrawable, (int)this.displayContent.getDismissButtonColor());
        dismiss.setImageDrawable(dismissDrawable);
        dismiss.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (FullScreenActivity.this.getDisplayHandler() != null) {
                    FullScreenActivity.this.getDisplayHandler().finished(ResolutionInfo.dismissed(), FullScreenActivity.this.getDisplayTime());
                }
                FullScreenActivity.this.finish();
            }
        });
        this.getWindow().getDecorView().setBackgroundColor(this.displayContent.getBackgroundColor());
        if (ViewCompat.getFitsSystemWindows((View)contentHolder)) {
            ViewCompat.setOnApplyWindowInsetsListener((View)contentHolder, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

                public WindowInsetsCompat onApplyWindowInsets(@NonNull View v, WindowInsetsCompat insets) {
                    ViewCompat.onApplyWindowInsets((View)v, (WindowInsetsCompat)insets);
                    return insets;
                }
            });
        }
    }

    @Override
    public void onButtonClicked(@NonNull View view, @NonNull ButtonInfo buttonInfo) {
        if (this.getDisplayHandler() == null) {
            return;
        }
        InAppActionUtils.runActions(buttonInfo);
        this.getDisplayHandler().finished(ResolutionInfo.buttonPressed(buttonInfo), this.getDisplayTime());
        this.finish();
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.mediaView.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.mediaView.onPause();
    }

    @LayoutRes
    protected int getTemplate(@NonNull String template) {
        switch (template) {
            case "header_body_media": {
                return R.layout.ua_iam_fullscreen_header_body_media;
            }
            case "header_media_body": {
                return R.layout.ua_iam_fullscreen_header_media_body;
            }
        }
        return R.layout.ua_iam_fullscreen_media_header_body;
    }

    @NonNull
    protected String normalizeTemplate(@NonNull FullScreenDisplayContent displayContent) {
        String template = displayContent.getTemplate();
        if (displayContent.getMedia() == null) {
            return "header_body_media";
        }
        if (template.equals("header_media_body") && displayContent.getHeading() == null && displayContent.getMedia() != null) {
            return "media_header_body";
        }
        return template;
    }

    private void normalizeHorizontalPadding(@NonNull TextView view) {
        int padding = Math.max(ViewCompat.getPaddingEnd((View)view), ViewCompat.getPaddingStart((View)view));
        view.setPadding(padding, view.getPaddingTop(), padding, view.getPaddingBottom());
        view.requestLayout();
    }
}

