/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.html;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.automation.R;
import com.urbanairship.iam.InAppMessageActivity;
import com.urbanairship.iam.ResolutionInfo;
import com.urbanairship.iam.html.HtmlDisplayContent;
import com.urbanairship.iam.html.HtmlWebViewClient;
import com.urbanairship.iam.view.BoundedFrameLayout;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonValue;
import com.urbanairship.webkit.AirshipWebChromeClient;
import com.urbanairship.webkit.AirshipWebView;
import java.lang.ref.WeakReference;

public class HtmlActivity
extends InAppMessageActivity {
    private static final long RETRY_DELAY_MS = 20000L;
    private AirshipWebView webView;
    private Integer error = null;
    private Handler handler;
    private String url;
    private final Runnable delayedLoadRunnable = new Runnable(){

        @Override
        public void run() {
            HtmlActivity.this.load();
        }
    };

    @Override
    protected void onCreateMessage(@Nullable Bundle savedInstanceState) {
        if (this.getMessage() == null) {
            this.finish();
            return;
        }
        HtmlDisplayContent displayContent = (HtmlDisplayContent)this.getMessage().getDisplayContent();
        if (displayContent == null) {
            UALog.e((String)"HtmlActivity - Invalid display type: %s", (Object[])new Object[]{this.getMessage().getDisplayContent()});
            this.finish();
            return;
        }
        float borderRadius = 0.0f;
        if (this.isFullScreen(displayContent)) {
            this.setTheme(R.style.UrbanAirship_InAppHtml_Activity_Fullscreen);
            this.setContentView(R.layout.ua_iam_html_fullscreen);
        } else {
            this.setContentView(R.layout.ua_iam_html);
            borderRadius = displayContent.getBorderRadius();
        }
        final ProgressBar progressBar = (ProgressBar)this.findViewById(R.id.progress);
        ImageButton dismiss = (ImageButton)this.findViewById(R.id.dismiss);
        BoundedFrameLayout content = (BoundedFrameLayout)this.findViewById(R.id.content_holder);
        this.applySizeConstraints(displayContent);
        this.webView = (AirshipWebView)this.findViewById(R.id.web_view);
        this.handler = new Handler(Looper.getMainLooper());
        this.url = displayContent.getUrl();
        if (!UAirship.shared().getUrlAllowList().isAllowed(this.url, 2)) {
            UALog.e((String)"HTML in-app message URL is not allowed. Unable to display message.", (Object[])new Object[0]);
            this.finish();
            return;
        }
        this.webView.setWebViewClient((WebViewClient)new HtmlWebViewClient(this.getMessage()){

            @Override
            public void onMessageDismissed(@NonNull JsonValue argument) {
                try {
                    ResolutionInfo info = ResolutionInfo.fromJson(argument);
                    if (HtmlActivity.this.getDisplayHandler() != null) {
                        HtmlActivity.this.getDisplayHandler().finished(info, HtmlActivity.this.getDisplayTime());
                    }
                    HtmlActivity.this.finish();
                }
                catch (JsonException e) {
                    UALog.e((String)"Unable to parse message resolution JSON", (Object[])new Object[]{e});
                }
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (HtmlActivity.this.error != null) {
                    switch (HtmlActivity.this.error) {
                        case -8: 
                        case -6: 
                        case -1: {
                            HtmlActivity.this.load(20000L);
                            break;
                        }
                        default: {
                            HtmlActivity.this.error = null;
                            HtmlActivity.this.webView.loadData("", "text/html", null);
                            break;
                        }
                    }
                } else {
                    HtmlActivity.this.crossFade((View)HtmlActivity.this.webView, (View)progressBar);
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                if (failingUrl != null && failingUrl.equals(HtmlActivity.this.getIntent().getDataString())) {
                    UALog.e((String)"HtmlActivity - Failed to load page %s with error %s %s", (Object[])new Object[]{failingUrl, errorCode, description});
                    HtmlActivity.this.error = errorCode;
                }
            }
        });
        this.webView.setAlpha(0.0f);
        this.webView.getSettings().setSupportMultipleWindows(true);
        this.webView.setWebChromeClient((WebChromeClient)new AirshipWebChromeClient((Activity)this));
        Drawable dismissDrawable = DrawableCompat.wrap((Drawable)dismiss.getDrawable()).mutate();
        DrawableCompat.setTint((Drawable)dismissDrawable, (int)displayContent.getDismissButtonColor());
        dismiss.setImageDrawable(dismissDrawable);
        dismiss.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (HtmlActivity.this.getDisplayHandler() != null) {
                    HtmlActivity.this.getDisplayHandler().finished(ResolutionInfo.dismissed(), HtmlActivity.this.getDisplayTime());
                }
                HtmlActivity.this.finish();
            }
        });
        int backgroundColor = displayContent.getBackgroundColor();
        content.setBackgroundColor(backgroundColor);
        this.webView.setBackgroundColor(backgroundColor);
        if (Color.alpha((int)backgroundColor) == 255 && borderRadius > 0.0f) {
            content.setClipPathBorderRadius(borderRadius);
        }
    }

    private boolean isFullScreen(HtmlDisplayContent displayContent) {
        if (!displayContent.isFullscreenDisplayAllowed()) {
            return false;
        }
        return this.getResources().getBoolean(R.bool.ua_iam_html_allow_fullscreen_display);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.webView.onResume();
        this.load();
    }

    @Override
    public void onPause() {
        super.onPause();
        this.webView.onPause();
        this.webView.stopLoading();
        this.handler.removeCallbacks(this.delayedLoadRunnable);
    }

    private void crossFade(@Nullable View in, final @Nullable View out) {
        if (in != null) {
            in.animate().alpha(1.0f).setDuration(200L);
        }
        if (out != null) {
            out.animate().alpha(0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    out.setVisibility(8);
                }
            });
        }
    }

    protected void load() {
        this.load(0L);
    }

    protected void load(long delay) {
        if (this.webView == null) {
            return;
        }
        this.webView.stopLoading();
        if (delay > 0L) {
            this.handler.postDelayed(this.delayedLoadRunnable, delay);
            return;
        }
        UALog.i((String)"Loading url: %s", (Object[])new Object[]{this.url});
        this.error = null;
        this.webView.loadUrl(this.url);
    }

    public void applySizeConstraints(@NonNull HtmlDisplayContent displayContent) {
        if (displayContent.getWidth() == 0L && displayContent.getHeight() == 0L) {
            return;
        }
        View view = this.findViewById(R.id.content_holder);
        if (view == null) {
            return;
        }
        final int width = (int)TypedValue.applyDimension((int)1, (float)displayContent.getWidth(), (DisplayMetrics)this.getResources().getDisplayMetrics());
        final int height = (int)TypedValue.applyDimension((int)1, (float)displayContent.getHeight(), (DisplayMetrics)this.getResources().getDisplayMetrics());
        final boolean aspectLock = displayContent.getAspectRatioLock();
        final WeakReference<View> viewWeakReference = new WeakReference<View>(view);
        view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                View view = (View)viewWeakReference.get();
                if (view == null) {
                    return true;
                }
                ViewGroup.LayoutParams params = view.getLayoutParams();
                int parentWidth = view.getMeasuredWidth();
                int parentHeight = view.getMeasuredHeight();
                int normalizedWidth = Math.min(parentWidth, width);
                int normalizedHeight = Math.min(parentHeight, height);
                if (aspectLock && (normalizedWidth != width || normalizedHeight != height)) {
                    float parentAspect = (float)parentWidth / (float)parentHeight;
                    float landingPageAspect = (float)width / (float)height;
                    if (parentAspect > landingPageAspect) {
                        normalizedWidth = (int)((float)width * (float)parentHeight / (float)height);
                    } else {
                        normalizedHeight = (int)((float)height * (float)parentWidth / (float)width);
                    }
                }
                if (normalizedHeight > 0) {
                    params.height = normalizedHeight;
                }
                if (normalizedWidth > 0) {
                    params.width = normalizedWidth;
                }
                view.setLayoutParams(params);
                view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                return true;
            }
        });
    }
}

