/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.html;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.iam.DisplayHandler;
import com.urbanairship.iam.ForegroundDisplayAdapter;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.assets.Assets;
import com.urbanairship.iam.html.HtmlActivity;
import com.urbanairship.iam.html.HtmlDisplayContent;
import com.urbanairship.util.Network;

public class HtmlDisplayAdapter
extends ForegroundDisplayAdapter {
    private final InAppMessage message;
    private final HtmlDisplayContent displayContent;

    protected HtmlDisplayAdapter(@NonNull InAppMessage message, @NonNull HtmlDisplayContent displayContent) {
        this.message = message;
        this.displayContent = displayContent;
    }

    @NonNull
    public static HtmlDisplayAdapter newAdapter(@NonNull InAppMessage message) {
        HtmlDisplayContent displayContent = (HtmlDisplayContent)message.getDisplayContent();
        if (displayContent == null) {
            throw new IllegalArgumentException("Invalid message for adapter: " + message);
        }
        return new HtmlDisplayAdapter(message, displayContent);
    }

    @Override
    public int onPrepare(@NonNull Context context, @NonNull Assets assets) {
        if (!UAirship.shared().getUrlAllowList().isAllowed(this.displayContent.getUrl(), 2)) {
            UALog.e((String)"HTML in-app message URL is not allowed. Unable to display message.", (Object[])new Object[0]);
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isReady(@NonNull Context context) {
        if (!super.isReady(context)) {
            return false;
        }
        return !this.displayContent.getRequireConnectivity() || Network.shared().isConnected(context);
    }

    @Override
    public void onDisplay(@NonNull Context context, @NonNull DisplayHandler displayHandler) {
        Intent intent = new Intent(context, HtmlActivity.class).setFlags(0x10000000).putExtra("display_handler", (Parcelable)displayHandler).putExtra("in_app_message", (Parcelable)this.message);
        context.startActivity(intent);
    }

    @Override
    public void onFinish(@NonNull Context context) {
    }
}

