/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.html;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import com.urbanairship.iam.DisplayContent;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.Checks;
import com.urbanairship.util.ColorUtils;

public class HtmlDisplayContent
implements DisplayContent {
    @NonNull
    public static final String WIDTH_KEY = "width";
    @NonNull
    public static final String HEIGHT_KEY = "height";
    @NonNull
    public static final String ASPECT_LOCK_KEY = "aspect_lock";
    @NonNull
    public static final String REQUIRE_CONNECTIVITY = "require_connectivity";
    private final String url;
    private final int dismissButtonColor;
    private final int backgroundColor;
    private final float borderRadius;
    private final boolean isFullscreenDisplayAllowed;
    private final int width;
    private final int height;
    private final boolean keepAspectRatio;
    private final boolean requireConnectivity;

    private HtmlDisplayContent(@NonNull Builder builder) {
        this.url = builder.url;
        this.dismissButtonColor = builder.dismissButtonColor;
        this.backgroundColor = builder.backgroundColor;
        this.borderRadius = builder.borderRadius;
        this.isFullscreenDisplayAllowed = builder.isFullscreenDisplayAllowed;
        this.width = builder.width;
        this.height = builder.height;
        this.keepAspectRatio = builder.keepAspectRatio;
        this.requireConnectivity = builder.requireConnectivity;
    }

    @NonNull
    public static HtmlDisplayContent fromJson(@NonNull JsonValue value) throws JsonException {
        JsonMap content = value.optMap();
        Builder builder = HtmlDisplayContent.newBuilder();
        if (content.containsKey("dismiss_button_color")) {
            try {
                builder.setDismissButtonColor(Color.parseColor((String)content.opt("dismiss_button_color").optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid dismiss button color: " + content.opt("dismiss_button_color"), (Throwable)e);
            }
        }
        if (content.containsKey("url")) {
            String url = content.opt("url").getString();
            if (url == null) {
                throw new JsonException("Invalid url: " + content.opt("url"));
            }
            builder.setUrl(url);
        }
        if (content.containsKey("background_color")) {
            try {
                builder.setBackgroundColor(Color.parseColor((String)content.opt("background_color").optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid background color: " + content.opt("background_color"), (Throwable)e);
            }
        }
        if (content.containsKey("border_radius")) {
            if (!content.opt("border_radius").isNumber()) {
                throw new JsonException("Border radius must be a number " + content.opt("border_radius"));
            }
            builder.setBorderRadius(content.opt("border_radius").getFloat(0.0f));
        }
        if (content.containsKey("allow_fullscreen_display")) {
            if (!content.opt("allow_fullscreen_display").isBoolean()) {
                throw new JsonException("Allow fullscreen display must be a boolean " + content.opt("allow_fullscreen_display"));
            }
            builder.setAllowFullscreenDisplay(content.opt("allow_fullscreen_display").getBoolean(false));
        }
        if (content.containsKey(REQUIRE_CONNECTIVITY)) {
            if (!content.opt(REQUIRE_CONNECTIVITY).isBoolean()) {
                throw new JsonException("Require connectivity must be a boolean " + content.opt(REQUIRE_CONNECTIVITY));
            }
            builder.setRequireConnectivity(content.opt(REQUIRE_CONNECTIVITY).getBoolean(true));
        }
        if (content.containsKey(WIDTH_KEY) && !content.opt(WIDTH_KEY).isNumber()) {
            throw new JsonException("Width must be a number " + content.opt(WIDTH_KEY));
        }
        if (content.containsKey(HEIGHT_KEY) && !content.opt(HEIGHT_KEY).isNumber()) {
            throw new JsonException("Height must be a number " + content.opt(HEIGHT_KEY));
        }
        if (content.containsKey(ASPECT_LOCK_KEY) && !content.opt(ASPECT_LOCK_KEY).isBoolean()) {
            throw new JsonException("Aspect lock must be a boolean " + content.opt(ASPECT_LOCK_KEY));
        }
        int width = content.opt(WIDTH_KEY).getInt(0);
        int height = content.opt(HEIGHT_KEY).getInt(0);
        boolean aspectLock = content.opt(ASPECT_LOCK_KEY).getBoolean(false);
        builder.setSize(width, height, aspectLock);
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid html message JSON: " + content, (Throwable)e);
        }
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put("dismiss_button_color", ColorUtils.convertToString((int)this.dismissButtonColor)).put("url", this.url).put("background_color", ColorUtils.convertToString((int)this.backgroundColor)).put("border_radius", (double)this.borderRadius).put("allow_fullscreen_display", this.isFullscreenDisplayAllowed).put(WIDTH_KEY, this.width).put(HEIGHT_KEY, this.height).put(ASPECT_LOCK_KEY, this.keepAspectRatio).put(REQUIRE_CONNECTIVITY, this.requireConnectivity).build().toJsonValue();
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    @ColorInt
    public int getDismissButtonColor() {
        return this.dismissButtonColor;
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @NonNull
    public String toString() {
        return this.toJsonValue().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HtmlDisplayContent that = (HtmlDisplayContent)o;
        if (this.dismissButtonColor != that.dismissButtonColor) {
            return false;
        }
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        if (Float.compare(that.borderRadius, this.borderRadius) != 0) {
            return false;
        }
        if (this.isFullscreenDisplayAllowed != that.isFullscreenDisplayAllowed) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        if (this.keepAspectRatio != that.keepAspectRatio) {
            return false;
        }
        if (this.requireConnectivity != that.requireConnectivity) {
            return false;
        }
        return this.url.equals(that.url);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.dismissButtonColor;
        result = 31 * result + this.backgroundColor;
        result = 31 * result + (this.borderRadius != 0.0f ? Float.floatToIntBits(this.borderRadius) : 0);
        result = 31 * result + (this.isFullscreenDisplayAllowed ? 1 : 0);
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + (this.keepAspectRatio ? 1 : 0);
        result = 31 * result + (this.requireConnectivity ? 1 : 0);
        return result;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public static Builder newBuilder(@NonNull HtmlDisplayContent displayContent) {
        return new Builder(displayContent);
    }

    public float getBorderRadius() {
        return this.borderRadius;
    }

    @Dimension
    public long getWidth() {
        return this.width;
    }

    @Dimension
    public long getHeight() {
        return this.height;
    }

    public boolean getAspectRatioLock() {
        return this.keepAspectRatio;
    }

    public boolean getRequireConnectivity() {
        return this.requireConnectivity;
    }

    public boolean isFullscreenDisplayAllowed() {
        return this.isFullscreenDisplayAllowed;
    }

    public static class Builder {
        private String url;
        private int dismissButtonColor = -16777216;
        private int backgroundColor = -1;
        private float borderRadius;
        private boolean isFullscreenDisplayAllowed;
        private int width;
        private int height;
        private boolean keepAspectRatio;
        private boolean requireConnectivity = true;

        private Builder() {
        }

        private Builder(@NonNull HtmlDisplayContent displayContent) {
            this.url = displayContent.url;
            this.dismissButtonColor = displayContent.dismissButtonColor;
            this.backgroundColor = displayContent.backgroundColor;
            this.width = displayContent.width;
            this.height = displayContent.height;
            this.keepAspectRatio = displayContent.keepAspectRatio;
        }

        @NonNull
        public Builder setUrl(@NonNull String url) {
            this.url = url;
            return this;
        }

        @NonNull
        public Builder setDismissButtonColor(@ColorInt int color) {
            this.dismissButtonColor = color;
            return this;
        }

        @NonNull
        public Builder setBackgroundColor(@ColorInt int color) {
            this.backgroundColor = color;
            return this;
        }

        @NonNull
        public Builder setBorderRadius(@FloatRange(from=0.0) float borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        @NonNull
        public Builder setAllowFullscreenDisplay(boolean isFullscreenDisplayAllowed) {
            this.isFullscreenDisplayAllowed = isFullscreenDisplayAllowed;
            return this;
        }

        @NonNull
        public Builder setSize(@Dimension int width, @Dimension int height, boolean keepAspectRatio) {
            this.width = width;
            this.height = height;
            this.keepAspectRatio = keepAspectRatio;
            return this;
        }

        @NonNull
        public Builder setRequireConnectivity(boolean requireConnectivity) {
            this.requireConnectivity = requireConnectivity;
            return this;
        }

        @NonNull
        public HtmlDisplayContent build() {
            Checks.checkArgument((this.borderRadius >= 0.0f ? 1 : 0) != 0, (String)"Border radius must be >= 0");
            Checks.checkArgument((this.url != null ? 1 : 0) != 0, (String)"Missing URL");
            return new HtmlDisplayContent(this);
        }
    }
}

