/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.html;

import android.net.Uri;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.UALog;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.InAppMessageWebViewClient;
import com.urbanairship.javascript.NativeBridge;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonValue;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class HtmlWebViewClient
extends InAppMessageWebViewClient {
    private static final String DISMISS_COMMAND = "dismiss";

    public HtmlWebViewClient(@NonNull InAppMessage message) {
        super(message);
    }

    @VisibleForTesting
    protected HtmlWebViewClient(@NonNull NativeBridge nativeBridge, @NonNull InAppMessage message) {
        super(nativeBridge, message);
    }

    public abstract void onMessageDismissed(@NonNull JsonValue var1);

    protected void onAirshipCommand(@NonNull WebView webView, @NonNull String command, @NonNull Uri uri) {
        if (!command.equals(DISMISS_COMMAND)) {
            return;
        }
        String path = uri.getEncodedPath();
        if (path != null) {
            String[] components = path.split("/");
            if (components.length > 1) {
                try {
                    JsonValue value = JsonValue.parseString((String)Uri.decode((String)components[1]));
                    this.onMessageDismissed(value);
                }
                catch (JsonException e) {
                    UALog.e((String)"Unable to decode message resolution from JSON.", (Object[])new Object[]{e});
                }
            } else {
                UALog.e((String)"Unable to decode message resolution, invalid path", (Object[])new Object[0]);
            }
        } else {
            UALog.e((String)"Unable to decode message resolution, missing path", (Object[])new Object[0]);
        }
    }
}

