/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.layout;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.UrlAllowList;
import com.urbanairship.actions.ActionRunRequest;
import com.urbanairship.actions.ActionRunRequestFactory;
import com.urbanairship.actions.PermissionResultReceiver;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.ThomasListener;
import com.urbanairship.android.layout.display.DisplayException;
import com.urbanairship.android.layout.display.DisplayRequest;
import com.urbanairship.android.layout.info.LayoutInfo;
import com.urbanairship.android.layout.info.ViewInfo;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.android.layout.reporting.FormInfo;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.android.layout.reporting.PagerData;
import com.urbanairship.android.layout.util.ImageCache;
import com.urbanairship.android.layout.util.UrlInfo;
import com.urbanairship.app.ActivityMonitor;
import com.urbanairship.iam.DisplayHandler;
import com.urbanairship.iam.ForegroundDisplayAdapter;
import com.urbanairship.iam.InAppActionUtils;
import com.urbanairship.iam.InAppActivityMonitor;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.InAppMessageWebViewClient;
import com.urbanairship.iam.ResolutionInfo;
import com.urbanairship.iam.assets.Assets;
import com.urbanairship.iam.events.InAppReportingEvent;
import com.urbanairship.iam.layout.AirshipLayoutDisplayContent;
import com.urbanairship.json.JsonValue;
import com.urbanairship.permission.Permission;
import com.urbanairship.permission.PermissionStatus;
import com.urbanairship.util.Network;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AirshipLayoutDisplayAdapter
extends ForegroundDisplayAdapter {
    private static final DisplayRequestCallback DEFAULT_CALLBACK = Thomas::prepareDisplay;
    private final InAppMessage message;
    private final AirshipLayoutDisplayContent displayContent;
    private final DisplayRequestCallback prepareDisplayCallback;
    private final Network network;
    private final UrlAllowList urlAllowList;
    private final List<UrlInfo> urlInfoList;
    private final Map<String, String> assetCacheMap = new HashMap<String, String>();
    private DisplayRequest displayRequest;

    @VisibleForTesting
    AirshipLayoutDisplayAdapter(@NonNull InAppMessage message, @NonNull AirshipLayoutDisplayContent displayContent, @NonNull DisplayRequestCallback prepareDisplayCallback, @NonNull UrlAllowList urlAllowList, @NonNull Network network) {
        this.message = message;
        this.displayContent = displayContent;
        this.prepareDisplayCallback = prepareDisplayCallback;
        this.urlAllowList = urlAllowList;
        this.network = network;
        this.urlInfoList = UrlInfo.from((ViewInfo)displayContent.getPayload().getView());
    }

    @NonNull
    public static AirshipLayoutDisplayAdapter newAdapter(@NonNull InAppMessage message) {
        AirshipLayoutDisplayContent displayContent = (AirshipLayoutDisplayContent)message.getDisplayContent();
        if (displayContent == null) {
            throw new IllegalArgumentException("Invalid message for adapter: " + message);
        }
        return new AirshipLayoutDisplayAdapter(message, displayContent, DEFAULT_CALLBACK, UAirship.shared().getUrlAllowList(), Network.shared());
    }

    @Override
    public int onPrepare(@NonNull Context context, @NonNull Assets assets) {
        this.assetCacheMap.clear();
        for (UrlInfo urlInfo : this.urlInfoList) {
            File file;
            if (urlInfo.getType() == UrlInfo.UrlType.WEB_PAGE && !this.urlAllowList.isAllowed(urlInfo.getUrl(), 2)) {
                UALog.e((String)"Url not allowed: %s. Unable to display message %s.", (Object[])new Object[]{urlInfo.getUrl(), this.message.getName()});
                return 2;
            }
            if (urlInfo.getType() != UrlInfo.UrlType.IMAGE || !(file = assets.file(urlInfo.getUrl())).exists()) continue;
            this.assetCacheMap.put(urlInfo.getUrl(), Uri.fromFile((File)file).toString());
        }
        try {
            this.displayRequest = this.prepareDisplayCallback.prepareDisplay(this.displayContent.getPayload());
        }
        catch (DisplayException e) {
            UALog.e((String)"Unable to display layout", (Object[])new Object[]{e});
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isReady(@NonNull Context context) {
        if (!super.isReady(context)) {
            return false;
        }
        boolean isConnected = this.network.isConnected(context);
        for (UrlInfo urlInfo : this.urlInfoList) {
            switch (urlInfo.getType()) {
                case VIDEO: 
                case WEB_PAGE: {
                    if (isConnected) break;
                    UALog.e((String)"Message not ready. Device is not connected and the message contains a webpage or video.", (Object[])new Object[]{urlInfo.getUrl(), this.message});
                    return false;
                }
                case IMAGE: {
                    if (this.assetCacheMap.get(urlInfo.getUrl()) != null || isConnected) break;
                    UALog.e((String)"Message not ready. Device is not connected and the message contains a webpage or video.", (Object[])new Object[]{urlInfo.getUrl(), this.message});
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void onDisplay(@NonNull Context context, @NonNull DisplayHandler displayHandler) {
        this.displayRequest.setListener((ThomasListener)new Listener(this.message, displayHandler)).setImageCache((ImageCache)new AssetImageCache(this.assetCacheMap)).setInAppActivityMonitor((ActivityMonitor)InAppActivityMonitor.shared(context)).setWebViewClientFactory(() -> new InAppMessageWebViewClient(this.message)).display(context);
    }

    @Override
    public void onFinish(@NonNull Context context) {
    }

    private static class PagerSummary {
        @Nullable
        private PagerData pagerData;
        private final List<InAppReportingEvent.PageViewSummary> pageViewSummaries = new ArrayList<InAppReportingEvent.PageViewSummary>();
        private long pageUpdateTime;

        private PagerSummary() {
        }

        private void updatePagerData(PagerData data, long updateTime) {
            this.pageFinished(updateTime);
            this.pagerData = data;
            this.pageUpdateTime = updateTime;
        }

        private void pageFinished(long updateTime) {
            if (this.pagerData != null) {
                long duration = updateTime - this.pageUpdateTime;
                InAppReportingEvent.PageViewSummary summary = new InAppReportingEvent.PageViewSummary(this.pagerData.getIndex(), this.pagerData.getPageId(), duration);
                this.pageViewSummaries.add(summary);
            }
        }
    }

    private static class Listener
    implements ThomasListener {
        private final InAppMessage message;
        private final DisplayHandler displayHandler;
        private final String scheduleId;
        private final Set<String> completedPagers = new HashSet<String>();
        private final Map<String, PagerSummary> pagerSummaryMap = new HashMap<String, PagerSummary>();
        private final Map<String, Map<Integer, Integer>> pagerViewCounts = new HashMap<String, Map<Integer, Integer>>();

        private Listener(@NonNull InAppMessage message, @NonNull DisplayHandler displayHandler) {
            this.message = message;
            this.displayHandler = displayHandler;
            this.scheduleId = displayHandler.getScheduleId();
        }

        public void onPageView(@NonNull PagerData pagerData, @Nullable LayoutData layoutData, long displayedAt) {
            try {
                PagerSummary summary;
                int viewCount = this.updatePageViewCount(pagerData);
                InAppReportingEvent viewed = InAppReportingEvent.pageView(this.scheduleId, this.message, pagerData, viewCount).setLayoutData(layoutData);
                this.displayHandler.addEvent(viewed);
                if (pagerData.isCompleted() && !this.completedPagers.contains(pagerData.getIdentifier())) {
                    this.completedPagers.add(pagerData.getIdentifier());
                    InAppReportingEvent completed = InAppReportingEvent.pagerCompleted(this.scheduleId, this.message, pagerData).setLayoutData(layoutData);
                    this.displayHandler.addEvent(completed);
                }
                if ((summary = this.pagerSummaryMap.get(pagerData.getIdentifier())) == null) {
                    summary = new PagerSummary();
                    this.pagerSummaryMap.put(pagerData.getIdentifier(), summary);
                }
                summary.updatePagerData(pagerData, displayedAt);
            }
            catch (IllegalArgumentException e) {
                UALog.e((String)"pageView InAppReportingEvent is not valid!", (Object[])new Object[]{e});
            }
        }

        public void onPageSwipe(@NonNull PagerData pagerData, int toPageIndex, @NonNull String toPageId, int fromPageIndex, @NonNull String fromPageId, @Nullable LayoutData layoutData) {
            try {
                InAppReportingEvent event = InAppReportingEvent.pageSwipe(this.scheduleId, this.message, pagerData, toPageIndex, toPageId, fromPageIndex, fromPageId).setLayoutData(layoutData);
                this.displayHandler.addEvent(event);
            }
            catch (IllegalArgumentException e) {
                UALog.e((String)"pageSwipe InAppReportingEvent is not valid!", (Object[])new Object[]{e});
            }
        }

        public void onButtonTap(@NonNull String buttonId, @Nullable JsonValue reportingMetadata, @Nullable LayoutData layoutData) {
            try {
                InAppReportingEvent event = InAppReportingEvent.buttonTap(this.scheduleId, this.message, buttonId, reportingMetadata).setLayoutData(layoutData);
                this.displayHandler.addEvent(event);
            }
            catch (IllegalArgumentException e) {
                UALog.e((String)"buttonTap InAppReportingEvent is not valid!", (Object[])new Object[]{e});
            }
        }

        public void onDismiss(long displayTime) {
            try {
                ResolutionInfo resolutionInfo = ResolutionInfo.dismissed();
                InAppReportingEvent event = InAppReportingEvent.resolution(this.scheduleId, this.message, displayTime, resolutionInfo);
                this.sendPageSummaryEvents(null, displayTime);
                this.displayHandler.addEvent(event);
                this.displayHandler.notifyFinished(resolutionInfo);
            }
            catch (IllegalArgumentException e) {
                UALog.e((String)"dismissed info for resolution InAppReportingEvent is not valid!", (Object[])new Object[]{e});
            }
        }

        public void onDismiss(@NonNull String buttonId, @Nullable String buttonDescription, boolean cancel, long displayTime, @Nullable LayoutData layoutData) {
            try {
                ResolutionInfo resolutionInfo = ResolutionInfo.buttonPressed(buttonId, buttonDescription, cancel);
                InAppReportingEvent event = InAppReportingEvent.resolution(this.scheduleId, this.message, displayTime, resolutionInfo).setLayoutData(layoutData);
                this.sendPageSummaryEvents(layoutData, displayTime);
                this.displayHandler.addEvent(event);
                this.displayHandler.notifyFinished(resolutionInfo);
                if (cancel) {
                    this.displayHandler.cancelFutureDisplays();
                }
            }
            catch (IllegalArgumentException e) {
                UALog.e((String)"buttonPressed info for resolution InAppReportingEvent is not valid!", (Object[])new Object[]{e});
            }
        }

        public void onFormResult(@NonNull FormData.BaseForm formData, @Nullable LayoutData layoutData) {
            try {
                InAppReportingEvent event = InAppReportingEvent.formResult(this.scheduleId, this.message, formData).setLayoutData(layoutData);
                this.displayHandler.addEvent(event);
            }
            catch (IllegalArgumentException e) {
                UALog.e((String)"formResult InAppReportingEvent is not valid!", (Object[])new Object[]{e});
            }
        }

        public void onFormDisplay(@NonNull FormInfo formInfo, @Nullable LayoutData layoutData) {
            try {
                InAppReportingEvent event = InAppReportingEvent.formDisplay(this.scheduleId, this.message, formInfo).setLayoutData(layoutData);
                this.displayHandler.addEvent(event);
            }
            catch (IllegalArgumentException e) {
                UALog.e((String)"formDisplay InAppReportingEvent is not valid!", (Object[])new Object[]{e});
            }
        }

        public void onRunActions(@NonNull Map<String, JsonValue> actions, final @Nullable LayoutData layoutData) {
            PermissionResultReceiver permissionResultReceiver = new PermissionResultReceiver(new Handler(Looper.getMainLooper())){

                public void onResult(@NonNull Permission permission, @NonNull PermissionStatus before, @NonNull PermissionStatus after) {
                    try {
                        InAppReportingEvent event = InAppReportingEvent.permissionResultEvent(scheduleId, message, permission, before, after).setLayoutData(layoutData);
                        displayHandler.addEvent(event);
                    }
                    catch (IllegalArgumentException e) {
                        UALog.e((String)"permissionResultEvent InAppReportingEvent is not valid!", (Object[])new Object[]{e});
                    }
                }
            };
            InAppActionUtils.runActions(actions, new ActionRunRequestFactory(actionName -> {
                Bundle bundle = new Bundle();
                bundle.putParcelable("com.urbanairship.actions.PromptPermissionActionReceiver", (Parcelable)permissionResultReceiver);
                return ActionRunRequest.createRequest((String)actionName).setMetadata(bundle);
            }));
        }

        public void onPagerGesture(@NonNull String gestureId, @Nullable JsonValue reportingMetadata, @NonNull LayoutData state) {
            try {
                InAppReportingEvent event = InAppReportingEvent.pagerGesture(this.scheduleId, this.message, gestureId, reportingMetadata).setLayoutData(state);
                this.displayHandler.addEvent(event);
            }
            catch (IllegalArgumentException e) {
                UALog.e((String)"pagerGesture InAppReportingEvent is not valid!", (Object[])new Object[]{e});
            }
        }

        public void onPagerAutomatedAction(@NonNull String actionId, @Nullable JsonValue reportingMetadata, @NonNull LayoutData state) {
            try {
                InAppReportingEvent event = InAppReportingEvent.pagerAction(this.scheduleId, this.message, actionId, reportingMetadata).setLayoutData(state);
                this.displayHandler.addEvent(event);
            }
            catch (IllegalArgumentException e) {
                UALog.e((String)"onPagerAutomatedAction InAppReportingEvent is not valid!", (Object[])new Object[]{e});
            }
        }

        private int updatePageViewCount(@NonNull PagerData data) {
            Map<Integer, Integer> pageViews;
            if (!this.pagerViewCounts.containsKey(data.getIdentifier())) {
                this.pagerViewCounts.put(data.getIdentifier(), new HashMap(data.getCount()));
            }
            if ((pageViews = this.pagerViewCounts.get(data.getIdentifier())) != null && !pageViews.containsKey(data.getIndex())) {
                pageViews.put(data.getIndex(), 0);
            }
            Integer count = pageViews != null ? pageViews.get(data.getIndex()) : Integer.valueOf(0);
            count = count != null ? count + 1 : 1;
            if (pageViews != null) {
                pageViews.put(data.getIndex(), count);
            }
            return count;
        }

        private void sendPageSummaryEvents(@Nullable LayoutData layoutData, long displayTime) {
            for (Map.Entry<String, PagerSummary> summaryEntry : this.pagerSummaryMap.entrySet()) {
                PagerSummary summary = summaryEntry.getValue();
                summary.pageFinished(displayTime);
                if (summary.pagerData == null) continue;
                try {
                    InAppReportingEvent event = InAppReportingEvent.pagerSummary(this.scheduleId, this.message, summary.pagerData, summary.pageViewSummaries).setLayoutData(layoutData);
                    this.displayHandler.addEvent(event);
                }
                catch (IllegalArgumentException e) {
                    UALog.e((String)"pagerSummary InAppReportingEvent is not valid!", (Object[])new Object[]{e});
                }
            }
        }
    }

    private static class AssetImageCache
    implements ImageCache {
        private final Map<String, String> assetCacheMap;

        private AssetImageCache(Map<String, String> assetCacheMap) {
            this.assetCacheMap = assetCacheMap;
        }

        @Nullable
        public String get(@NonNull String url) {
            return this.assetCacheMap.get(url);
        }
    }

    @VisibleForTesting
    static interface DisplayRequestCallback {
        public DisplayRequest prepareDisplay(@NonNull LayoutInfo var1) throws DisplayException;
    }
}

