/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.layout;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.util.ObjectsCompat;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.info.LayoutInfo;
import com.urbanairship.iam.DisplayContent;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonValue;

public class AirshipLayoutDisplayContent
implements DisplayContent {
    private static final String LAYOUT_KEY = "layout";
    private final JsonValue json;
    private final LayoutInfo payload;

    private AirshipLayoutDisplayContent(@NonNull JsonValue json, @NonNull LayoutInfo basePayload) {
        this.json = json;
        this.payload = basePayload;
    }

    @NonNull
    public static AirshipLayoutDisplayContent fromJson(@NonNull JsonValue value) throws JsonException {
        LayoutInfo basePayload = new LayoutInfo(value.optMap().opt(LAYOUT_KEY).optMap());
        if (!Thomas.isValid((LayoutInfo)basePayload)) {
            throw new JsonException("Invalid payload.");
        }
        return new AirshipLayoutDisplayContent(value, basePayload);
    }

    @NonNull
    public JsonValue toJsonValue() {
        return this.json;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutInfo getPayload() {
        return this.payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AirshipLayoutDisplayContent that = (AirshipLayoutDisplayContent)o;
        return ObjectsCompat.equals((Object)this.json, (Object)that.json);
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.json});
    }
}

