/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.modal;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewStub;
import android.webkit.WebChromeClient;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.urbanairship.automation.R;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.InAppActionUtils;
import com.urbanairship.iam.InAppMessageActivity;
import com.urbanairship.iam.ResolutionInfo;
import com.urbanairship.iam.modal.ModalDisplayContent;
import com.urbanairship.iam.view.BackgroundDrawableBuilder;
import com.urbanairship.iam.view.BoundedLinearLayout;
import com.urbanairship.iam.view.InAppButtonLayout;
import com.urbanairship.iam.view.InAppViewUtils;
import com.urbanairship.iam.view.MediaView;
import com.urbanairship.webkit.AirshipWebChromeClient;

public class ModalActivity
extends InAppMessageActivity
implements InAppButtonLayout.ButtonClickListener {
    private MediaView mediaView;

    @Override
    protected void onCreateMessage(@Nullable Bundle savedInstanceState) {
        float borderRadius;
        if (this.getMessage() == null) {
            this.finish();
            return;
        }
        final ModalDisplayContent displayContent = (ModalDisplayContent)this.getMessage().getDisplayContent();
        if (displayContent == null) {
            this.finish();
            return;
        }
        if (displayContent.isFullscreenDisplayAllowed() && this.getResources().getBoolean(R.bool.ua_iam_modal_allow_fullscreen_display)) {
            borderRadius = 0.0f;
            this.setTheme(R.style.UrbanAirship_InAppModal_Activity_Fullscreen);
            this.setContentView(R.layout.ua_iam_modal_fullscreen);
        } else {
            borderRadius = displayContent.getBorderRadius();
            this.setContentView(R.layout.ua_iam_modal);
        }
        String template = this.normalizeTemplate(displayContent);
        ViewStub content = (ViewStub)this.findViewById(R.id.modal_content);
        content.setLayoutResource(this.getTemplate(template));
        content.inflate();
        BoundedLinearLayout modal = (BoundedLinearLayout)this.findViewById(R.id.modal);
        TextView heading = (TextView)this.findViewById(R.id.heading);
        TextView body = (TextView)this.findViewById(R.id.body);
        InAppButtonLayout buttonLayout = (InAppButtonLayout)this.findViewById(R.id.buttons);
        this.mediaView = (MediaView)this.findViewById(R.id.media);
        Button footer = (Button)this.findViewById(R.id.footer);
        ImageButton dismiss = (ImageButton)this.findViewById(R.id.dismiss);
        if (displayContent.getHeading() != null) {
            InAppViewUtils.applyTextInfo(heading, displayContent.getHeading());
            if ("center".equals(displayContent.getHeading().getAlignment())) {
                this.normalizeHorizontalPadding(heading);
            }
        } else {
            heading.setVisibility(8);
        }
        if (displayContent.getBody() != null) {
            InAppViewUtils.applyTextInfo(body, displayContent.getBody());
        } else {
            body.setVisibility(8);
        }
        if (displayContent.getMedia() != null) {
            this.mediaView.setChromeClient((WebChromeClient)new AirshipWebChromeClient((Activity)this));
            InAppViewUtils.loadMediaInfo(this.mediaView, displayContent.getMedia(), this.getMessageAssets());
        } else {
            this.mediaView.setVisibility(8);
        }
        if (!displayContent.getButtons().isEmpty()) {
            buttonLayout.setButtons(displayContent.getButtonLayout(), displayContent.getButtons());
            buttonLayout.setButtonClickListener(this);
        } else {
            buttonLayout.setVisibility(8);
        }
        if (displayContent.getFooter() != null) {
            InAppViewUtils.applyButtonInfo(footer, displayContent.getFooter(), 0);
            footer.setOnClickListener(new View.OnClickListener(){

                public void onClick(@NonNull View view) {
                    ModalActivity.this.onButtonClicked(view, displayContent.getFooter());
                }
            });
        } else {
            footer.setVisibility(8);
        }
        Drawable background = BackgroundDrawableBuilder.newBuilder((Context)this).setBackgroundColor(displayContent.getBackgroundColor()).setBorderRadius(borderRadius, 15).build();
        ViewCompat.setBackground((View)modal, (Drawable)background);
        if (borderRadius > 0.0f) {
            modal.setClipPathBorderRadius(borderRadius);
        }
        Drawable dismissDrawable = DrawableCompat.wrap((Drawable)dismiss.getDrawable()).mutate();
        DrawableCompat.setTint((Drawable)dismissDrawable, (int)displayContent.getDismissButtonColor());
        dismiss.setImageDrawable(dismissDrawable);
        dismiss.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (ModalActivity.this.getDisplayHandler() != null) {
                    ModalActivity.this.getDisplayHandler().finished(ResolutionInfo.dismissed(), ModalActivity.this.getDisplayTime());
                }
                ModalActivity.this.finish();
            }
        });
    }

    @Override
    public void onButtonClicked(@NonNull View view, @NonNull ButtonInfo buttonInfo) {
        if (this.getDisplayHandler() == null) {
            return;
        }
        InAppActionUtils.runActions(buttonInfo);
        this.getDisplayHandler().finished(ResolutionInfo.buttonPressed(buttonInfo), this.getDisplayTime());
        this.finish();
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.mediaView.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
        this.mediaView.onPause();
    }

    @LayoutRes
    protected int getTemplate(@NonNull String template) {
        switch (template) {
            case "header_body_media": {
                return R.layout.ua_iam_modal_header_body_media;
            }
            case "header_media_body": {
                return R.layout.ua_iam_modal_header_media_body;
            }
        }
        return R.layout.ua_iam_modal_media_header_body;
    }

    @NonNull
    protected String normalizeTemplate(@NonNull ModalDisplayContent displayContent) {
        String template = displayContent.getTemplate();
        if (displayContent.getMedia() == null) {
            return "header_body_media";
        }
        if (template.equals("header_media_body") && displayContent.getHeading() == null && displayContent.getMedia() != null) {
            return "media_header_body";
        }
        return template;
    }

    private void normalizeHorizontalPadding(@NonNull TextView view) {
        int padding = Math.max(ViewCompat.getPaddingEnd((View)view), ViewCompat.getPaddingStart((View)view));
        view.setPadding(padding, view.getPaddingTop(), padding, view.getPaddingBottom());
        view.requestLayout();
    }
}

