/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.modal;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.urbanairship.iam.DisplayHandler;
import com.urbanairship.iam.InAppMessage;
import com.urbanairship.iam.MediaDisplayAdapter;
import com.urbanairship.iam.modal.ModalActivity;
import com.urbanairship.iam.modal.ModalDisplayContent;

public class ModalAdapter
extends MediaDisplayAdapter {
    private ModalAdapter(@NonNull InAppMessage message, @NonNull ModalDisplayContent displayContent) {
        super(message, displayContent.getMedia());
    }

    @NonNull
    public static ModalAdapter newAdapter(@NonNull InAppMessage message) {
        ModalDisplayContent displayContent = (ModalDisplayContent)message.getDisplayContent();
        if (displayContent == null) {
            throw new IllegalArgumentException("Invalid message for adapter: " + message);
        }
        return new ModalAdapter(message, displayContent);
    }

    @Override
    public void onDisplay(@NonNull Context context, @NonNull DisplayHandler displayHandler) {
        Intent intent = new Intent(context, ModalActivity.class).setFlags(0x10000000).putExtra("display_handler", (Parcelable)displayHandler).putExtra("in_app_message", (Parcelable)this.getMessage()).putExtra("assets", (Parcelable)this.getAssets());
        context.startActivity(intent);
    }
}

