/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.modal;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.DisplayContent;
import com.urbanairship.iam.MediaInfo;
import com.urbanairship.iam.TextInfo;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import com.urbanairship.util.Checks;
import com.urbanairship.util.ColorUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class ModalDisplayContent
implements DisplayContent {
    @NonNull
    public static final String TEMPLATE_HEADER_MEDIA_BODY = "header_media_body";
    @NonNull
    public static final String TEMPLATE_MEDIA_HEADER_BODY = "media_header_body";
    @NonNull
    public static final String TEMPLATE_HEADER_BODY_MEDIA = "header_body_media";
    private final TextInfo heading;
    private final TextInfo body;
    private final MediaInfo media;
    private final List<ButtonInfo> buttons;
    private final String buttonLayout;
    private final String template;
    private final int backgroundColor;
    private final int dismissButtonColor;
    private final ButtonInfo footer;
    private final float borderRadius;
    private final boolean isFullscreenDisplayAllowed;
    public static final int MAX_BUTTONS = 2;

    private ModalDisplayContent(@NonNull Builder builder) {
        this.heading = builder.heading;
        this.body = builder.body;
        this.media = builder.media;
        this.buttonLayout = builder.buttonLayout;
        this.buttons = builder.buttons;
        this.template = builder.template;
        this.backgroundColor = builder.backgroundColor;
        this.dismissButtonColor = builder.dismissButtonColor;
        this.footer = builder.footer;
        this.borderRadius = builder.borderRadius;
        this.isFullscreenDisplayAllowed = builder.isFullscreenDisplayAllowed;
    }

    @NonNull
    public static ModalDisplayContent fromJson(@NonNull JsonValue value) throws JsonException {
        JsonMap content = value.optMap();
        Builder builder = ModalDisplayContent.newBuilder();
        if (content.containsKey("heading")) {
            builder.setHeading(TextInfo.fromJson(content.opt("heading")));
        }
        if (content.containsKey("body")) {
            builder.setBody(TextInfo.fromJson(content.opt("body")));
        }
        if (content.containsKey("media")) {
            builder.setMedia(MediaInfo.fromJson(content.opt("media")));
        }
        if (content.containsKey("buttons")) {
            Object buttonJsonList = content.opt("buttons").getList();
            if (buttonJsonList == null) {
                throw new JsonException("Buttons must be an array of button objects.");
            }
            builder.setButtons(ButtonInfo.fromJson((JsonList)buttonJsonList));
        }
        if (content.containsKey("button_layout")) {
            switch (content.opt("button_layout").optString()) {
                case "stacked": {
                    builder.setButtonLayout("stacked");
                    break;
                }
                case "joined": {
                    builder.setButtonLayout("joined");
                    break;
                }
                case "separate": {
                    builder.setButtonLayout("separate");
                    break;
                }
                default: {
                    throw new JsonException("Unexpected button layout: " + content.opt("button_layout"));
                }
            }
        }
        if (content.containsKey("footer")) {
            builder.setFooter(ButtonInfo.fromJson(content.opt("footer")));
        }
        if (content.containsKey("template")) {
            switch (content.opt("template").optString()) {
                case "header_body_media": {
                    builder.setTemplate(TEMPLATE_HEADER_BODY_MEDIA);
                    break;
                }
                case "header_media_body": {
                    builder.setTemplate(TEMPLATE_HEADER_MEDIA_BODY);
                    break;
                }
                case "media_header_body": {
                    builder.setTemplate(TEMPLATE_MEDIA_HEADER_BODY);
                    break;
                }
                default: {
                    throw new JsonException("Unexpected template: " + content.opt("template"));
                }
            }
        }
        if (content.containsKey("background_color")) {
            try {
                builder.setBackgroundColor(Color.parseColor((String)content.opt("background_color").optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid background color: " + content.opt("background_color"), (Throwable)e);
            }
        }
        if (content.containsKey("dismiss_button_color")) {
            try {
                builder.setDismissButtonColor(Color.parseColor((String)content.opt("dismiss_button_color").optString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonException("Invalid dismiss button color: " + content.opt("dismiss_button_color"), (Throwable)e);
            }
        }
        if (content.containsKey("border_radius")) {
            if (!content.opt("border_radius").isNumber()) {
                throw new JsonException("Border radius must be a number " + content.opt("border_radius"));
            }
            builder.setBorderRadius(content.opt("border_radius").getFloat(0.0f));
        }
        if (content.containsKey("allow_fullscreen_display")) {
            if (!content.opt("allow_fullscreen_display").isBoolean()) {
                throw new JsonException("Allow fullscreen display must be a boolean " + content.opt("allow_fullscreen_display"));
            }
            builder.setAllowFullscreenDisplay(content.opt("allow_fullscreen_display").getBoolean(false));
        }
        try {
            return builder.build();
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("Invalid in-app message modal JSON: " + content, (Throwable)e);
        }
    }

    @NonNull
    public JsonValue toJsonValue() {
        return JsonMap.newBuilder().put("heading", (JsonSerializable)this.heading).put("body", (JsonSerializable)this.body).put("media", (JsonSerializable)this.media).put("buttons", (JsonSerializable)JsonValue.wrapOpt(this.buttons)).put("button_layout", this.buttonLayout).put("template", this.template).put("background_color", ColorUtils.convertToString((int)this.backgroundColor)).put("dismiss_button_color", ColorUtils.convertToString((int)this.dismissButtonColor)).put("footer", (JsonSerializable)this.footer).put("border_radius", (double)this.borderRadius).put("allow_fullscreen_display", this.isFullscreenDisplayAllowed).build().toJsonValue();
    }

    public boolean isFullscreenDisplayAllowed() {
        return this.isFullscreenDisplayAllowed;
    }

    @Nullable
    public TextInfo getHeading() {
        return this.heading;
    }

    @Nullable
    public TextInfo getBody() {
        return this.body;
    }

    @Nullable
    public MediaInfo getMedia() {
        return this.media;
    }

    @NonNull
    public List<ButtonInfo> getButtons() {
        return this.buttons;
    }

    @NonNull
    public String getButtonLayout() {
        return this.buttonLayout;
    }

    @NonNull
    public String getTemplate() {
        return this.template;
    }

    @ColorInt
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @ColorInt
    public int getDismissButtonColor() {
        return this.dismissButtonColor;
    }

    @Nullable
    public ButtonInfo getFooter() {
        return this.footer;
    }

    public float getBorderRadius() {
        return this.borderRadius;
    }

    @NonNull
    public String toString() {
        return this.toJsonValue().toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModalDisplayContent that = (ModalDisplayContent)o;
        if (this.backgroundColor != that.backgroundColor) {
            return false;
        }
        if (this.dismissButtonColor != that.dismissButtonColor) {
            return false;
        }
        if (Float.compare(that.borderRadius, this.borderRadius) != 0) {
            return false;
        }
        if (this.isFullscreenDisplayAllowed != that.isFullscreenDisplayAllowed) {
            return false;
        }
        if (this.heading != null ? !this.heading.equals(that.heading) : that.heading != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.media != null ? !this.media.equals(that.media) : that.media != null) {
            return false;
        }
        if (this.buttons != null ? !this.buttons.equals(that.buttons) : that.buttons != null) {
            return false;
        }
        if (!this.buttonLayout.equals(that.buttonLayout)) {
            return false;
        }
        if (!this.template.equals(that.template)) {
            return false;
        }
        return this.footer != null ? this.footer.equals(that.footer) : that.footer == null;
    }

    public int hashCode() {
        int result = this.heading != null ? this.heading.hashCode() : 0;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.media != null ? this.media.hashCode() : 0);
        result = 31 * result + (this.buttons != null ? this.buttons.hashCode() : 0);
        result = 31 * result + this.buttonLayout.hashCode();
        result = 31 * result + this.template.hashCode();
        result = 31 * result + this.backgroundColor;
        result = 31 * result + this.dismissButtonColor;
        result = 31 * result + (this.footer != null ? this.footer.hashCode() : 0);
        result = 31 * result + (this.borderRadius != 0.0f ? Float.floatToIntBits(this.borderRadius) : 0);
        result = 31 * result + (this.isFullscreenDisplayAllowed ? 1 : 0);
        return result;
    }

    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @NonNull
    public static Builder newBuilder(@NonNull ModalDisplayContent displayContent) {
        return new Builder(displayContent);
    }

    public static class Builder {
        private TextInfo heading;
        private TextInfo body;
        private MediaInfo media;
        private List<ButtonInfo> buttons = new ArrayList<ButtonInfo>();
        private String buttonLayout = "separate";
        private String template = "header_media_body";
        private int backgroundColor = -1;
        private int dismissButtonColor = -16777216;
        private ButtonInfo footer;
        private float borderRadius;
        private boolean isFullscreenDisplayAllowed;

        private Builder() {
        }

        private Builder(@NonNull ModalDisplayContent displayContent) {
            this.heading = displayContent.heading;
            this.body = displayContent.body;
            this.media = displayContent.media;
            this.buttonLayout = displayContent.buttonLayout;
            this.buttons = displayContent.buttons;
            this.template = displayContent.template;
            this.backgroundColor = displayContent.backgroundColor;
            this.dismissButtonColor = displayContent.dismissButtonColor;
            this.footer = displayContent.footer;
            this.borderRadius = displayContent.borderRadius;
            this.isFullscreenDisplayAllowed = displayContent.isFullscreenDisplayAllowed;
        }

        @NonNull
        public Builder setHeading(@Nullable TextInfo heading) {
            this.heading = heading;
            return this;
        }

        @NonNull
        public Builder setBody(@Nullable TextInfo body) {
            this.body = body;
            return this;
        }

        @NonNull
        public Builder addButton(@NonNull ButtonInfo buttonInfo) {
            this.buttons.add(buttonInfo);
            return this;
        }

        @NonNull
        public Builder setButtons(@Nullable @Size(max=2L) List<ButtonInfo> buttons) {
            this.buttons.clear();
            if (buttons != null) {
                this.buttons.addAll(buttons);
            }
            return this;
        }

        @NonNull
        public Builder setMedia(@Nullable MediaInfo media) {
            this.media = media;
            return this;
        }

        @NonNull
        public Builder setButtonLayout(@NonNull String buttonLayout) {
            this.buttonLayout = buttonLayout;
            return this;
        }

        @NonNull
        public Builder setTemplate(@NonNull String template) {
            this.template = template;
            return this;
        }

        @NonNull
        public Builder setBackgroundColor(@ColorInt int color) {
            this.backgroundColor = color;
            return this;
        }

        @NonNull
        public Builder setDismissButtonColor(@ColorInt int color) {
            this.dismissButtonColor = color;
            return this;
        }

        @NonNull
        public Builder setFooter(@Nullable ButtonInfo footer) {
            this.footer = footer;
            return this;
        }

        @NonNull
        public Builder setBorderRadius(@FloatRange(from=0.0) float borderRadius) {
            this.borderRadius = borderRadius;
            return this;
        }

        @NonNull
        public Builder setAllowFullscreenDisplay(boolean isFullscreenDisplayAllowed) {
            this.isFullscreenDisplayAllowed = isFullscreenDisplayAllowed;
            return this;
        }

        @NonNull
        public ModalDisplayContent build() {
            Checks.checkArgument((this.borderRadius >= 0.0f ? 1 : 0) != 0, (String)"Border radius must be >= 0");
            Checks.checkArgument((this.buttons.size() <= 2 ? 1 : 0) != 0, (String)"Modal allows a max of 2 buttons");
            Checks.checkArgument((this.heading != null || this.body != null ? 1 : 0) != 0, (String)"Either the body or heading must be defined.");
            return new ModalDisplayContent(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Template {
    }
}

