/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.urbanairship.iam.view.BorderRadius;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class BackgroundDrawableBuilder {
    private int backgroundColor = 0;
    private Integer strokeColor;
    private Integer pressedColor;
    private int strokeWidthDps = 0;
    private float borderRadiusDps = 0.0f;
    private int borderRadiusFlag;
    private final Context context;

    @NonNull
    public static BackgroundDrawableBuilder newBuilder(@NonNull Context context) {
        return new BackgroundDrawableBuilder(context);
    }

    private BackgroundDrawableBuilder(@NonNull Context context) {
        this.context = context;
    }

    @NonNull
    public BackgroundDrawableBuilder setPressedColor(@ColorInt int color) {
        this.pressedColor = color;
        return this;
    }

    @NonNull
    public BackgroundDrawableBuilder setBackgroundColor(@ColorInt int color) {
        this.backgroundColor = color;
        return this;
    }

    @NonNull
    public BackgroundDrawableBuilder setBorderRadius(float dps, int borderRadiusFlag) {
        this.borderRadiusFlag = borderRadiusFlag;
        this.borderRadiusDps = dps;
        return this;
    }

    @NonNull
    public BackgroundDrawableBuilder setStrokeWidth(@Dimension int dps) {
        this.strokeWidthDps = dps;
        return this;
    }

    @NonNull
    public BackgroundDrawableBuilder setStrokeColor(@ColorInt int strokeColor) {
        this.strokeColor = strokeColor;
        return this;
    }

    @NonNull
    public Drawable build() {
        int strokeWidthPixels = Math.round(TypedValue.applyDimension((int)1, (float)this.strokeWidthDps, (DisplayMetrics)this.context.getResources().getDisplayMetrics()));
        int strokeColor = this.strokeColor == null ? this.backgroundColor : this.strokeColor;
        float borderRadiusPixels = TypedValue.applyDimension((int)1, (float)this.borderRadiusDps, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
        float[] borderRadii = BorderRadius.createRadiiArray(borderRadiusPixels, this.borderRadiusFlag);
        GradientDrawable background = new GradientDrawable();
        background.setShape(0);
        background.setCornerRadii(borderRadii);
        background.setColor(this.backgroundColor);
        background.setStroke(strokeWidthPixels, strokeColor);
        if (this.pressedColor == null) {
            return background;
        }
        ColorStateList list = ColorStateList.valueOf((int)this.pressedColor);
        RoundRectShape rectShape = new RoundRectShape(borderRadii, null, null);
        ShapeDrawable mask = new ShapeDrawable((Shape)rectShape);
        return new RippleDrawable(list, (Drawable)background, (Drawable)mask);
    }
}

