/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.view;

import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class BorderRadius {
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_RIGHT = 4;
    public static final int BOTTOM_LEFT = 8;
    public static final int ALL = 15;
    public static final int LEFT = 9;
    public static final int RIGHT = 6;
    public static final int TOP = 3;
    public static final int BOTTOM = 12;

    @NonNull
    public static float[] createRadiiArray(float pixels, int borderRadiusFlag) {
        float[] radii = new float[8];
        if ((borderRadiusFlag & 1) == 1) {
            radii[0] = pixels;
            radii[1] = pixels;
        }
        if ((borderRadiusFlag & 2) == 2) {
            radii[2] = pixels;
            radii[3] = pixels;
        }
        if ((borderRadiusFlag & 4) == 4) {
            radii[4] = pixels;
            radii[5] = pixels;
        }
        if ((borderRadiusFlag & 8) == 8) {
            radii[6] = pixels;
            radii[7] = pixels;
        }
        return radii;
    }

    public static void applyBorderRadiusPadding(@NonNull View view, final float borderRadius, final int borderRadiusFlag) {
        if (view.getWidth() == 0) {
            final WeakReference<View> weakReference = new WeakReference<View>(view);
            view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    View view = (View)weakReference.get();
                    if (view != null) {
                        BorderRadius.applyBorderRadiusPadding(view, borderRadius, borderRadiusFlag);
                        view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    }
                    return false;
                }
            });
        }
        float borderRadiusPixels = TypedValue.applyDimension((int)1, (float)borderRadius, (DisplayMetrics)view.getResources().getDisplayMetrics());
        borderRadiusPixels = Math.min(borderRadiusPixels, (float)Math.min(view.getHeight() / 2, view.getWidth() / 2));
        float x = borderRadiusPixels * (float)Math.sin(Math.toRadians(45.0));
        float y = borderRadiusPixels * (float)Math.sin(Math.toRadians(45.0));
        int borderPaddingX = Math.round(borderRadiusPixels - x);
        int borderPaddingY = Math.round(borderRadiusPixels - y);
        int paddingLeft = 0;
        int paddingRight = 0;
        int paddingTop = 0;
        int paddingBottom = 0;
        if ((borderRadiusFlag & 1) == 1) {
            paddingLeft = borderPaddingX;
            paddingTop = borderPaddingY;
        }
        if ((borderRadiusFlag & 2) == 2) {
            paddingRight = borderPaddingX;
            paddingTop = borderPaddingY;
        }
        if ((borderRadiusFlag & 4) == 4) {
            paddingRight = borderPaddingX;
            paddingBottom = borderPaddingY;
        }
        if ((borderRadiusFlag & 8) == 8) {
            paddingLeft = borderPaddingX;
            paddingBottom = borderPaddingY;
        }
        view.setPadding(view.getPaddingLeft() + paddingLeft, view.getPaddingTop() + paddingTop, view.getPaddingRight() + paddingRight, view.getPaddingBottom() + paddingBottom);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BorderRadiusFlag {
    }
}

