/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.urbanairship.iam.view.BoundedViewDelegate;
import com.urbanairship.iam.view.ClippableViewDelegate;

public class BoundedFrameLayout
extends FrameLayout {
    private final BoundedViewDelegate boundedViewDelegate;
    private final ClippableViewDelegate clippableViewDelegate;

    public BoundedFrameLayout(@NonNull Context context) {
        this(context, null);
    }

    public BoundedFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BoundedFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.boundedViewDelegate = new BoundedViewDelegate(context, attrs, defStyle, 0);
        this.clippableViewDelegate = new ClippableViewDelegate();
    }

    @RequiresApi(value=21)
    public BoundedFrameLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle, int defResStyle) {
        super(context, attrs, defStyle, defResStyle);
        this.boundedViewDelegate = new BoundedViewDelegate(context, attrs, defStyle, defResStyle);
        this.clippableViewDelegate = new ClippableViewDelegate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(this.boundedViewDelegate.getWidthMeasureSpec(widthMeasureSpec), this.boundedViewDelegate.getHeightMeasureSpec(heightMeasureSpec));
    }

    @MainThread
    @RequiresApi(api=19)
    public void setClipPathBorderRadius(float borderRadius) {
        this.clippableViewDelegate.setClipPathBorderRadius((View)this, borderRadius);
    }
}

