/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.R;

class BoundedViewDelegate {
    private int maxWidth;
    private int maxHeight;

    BoundedViewDelegate(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle, int defResStyle) {
        if (attrs != null) {
            TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.UrbanAirshipLayout, defStyle, defResStyle);
            this.maxWidth = attributes.getDimensionPixelSize(R.styleable.UrbanAirshipLayout_urbanAirshipMaxWidth, 0);
            this.maxHeight = attributes.getDimensionPixelSize(R.styleable.UrbanAirshipLayout_urbanAirshipMaxHeight, 0);
            attributes.recycle();
        }
    }

    int getWidthMeasureSpec(int widthMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.maxWidth > 0 && this.maxWidth < width) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxWidth, (int)View.MeasureSpec.getMode((int)widthMeasureSpec));
        }
        return widthMeasureSpec;
    }

    int getHeightMeasureSpec(int heightMeasureSpec) {
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.maxHeight > 0 && this.maxHeight < height) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxHeight, (int)View.MeasureSpec.getMode((int)heightMeasureSpec));
        }
        return heightMeasureSpec;
    }
}

