/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.view;

import android.graphics.Outline;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;

class ClippableViewDelegate {
    ClippableViewDelegate() {
    }

    @MainThread
    @RequiresApi(api=19)
    void setClipPathBorderRadius(@NonNull View view, float borderRadius) {
        final float borderRadiusPixels = TypedValue.applyDimension((int)1, (float)borderRadius, (DisplayMetrics)view.getResources().getDisplayMetrics());
        if (borderRadiusPixels == 0.0f) {
            view.setClipToOutline(false);
            view.setOutlineProvider(ViewOutlineProvider.BOUNDS);
        } else {
            view.setClipToOutline(true);
            view.setOutlineProvider(new ViewOutlineProvider(){

                @RequiresApi(api=21)
                public void getOutline(@NonNull View view, @NonNull Outline outline) {
                    outline.setRoundRect(0, 0, view.getRight() - view.getLeft(), view.getBottom() - view.getTop(), borderRadiusPixels);
                }
            });
        }
    }
}

