/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.urbanairship.automation.R;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.view.BoundedLinearLayout;
import com.urbanairship.iam.view.InAppViewUtils;
import java.util.List;

public class InAppButtonLayout
extends BoundedLinearLayout {
    private int stackedSpaceHeight;
    private int separatedSpaceWidth;
    private int buttonLayoutResourceId;
    private ButtonClickListener buttonClickListener;

    public InAppButtonLayout(@NonNull Context context) {
        this(context, null);
    }

    public InAppButtonLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public InAppButtonLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs, defStyle, 0);
    }

    @RequiresApi(value=21)
    public InAppButtonLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle, int defResStyle) {
        super(context, attrs, defStyle, defResStyle);
        this.init(context, attrs, defStyle, defResStyle);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle, int defResStyle) {
        if (attrs != null) {
            TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.UrbanAirshipInAppButtonLayout, defStyle, defResStyle);
            this.stackedSpaceHeight = attributes.getDimensionPixelSize(R.styleable.UrbanAirshipInAppButtonLayout_urbanAirshipStackedSpaceHeight, 0);
            this.separatedSpaceWidth = attributes.getDimensionPixelSize(R.styleable.UrbanAirshipInAppButtonLayout_urbanAirshipSeparatedSpaceWidth, 0);
            this.buttonLayoutResourceId = attributes.getResourceId(R.styleable.UrbanAirshipInAppButtonLayout_urbanAirshipButtonLayoutResourceId, 0);
            attributes.recycle();
        }
    }

    public void setButtonClickListener(@Nullable ButtonClickListener buttonClickListener) {
        this.buttonClickListener = buttonClickListener;
    }

    public void setButtons(@NonNull String layout2, @NonNull List<ButtonInfo> buttonInfos) {
        boolean isStacked = false;
        boolean isJoined = false;
        if (buttonInfos.size() > 1) {
            isStacked = "stacked".equals(layout2);
            isJoined = "joined".equals(layout2);
        }
        this.removeAllViews();
        this.setOrientation(isStacked ? 1 : 0);
        this.setMeasureWithLargestChildEnabled(true);
        for (int i = 0; i < buttonInfos.size(); ++i) {
            LinearLayout.LayoutParams params;
            int radiusFlag = 0;
            final ButtonInfo buttonInfo = buttonInfos.get(i);
            if (isJoined) {
                if (i == 0) {
                    radiusFlag = 9;
                } else if (i == buttonInfos.size() - 1) {
                    radiusFlag = 6;
                }
            } else {
                radiusFlag = 15;
            }
            Button button = (Button)LayoutInflater.from((Context)this.getContext()).inflate(this.buttonLayoutResourceId, (ViewGroup)this, false);
            InAppViewUtils.applyButtonInfo(button, buttonInfo, radiusFlag);
            if (isStacked) {
                params = new LinearLayout.LayoutParams(-1, 0);
                params.weight = 1.0f;
                button.setLayoutParams((ViewGroup.LayoutParams)params);
                if (i > 0) {
                    params.setMargins(0, this.stackedSpaceHeight, 0, 0);
                }
            } else {
                params = new LinearLayout.LayoutParams(0, -1);
                params.weight = 1.0f;
                button.setLayoutParams((ViewGroup.LayoutParams)params);
                if (!isJoined && i > 0) {
                    params.setMargins(this.separatedSpaceWidth, 0, 0, 0);
                    params.setMarginStart(this.separatedSpaceWidth);
                }
            }
            this.addView((View)button);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(@NonNull View view) {
                    if (InAppButtonLayout.this.buttonClickListener != null) {
                        InAppButtonLayout.this.buttonClickListener.onButtonClicked(view, buttonInfo);
                    }
                }
            });
        }
        this.requestLayout();
    }

    public static interface ButtonClickListener {
        public void onButtonClicked(@NonNull View var1, @NonNull ButtonInfo var2);
    }
}

