/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.CharacterStyle;
import android.text.style.ImageSpan;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.urbanairship.Fonts;
import com.urbanairship.UALog;
import com.urbanairship.automation.R;
import com.urbanairship.iam.ButtonInfo;
import com.urbanairship.iam.MediaInfo;
import com.urbanairship.iam.TextInfo;
import com.urbanairship.iam.assets.Assets;
import com.urbanairship.iam.view.BackgroundDrawableBuilder;
import com.urbanairship.iam.view.MediaView;
import com.urbanairship.json.JsonMap;
import com.urbanairship.util.UAStringUtil;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class InAppViewUtils {
    private static final float PRESSED_ALPHA_PERCENT = 0.2f;
    private static final float DEFAULT_BORDER_RADIUS = 0.0f;

    public static void applyButtonInfo(@NonNull Button button, @NonNull ButtonInfo buttonInfo, int borderRadiusFlag, int strokeWidthInDps) {
        InAppViewUtils.applyButtonTextInfo((TextView)button, buttonInfo.getLabel());
        int textColor = buttonInfo.getLabel().getColor() == null ? button.getCurrentTextColor() : buttonInfo.getLabel().getColor().intValue();
        int backgroundColor = buttonInfo.getBackgroundColor() == null ? 0 : buttonInfo.getBackgroundColor();
        int pressedColor = ColorUtils.setAlphaComponent((int)textColor, (int)Math.round((float)Color.alpha((int)textColor) * 0.2f));
        int strokeColor = buttonInfo.getBorderColor() == null ? backgroundColor : buttonInfo.getBorderColor();
        float borderRadius = buttonInfo.getBorderRadius() == null ? 0.0f : buttonInfo.getBorderRadius().floatValue();
        Drawable background = BackgroundDrawableBuilder.newBuilder(button.getContext()).setBackgroundColor(backgroundColor).setBorderRadius(borderRadius, borderRadiusFlag).setPressedColor(pressedColor).setStrokeColor(strokeColor).setStrokeWidth(strokeWidthInDps).build();
        ViewCompat.setBackground((View)button, (Drawable)background);
    }

    public static void applyButtonInfo(@NonNull Button button, @NonNull ButtonInfo buttonInfo, int borderRadiusFlag) {
        int strokeWidth = button.getContext().getResources().getInteger(R.integer.ua_iam_button_stroke_width_dps);
        InAppViewUtils.applyButtonInfo(button, buttonInfo, borderRadiusFlag, strokeWidth);
    }

    public static void applyButtonTextInfo(@NonNull TextView textView, @NonNull TextInfo textInfo) {
        InAppViewUtils.applyTextInfo(textView, textInfo, 17);
    }

    public static void applyTextInfo(@NonNull TextView textView, @NonNull TextInfo textInfo) {
        InAppViewUtils.applyTextInfo(textView, textInfo, 1);
    }

    private static void applyTextInfo(@NonNull TextView textView, @NonNull TextInfo textInfo, int centerGravity) {
        Typeface typeface;
        if (textInfo.getFontSize() != null) {
            textView.setTextSize(textInfo.getFontSize().floatValue());
        }
        if (textInfo.getColor() != null) {
            textView.setTextColor(textInfo.getColor().intValue());
        }
        Drawable drawable = null;
        int drawableId = textInfo.getDrawable(textView.getContext());
        if (drawableId != 0) {
            try {
                drawable = ContextCompat.getDrawable((Context)textView.getContext(), (int)drawableId);
            }
            catch (Resources.NotFoundException e) {
                UALog.d((String)("Drawable " + drawableId + " no longer exists."), (Object[])new Object[0]);
            }
        }
        if (drawable != null) {
            int size = Math.round(textView.getTextSize());
            int color = textView.getCurrentTextColor();
            try {
                SpannableString text;
                Drawable wrappedDrawable = DrawableCompat.wrap((Drawable)drawable).mutate();
                wrappedDrawable.setBounds(0, 0, size, size);
                wrappedDrawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.MULTIPLY));
                CenteredImageSpan imageSpan = new CenteredImageSpan(wrappedDrawable);
                if (textInfo.getText() == null) {
                    text = new SpannableString((CharSequence)" ");
                    text.setSpan((Object)imageSpan, 0, 1, 33);
                } else {
                    text = new SpannableString((CharSequence)("  " + textInfo.getText()));
                    text.setSpan((Object)imageSpan, 0, 1, 33);
                    text.setSpan((Object)new RemoveUnderlineSpan(), 1, 2, 33);
                }
                textView.setText((CharSequence)text);
            }
            catch (Resources.NotFoundException e) {
                UALog.e((Throwable)e, (String)"Unable to find button drawable.", (Object[])new Object[0]);
                textView.setText((CharSequence)textInfo.getText());
            }
        } else {
            textView.setText((CharSequence)textInfo.getText());
        }
        int typefaceFlags = textView.getTypeface() == null ? 0 : textView.getTypeface().getStyle();
        int paintFlags = textView.getPaintFlags() | 1 | 0x80;
        Object e = textInfo.getStyles().iterator();
        while (e.hasNext()) {
            String style2;
            switch (style2 = e.next()) {
                case "bold": {
                    typefaceFlags |= 1;
                    break;
                }
                case "italic": {
                    typefaceFlags |= 2;
                    break;
                }
                case "underline": {
                    paintFlags |= 8;
                }
            }
        }
        if (textInfo.getAlignment() != null) {
            switch (textInfo.getAlignment()) {
                case "center": {
                    textView.setGravity(centerGravity);
                    break;
                }
                case "left": {
                    textView.setGravity(0x800003);
                    break;
                }
                case "right": {
                    textView.setGravity(0x800005);
                }
            }
        }
        if ((typeface = InAppViewUtils.getTypeFace(textView.getContext(), textInfo.getFontFamilies())) == null) {
            typeface = textView.getTypeface();
        }
        textView.setTypeface(typeface, typefaceFlags);
        textView.setPaintFlags(paintFlags);
    }

    @Nullable
    private static Typeface getTypeFace(@NonNull Context context, @NonNull List<String> fontFamilies) {
        for (String fontFamily : fontFamilies) {
            Typeface typeface;
            if (UAStringUtil.isEmpty((String)fontFamily) || (typeface = Fonts.shared((Context)context).getFontFamily(fontFamily)) == null) continue;
            return typeface;
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void loadMediaInfo(@NonNull MediaView mediaView, final @NonNull MediaInfo mediaInfo, final @Nullable Assets assets) {
        File cachedFile;
        if (mediaView.getWidth() == 0) {
            final WeakReference<MediaView> weakReference = new WeakReference<MediaView>(mediaView);
            mediaView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    MediaView mediaView = (MediaView)((Object)weakReference.get());
                    if (mediaView != null) {
                        InAppViewUtils.loadMediaInfo(mediaView, mediaInfo, assets);
                        mediaView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    }
                    return false;
                }
            });
            return;
        }
        int width = 16;
        int height = 9;
        String cachedLocation = null;
        if (assets != null && (cachedFile = assets.file(mediaInfo.getUrl())).exists()) {
            JsonMap metadata = assets.getMetadata(mediaInfo.getUrl()).optMap();
            width = metadata.opt("width").getInt(width);
            height = metadata.opt("height").getInt(height);
            cachedLocation = Uri.fromFile((File)cachedFile).toString();
        }
        ViewGroup.LayoutParams params = mediaView.getLayoutParams();
        if (params.height == -2) {
            float scale = (float)mediaView.getWidth() / (float)width;
            params.height = Math.round(scale * (float)height);
        } else {
            float imageRatio = (float)width / (float)height;
            float viewRatio = (float)mediaView.getWidth() / (float)mediaView.getHeight();
            if (imageRatio >= viewRatio) {
                params.height = Math.round((float)mediaView.getWidth() / imageRatio);
            } else {
                params.width = Math.round((float)mediaView.getHeight() * imageRatio);
            }
        }
        mediaView.setLayoutParams(params);
        mediaView.setMediaInfo(mediaInfo, cachedLocation);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(api=21)
    public static float getLargestChildZValue(@NonNull ViewGroup group) {
        float z = 0.0f;
        for (int i = 0; i < group.getChildCount(); ++i) {
            z = Math.max(group.getChildAt(0).getZ(), z);
        }
        return z;
    }

    private static class CenteredImageSpan
    extends ImageSpan {
        public CenteredImageSpan(Drawable drawable) {
            super(drawable);
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            canvas.save();
            Drawable drawable = this.getDrawable();
            int dy = bottom - drawable.getBounds().bottom - paint.getFontMetricsInt().descent / 2;
            canvas.translate(x, (float)dy);
            drawable.draw(canvas);
            canvas.restore();
        }
    }

    private static class RemoveUnderlineSpan
    extends CharacterStyle {
        private RemoveUnderlineSpan() {
        }

        public void updateDrawState(@NonNull TextPaint textPaint) {
            textPaint.setUnderlineText(false);
        }
    }
}

