/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.iam.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.urbanairship.UAirship;
import com.urbanairship.iam.MediaInfo;
import com.urbanairship.images.ImageRequestOptions;
import com.urbanairship.util.ManifestUtils;
import java.lang.ref.WeakReference;
import java.util.Locale;

public class MediaView
extends FrameLayout {
    private WebView webView;
    private WebChromeClient chromeClient;
    private static final String VIDEO_HTML_FORMAT = "<body style=\"margin:0\"><video playsinline controls height=\"100%%\" width=\"100%%\" src=\"%s\"></video></body>";

    public MediaView(@NonNull Context context) {
        this(context, null);
    }

    public MediaView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @RequiresApi(value=21)
    public MediaView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle, int defResStyle) {
        super(context, attrs, defStyle, defResStyle);
    }

    public void setChromeClient(@Nullable WebChromeClient chromeClient) {
        this.chromeClient = chromeClient;
        if (this.webView != null) {
            this.webView.setWebChromeClient(chromeClient);
        }
    }

    public void onPause() {
        if (this.webView != null) {
            this.webView.onPause();
        }
    }

    public void onResume() {
        if (this.webView != null) {
            this.webView.onResume();
        }
    }

    public void setMediaInfo(@NonNull MediaInfo mediaInfo, @Nullable String cachedMediaUrl) {
        this.removeAllViewsInLayout();
        if (this.webView != null) {
            this.webView.stopLoading();
            this.webView.setWebChromeClient(null);
            this.webView.setWebViewClient(null);
            this.webView.destroy();
            this.webView = null;
        }
        switch (mediaInfo.getType()) {
            case "image": {
                ImageView imageView = new ImageView(this.getContext());
                imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                imageView.setAdjustViewBounds(true);
                imageView.setContentDescription((CharSequence)mediaInfo.getDescription());
                this.addView((View)imageView);
                String url = cachedMediaUrl == null ? mediaInfo.getUrl() : cachedMediaUrl;
                UAirship.shared().getImageLoader().load(this.getContext(), imageView, ImageRequestOptions.newBuilder((String)url).build());
                break;
            }
            case "video": 
            case "youtube": {
                this.loadWebView(mediaInfo);
            }
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void loadWebView(final @NonNull MediaInfo mediaInfo) {
        this.webView = new WebView(this.getContext());
        FrameLayout frameLayout = new FrameLayout(this.getContext());
        FrameLayout.LayoutParams webViewLayoutParams = new FrameLayout.LayoutParams(-1, -1);
        webViewLayoutParams.gravity = 17;
        frameLayout.addView((View)this.webView, (ViewGroup.LayoutParams)webViewLayoutParams);
        final ProgressBar progressBar = new ProgressBar(this.getContext());
        progressBar.setIndeterminate(true);
        progressBar.setId(16908301);
        FrameLayout.LayoutParams progressBarLayoutParams = new FrameLayout.LayoutParams(-2, -2);
        progressBarLayoutParams.gravity = 17;
        frameLayout.addView((View)progressBar, (ViewGroup.LayoutParams)progressBarLayoutParams);
        WebSettings settings = this.webView.getSettings();
        settings.setMediaPlaybackRequiresUserGesture(true);
        settings.setJavaScriptEnabled(true);
        if (ManifestUtils.shouldEnableLocalStorage()) {
            settings.setDomStorageEnabled(true);
            settings.setDatabaseEnabled(true);
        }
        final WeakReference<WebView> webViewWeakReference = new WeakReference<WebView>(this.webView);
        Runnable load = new Runnable(){

            @Override
            public void run() {
                WebView webView = (WebView)webViewWeakReference.get();
                if (webView == null) {
                    return;
                }
                if ("video".equals(mediaInfo.getType())) {
                    webView.loadData(String.format(Locale.ROOT, MediaView.VIDEO_HTML_FORMAT, mediaInfo.getUrl()), "text/html", "UTF-8");
                } else {
                    webView.loadUrl(mediaInfo.getUrl());
                }
            }
        };
        this.webView.setWebChromeClient(this.chromeClient);
        this.webView.setContentDescription((CharSequence)mediaInfo.getDescription());
        this.webView.setVisibility(4);
        this.webView.setWebViewClient((WebViewClient)new MediaWebViewClient(load){

            @Override
            protected void onPageFinished(@NonNull WebView webView) {
                webView.setVisibility(0);
                progressBar.setVisibility(8);
            }
        });
        this.addView((View)frameLayout);
        load.run();
    }

    private static abstract class MediaWebViewClient
    extends WebViewClient {
        static final long START_RETRY_DELAY = 1000L;
        private final Runnable onRetry;
        boolean error = false;
        long retryDelay = 1000L;

        private MediaWebViewClient(Runnable onRetry) {
            this.onRetry = onRetry;
        }

        public void onPageFinished(@NonNull WebView view, String url) {
            super.onPageFinished(view, url);
            if (this.error) {
                view.postDelayed(this.onRetry, this.retryDelay);
                this.retryDelay *= 2L;
            } else {
                this.onPageFinished(view);
            }
            this.error = false;
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
            this.error = true;
        }

        protected abstract void onPageFinished(WebView var1);
    }
}

