/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.push.fcm;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.messaging.RemoteMessage;
import com.urbanairship.PendingResult;
import com.urbanairship.push.PushMessage;
import com.urbanairship.push.PushProviderBridge;
import com.urbanairship.push.fcm.FcmPushProvider;
import java.util.concurrent.Future;

public class AirshipFirebaseIntegration {
    @NonNull
    public static Future<Void> processMessage(@NonNull Context context, @NonNull RemoteMessage message) {
        final PendingResult pendingResult = new PendingResult();
        PushProviderBridge.processPush(FcmPushProvider.class, (PushMessage)new PushMessage(message.getData())).execute(context, new Runnable(){

            @Override
            public void run() {
                pendingResult.setResult(null);
            }
        });
        return pendingResult;
    }

    public static void processMessageSync(@NonNull Context context, @NonNull RemoteMessage message) {
        PushProviderBridge.processPush(FcmPushProvider.class, (PushMessage)new PushMessage(message.getData())).executeSync(context);
    }

    @Deprecated
    public static void processNewToken(@NonNull Context context) {
        AirshipFirebaseIntegration.processNewToken(context, null);
    }

    public static void processNewToken(@NonNull Context context, @Nullable String token) {
        PushProviderBridge.requestRegistrationUpdate((Context)context, FcmPushProvider.class, (String)token);
    }

    public static boolean isAirshipPush(@NonNull RemoteMessage message) {
        return new PushMessage(message.getData()).isAirshipPush();
    }
}

