/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.push.fcm;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.messaging.FirebaseMessaging;
import com.urbanairship.AirshipConfigOptions;
import com.urbanairship.AirshipVersionInfo;
import com.urbanairship.UALog;
import com.urbanairship.UAirship;
import com.urbanairship.google.PlayServicesUtils;
import com.urbanairship.push.PushProvider;
import com.urbanairship.util.UAStringUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FcmPushProvider
implements PushProvider,
AirshipVersionInfo {
    public int getPlatform() {
        return 2;
    }

    @NonNull
    public String getDeliveryType() {
        return "fcm";
    }

    @Nullable
    public String getRegistrationToken(@NonNull Context context) throws PushProvider.RegistrationException {
        try {
            return (String)Tasks.await((Task)FcmPushProvider.getFirebaseMessaging().getToken());
        }
        catch (Exception e) {
            throw new PushProvider.RegistrationException("FCM error " + e.getMessage(), true, (Throwable)e);
        }
    }

    public boolean isAvailable(@NonNull Context context) {
        try {
            int playServicesStatus = PlayServicesUtils.isGooglePlayServicesAvailable((Context)context);
            if (0 != playServicesStatus) {
                UALog.i((String)"Google Play services is currently unavailable.", (Object[])new Object[0]);
                return false;
            }
        }
        catch (Exception e) {
            UALog.e((Throwable)e, (String)"Unable to register with FCM.", (Object[])new Object[0]);
            return false;
        }
        return true;
    }

    public boolean isSupported(@NonNull Context context) {
        return PlayServicesUtils.isGooglePlayStoreAvailable((Context)context);
    }

    @NonNull
    public String toString() {
        return "FCM Push Provider " + this.getAirshipVersion();
    }

    @NonNull
    public String getAirshipVersion() {
        return "17.8.0";
    }

    @NonNull
    public String getPackageVersion() {
        return "!SDK-VERSION-STRING!:com.urbanairship.android:urbanairship-core:17.8.0";
    }

    @NonNull
    private static FirebaseMessaging getFirebaseMessaging() throws IllegalStateException {
        AirshipConfigOptions configOptions = UAirship.shared().getAirshipConfigOptions();
        if (UAStringUtil.isEmpty((String)configOptions.fcmFirebaseAppName)) {
            return FirebaseMessaging.getInstance();
        }
        FirebaseApp app = FirebaseApp.getInstance((String)configOptions.fcmFirebaseAppName);
        return (FirebaseMessaging)app.get(FirebaseMessaging.class);
    }
}

