/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout;

import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.android.layout.BannerPresentation;
import com.urbanairship.android.layout.ModalPresentation;
import com.urbanairship.android.layout.display.DisplayArgsLoader;
import com.urbanairship.android.layout.display.DisplayException;
import com.urbanairship.android.layout.display.DisplayRequest;
import com.urbanairship.android.layout.info.LayoutInfo;
import com.urbanairship.android.layout.ui.LayoutBanner;
import com.urbanairship.android.layout.ui.ModalActivity;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Thomas {
    @VisibleForTesting
    static final int MAX_SUPPORTED_VERSION = 2;
    @VisibleForTesting
    static final int MIN_SUPPORTED_VERSION = 1;

    private Thomas() {
    }

    public static boolean isValid(@NonNull LayoutInfo payload) {
        if (payload.getVersion() < 1 || payload.getVersion() > 2) {
            return false;
        }
        return payload.getPresentation() instanceof ModalPresentation || payload.getPresentation() instanceof BannerPresentation;
    }

    @NonNull
    public static DisplayRequest prepareDisplay(@NonNull LayoutInfo payload) throws DisplayException {
        if (!Thomas.isValid(payload)) {
            throw new DisplayException("Payload is not valid: " + payload.getPresentation());
        }
        if (payload.getPresentation() instanceof ModalPresentation) {
            return new DisplayRequest(payload, (context, args) -> {
                Intent intent = new Intent(context, ModalActivity.class).setFlags(0x10000000).putExtra("com.urbanairship.android.layout.ui.EXTRA_DISPLAY_ARGS_LOADER", (Parcelable)DisplayArgsLoader.newLoader(args));
                context.startActivity(intent);
            });
        }
        if (payload.getPresentation() instanceof BannerPresentation) {
            return new DisplayRequest(payload, (context, args) -> {
                LayoutBanner layoutBanner = new LayoutBanner(context, args);
                layoutBanner.display();
            });
        }
        throw new DisplayException("Presentation not supported: " + payload.getPresentation());
    }
}

