/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.display;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.android.layout.display.DisplayArgs;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class DisplayArgsLoader
implements Parcelable {
    private static final Map<String, DisplayArgs> cached = new HashMap<String, DisplayArgs>();
    private final String id;
    public static final Parcelable.Creator<DisplayArgsLoader> CREATOR = new Parcelable.Creator<DisplayArgsLoader>(){

        public DisplayArgsLoader createFromParcel(Parcel in) {
            return new DisplayArgsLoader(in);
        }

        public DisplayArgsLoader[] newArray(int size) {
            return new DisplayArgsLoader[size];
        }
    };

    private DisplayArgsLoader(@Nullable String id) {
        this.id = id;
    }

    private DisplayArgsLoader(Parcel in) {
        this.id = in.readString();
    }

    public static DisplayArgsLoader newLoader(@NonNull DisplayArgs args) {
        String loaderId = UUID.randomUUID().toString();
        cached.put(loaderId, args);
        return new DisplayArgsLoader(loaderId);
    }

    public void dispose() {
        cached.remove(this.id);
    }

    @NonNull
    public DisplayArgs getDisplayArgs() throws LoadException {
        DisplayArgs args = cached.get(this.id);
        if (args == null) {
            throw new LoadException("Layout args no longer available");
        }
        return args;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
    }

    public static class LoadException
    extends Exception {
        public LoadException(String message) {
            super(message);
        }
    }
}

